/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.Writer;
import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.pdf417.encoder.Compaction;
import com.ailiwean.core.zxing.core.pdf417.encoder.Dimensions;
import com.ailiwean.core.zxing.core.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    private static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;
    private static final int WHITE_SPACE = 30;

    private static BitMatrix bitMatrixFromBitArray(byte[][] byArray, int n2) {
        int n3 = byArray[0].length;
        int n4 = n2 * 2;
        BitMatrix bitMatrix = new BitMatrix(n3 + n4, byArray.length + n4);
        bitMatrix.clear();
        n4 = bitMatrix.getHeight() - n2 - 1;
        n3 = 0;
        while (n3 < byArray.length) {
            byte[] byArray2 = byArray[n3];
            for (int i3 = 0; i3 < byArray[0].length; ++i3) {
                if (byArray2[i3] != 1) continue;
                bitMatrix.set(i3 + n2, n4);
            }
            ++n3;
            --n4;
        }
        return bitMatrix;
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 object, String object2, int n2, int n3, int n4, int n5) throws WriterException {
        ((PDF417)object).generateBarcodeLogic((String)object2, n2);
        object2 = ((PDF417)object).getBarcodeMatrix().getScaledMatrix(1, 4);
        n2 = n4 > n3 ? 1 : 0;
        int n6 = ((Object)object2[0]).length < ((Object)object2).length ? 1 : 0;
        if (n2 != n6) {
            object2 = PDF417Writer.rotateArray((byte[][])object2);
            n2 = 1;
        } else {
            n2 = 0;
        }
        n3 = Math.min(n3 / ((Object)object2[0]).length, n4 / ((Object)object2).length);
        if (n3 > 1) {
            object = object2 = (Object)((PDF417)object).getBarcodeMatrix().getScaledMatrix(n3, n3 * 4);
            if (n2 != 0) {
                object = PDF417Writer.rotateArray((byte[][])object2);
            }
            return PDF417Writer.bitMatrixFromBitArray((byte[][])object, n5);
        }
        return PDF417Writer.bitMatrixFromBitArray((byte[][])object2, n5);
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            int n2 = byArray.length;
            for (int i4 = 0; i4 < byArray[0].length; ++i4) {
                byArray2[i4][n2 - i3 - 1] = byArray[i3][i4];
            }
        }
        return byArray2;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String charSequence, BarcodeFormat object, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (object == BarcodeFormat.PDF_417) {
            object = new PDF417();
            int n4 = 30;
            int n5 = 2;
            if (map != null) {
                if (map.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                    ((PDF417)object).setCompact(Boolean.parseBoolean(map.get((Object)EncodeHintType.PDF417_COMPACT).toString()));
                }
                if (map.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                    ((PDF417)object).setCompaction(Compaction.valueOf(map.get((Object)EncodeHintType.PDF417_COMPACTION).toString()));
                }
                if (map.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                    Dimensions dimensions = (Dimensions)map.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                    ((PDF417)object).setDimensions(dimensions.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
                }
                if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                    n4 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
                }
                if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                    n5 = Integer.parseInt(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
                }
                if (map.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                    ((PDF417)object).setEncoding(Charset.forName(map.get((Object)EncodeHintType.CHARACTER_SET).toString()));
                }
            } else {
                n5 = 2;
                n4 = 30;
            }
            return PDF417Writer.bitMatrixFromEncoder((PDF417)object, (String)charSequence, n5, n2, n3, n4);
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Can only encode PDF_417, but got ");
        ((StringBuilder)charSequence).append(object);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }
}

