/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.multi.MultipleBarcodeReader;
import com.ailiwean.core.zxing.core.pdf417.PDF417ResultMetadata;
import com.ailiwean.core.zxing.core.pdf417.decoder.PDF417ScanningDecoder;
import com.ailiwean.core.zxing.core.pdf417.detector.Detector;
import com.ailiwean.core.zxing.core.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];

    private static Result[] decode(BinaryBitmap object, Map<DecodeHintType, ?> object2, boolean bl) throws NotFoundException, FormatException, ChecksumException {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        object2 = Detector.detect((BinaryBitmap)((Object)object), object2, bl);
        for (ResultPoint[] resultPointArray : ((PDF417DetectorResult)object2).getPoints()) {
            Object object3 = PDF417ScanningDecoder.decode(((PDF417DetectorResult)object2).getBits(), resultPointArray[4], resultPointArray[5], resultPointArray[6], resultPointArray[7], PDF417Reader.getMinCodewordWidth(resultPointArray), PDF417Reader.getMaxCodewordWidth(resultPointArray));
            Result object32 = new Result(((DecoderResult)object3).getText(), ((DecoderResult)object3).getRawBytes(), resultPointArray, BarcodeFormat.PDF_417);
            object32.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ((DecoderResult)object3).getECLevel());
            object3 = (PDF417ResultMetadata)((DecoderResult)object3).getOther();
            if (object3 != null) {
                object32.putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, object3);
            }
            arrayList.add(object32);
        }
        return arrayList.toArray(EMPTY_RESULT_ARRAY);
    }

    private static int getMaxCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.max(Math.max(PDF417Reader.getMaxWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMaxWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.max(PDF417Reader.getMaxWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMaxWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    private static int getMaxWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint != null && resultPoint2 != null) {
            return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
        }
        return 0;
    }

    private static int getMinCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.min(Math.min(PDF417Reader.getMinWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMinWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.min(PDF417Reader.getMinWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMinWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    private static int getMinWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint != null && resultPoint2 != null) {
            return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException, ChecksumException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap resultArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException, ChecksumException {
        if ((resultArray = PDF417Reader.decode((BinaryBitmap)resultArray, map, false)).length != 0 && resultArray[0] != null) {
            return resultArray[0];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap resultArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        try {
            resultArray = PDF417Reader.decode((BinaryBitmap)resultArray, map, true);
            return resultArray;
        }
        catch (ChecksumException | FormatException readerException) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    @Override
    public void reset() {
    }
}

