/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned.rss.expanded.decoders;

import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.BlockParsedResult;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.CurrentParsingState;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.DecodedChar;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.DecodedInformation;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.DecodedNumeric;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.DecodedObject;
import com.ailiwean.core.zxing.core.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final StringBuilder buffer;
    private final CurrentParsingState current = new CurrentParsingState();
    private final BitArray information;

    GeneralAppIdDecoder(BitArray bitArray) {
        this.buffer = new StringBuilder();
        this.information = bitArray;
    }

    private DecodedChar decodeAlphanumeric(int n2) {
        int n3;
        int n4 = this.extractNumericValueFromBitArray(n2, 5);
        if (n4 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n4 >= 5 && n4 < 15) {
            return new DecodedChar(n2 + 5, (char)(n4 + 48 - 5));
        }
        n4 = this.extractNumericValueFromBitArray(n2, 6);
        if (n4 >= 32 && n4 < 58) {
            return new DecodedChar(n2 + 6, (char)(n4 + 33));
        }
        switch (n4) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Decoding invalid alphanumeric value: ");
                stringBuilder.append(n4);
                throw new IllegalStateException(stringBuilder.toString());
            }
            case 62: {
                n3 = n4 = 47;
                break;
            }
            case 61: {
                n3 = n4 = 46;
                break;
            }
            case 60: {
                n3 = n4 = 45;
                break;
            }
            case 59: {
                n3 = n4 = 44;
                break;
            }
            case 58: {
                n3 = n4 = 42;
            }
        }
        return new DecodedChar(n2 + 6, (char)n3);
    }

    private DecodedChar decodeIsoIec646(int n2) throws FormatException {
        int n3;
        int n4 = this.extractNumericValueFromBitArray(n2, 5);
        if (n4 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n4 >= 5 && n4 < 15) {
            return new DecodedChar(n2 + 5, (char)(n4 + 48 - 5));
        }
        n4 = this.extractNumericValueFromBitArray(n2, 7);
        if (n4 >= 64 && n4 < 90) {
            return new DecodedChar(n2 + 7, (char)(n4 + 1));
        }
        if (n4 >= 90 && n4 < 116) {
            return new DecodedChar(n2 + 7, (char)(n4 + 7));
        }
        switch (this.extractNumericValueFromBitArray(n2, 8)) {
            default: {
                throw FormatException.getFormatInstance();
            }
            case 252: {
                n3 = n4 = 32;
                break;
            }
            case 251: {
                n3 = n4 = 95;
                break;
            }
            case 250: {
                n3 = n4 = 63;
                break;
            }
            case 249: {
                n3 = n4 = 62;
                break;
            }
            case 248: {
                n3 = n4 = 61;
                break;
            }
            case 247: {
                n3 = n4 = 60;
                break;
            }
            case 246: {
                n3 = n4 = 59;
                break;
            }
            case 245: {
                n3 = n4 = 58;
                break;
            }
            case 244: {
                n3 = n4 = 47;
                break;
            }
            case 243: {
                n3 = n4 = 46;
                break;
            }
            case 242: {
                n3 = n4 = 45;
                break;
            }
            case 241: {
                n3 = n4 = 44;
                break;
            }
            case 240: {
                n3 = n4 = 43;
                break;
            }
            case 239: {
                n3 = n4 = 42;
                break;
            }
            case 238: {
                n3 = n4 = 41;
                break;
            }
            case 237: {
                n3 = n4 = 40;
                break;
            }
            case 236: {
                n3 = n4 = 39;
                break;
            }
            case 235: {
                n3 = n4 = 38;
                break;
            }
            case 234: {
                n3 = n4 = 37;
                break;
            }
            case 233: {
                n3 = n4 = 34;
                break;
            }
            case 232: {
                n3 = n4 = 33;
            }
        }
        return new DecodedChar(n2 + 8, (char)n3);
    }

    private DecodedNumeric decodeNumeric(int n2) throws FormatException {
        int n3 = n2 + 7;
        if (n3 > this.information.getSize()) {
            if ((n2 = this.extractNumericValueFromBitArray(n2, 4)) == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            return new DecodedNumeric(this.information.getSize(), n2 - 1, 10);
        }
        n2 = this.extractNumericValueFromBitArray(n2, 7) - 8;
        return new DecodedNumeric(n3, n2 / 11, n2 % 11);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n2, int n3) {
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5 = n4;
            if (bitArray.get(n2 + i3)) {
                n5 = n4 | 1 << n3 - i3 - 1;
            }
            n4 = n5;
        }
        return n4;
    }

    private boolean isAlphaOr646ToNumericLatch(int n2) {
        int n3 = n2 + 3;
        if (n3 > this.information.getSize()) {
            return false;
        }
        while (n2 < n3) {
            if (this.information.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isAlphaTo646ToAlphaLatch(int n2) {
        int n3;
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i3 = 0; i3 < 5 && (n3 = i3 + n2) < this.information.getSize(); ++i3) {
            if (!(i3 == 2 ? !this.information.get(n2 + 2) : this.information.get(n3))) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n2) {
        int n3;
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i3 = 0; i3 < 4 && (n3 = i3 + n2) < this.information.getSize(); ++i3) {
            if (!this.information.get(n3)) continue;
            return false;
        }
        return true;
    }

    private boolean isStillAlpha(int n2) {
        int n3 = this.information.getSize();
        boolean bl = false;
        if (n2 + 5 > n3) {
            return false;
        }
        n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 6 > this.information.getSize()) {
            return false;
        }
        n2 = this.extractNumericValueFromBitArray(n2, 6);
        boolean bl2 = bl;
        if (n2 >= 16) {
            bl2 = bl;
            if (n2 < 63) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean isStillIsoIec646(int n2) {
        int n3 = this.information.getSize();
        boolean bl = false;
        if (n2 + 5 > n3) {
            return false;
        }
        n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 7 > this.information.getSize()) {
            return false;
        }
        n3 = this.extractNumericValueFromBitArray(n2, 7);
        if (n3 >= 64 && n3 < 116) {
            return true;
        }
        if (n2 + 8 > this.information.getSize()) {
            return false;
        }
        n2 = this.extractNumericValueFromBitArray(n2, 8);
        boolean bl2 = bl;
        if (n2 >= 232) {
            bl2 = bl;
            if (n2 < 253) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean isStillNumeric(int n2) {
        int n3;
        int n4 = this.information.getSize();
        boolean bl = true;
        if (n2 + 7 > n4) {
            if (n2 + 4 > this.information.getSize()) {
                bl = false;
            }
            return bl;
        }
        for (n4 = n2; n4 < (n3 = n2 + 3); ++n4) {
            if (!this.information.get(n4)) continue;
            return true;
        }
        return this.information.get(n3);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (this.isStillAlpha(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeAlphanumeric(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                return new BlockParsedResult(new DecodedInformation(this.current.getPosition(), this.buffer.toString()), true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setIsoIec646();
        }
        return new BlockParsedResult(false);
    }

    private DecodedInformation parseBlocks() throws FormatException {
        BlockParsedResult blockParsedResult;
        boolean bl;
        int n2;
        do {
            n2 = this.current.getPosition();
            if (this.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl = blockParsedResult.isFinished();
                continue;
            }
            if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl = blockParsedResult.isFinished();
                continue;
            }
            blockParsedResult = this.parseNumericBlock();
            bl = blockParsedResult.isFinished();
        } while (((n2 = n2 != this.current.getPosition() ? 1 : 0) != 0 || bl) && !bl);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (this.isStillIsoIec646(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeIsoIec646(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                return new BlockParsedResult(new DecodedInformation(this.current.getPosition(), this.buffer.toString()), true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setAlpha();
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (this.isStillNumeric(this.current.getPosition())) {
            DecodedObject decodedObject = this.decodeNumeric(this.current.getPosition());
            this.current.setPosition(decodedObject.getNewPosition());
            if (decodedObject.isFirstDigitFNC1()) {
                decodedObject = decodedObject.isSecondDigitFNC1() ? new DecodedInformation(this.current.getPosition(), this.buffer.toString()) : new DecodedInformation(this.current.getPosition(), this.buffer.toString(), decodedObject.getSecondDigit());
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(decodedObject.getFirstDigit());
            if (decodedObject.isSecondDigitFNC1()) {
                return new BlockParsedResult(new DecodedInformation(this.current.getPosition(), this.buffer.toString()), true);
            }
            this.buffer.append(decodedObject.getSecondDigit());
        }
        if (this.isNumericToAlphaNumericLatch(this.current.getPosition())) {
            this.current.setAlpha();
            this.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    String decodeAllCodes(StringBuilder stringBuilder, int n2) throws NotFoundException, FormatException {
        String string2 = null;
        while (true) {
            DecodedInformation decodedInformation;
            if ((string2 = FieldParser.parseFieldsInGeneralPurpose((decodedInformation = this.decodeGeneralPurposeField(n2, string2)).getNewString())) != null) {
                stringBuilder.append(string2);
            }
            string2 = decodedInformation.isRemaining() ? String.valueOf(decodedInformation.getRemainingValue()) : null;
            if (n2 == decodedInformation.getNewPosition()) {
                return stringBuilder.toString();
            }
            n2 = decodedInformation.getNewPosition();
        }
    }

    DecodedInformation decodeGeneralPurposeField(int n2, String object) throws FormatException {
        this.buffer.setLength(0);
        if (object != null) {
            this.buffer.append((String)object);
        }
        this.current.setPosition(n2);
        object = this.parseBlocks();
        if (object != null && ((DecodedInformation)object).isRemaining()) {
            return new DecodedInformation(this.current.getPosition(), this.buffer.toString(), ((DecodedInformation)object).getRemainingValue());
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }

    int extractNumericValueFromBitArray(int n2, int n3) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n2, n3);
    }
}

