/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned.rss;

import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.common.detector.MathUtils;
import com.ailiwean.core.zxing.core.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.2f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.45f;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private final int[] dataCharacterCounters;
    private final int[] decodeFinderCounters = new int[4];
    private final int[] evenCounts;
    private final float[] evenRoundingErrors;
    private final int[] oddCounts;
    private final float[] oddRoundingErrors;

    protected AbstractRSSReader() {
        this.dataCharacterCounters = new int[8];
        this.oddRoundingErrors = new float[4];
        this.evenRoundingErrors = new float[4];
        int[] nArray = this.dataCharacterCounters;
        this.oddCounts = new int[nArray.length / 2];
        this.evenCounts = new int[nArray.length / 2];
    }

    @Deprecated
    protected static int count(int[] nArray) {
        return MathUtils.sum(nArray);
    }

    protected static void decrement(int[] nArray, float[] fArray) {
        float f3 = fArray[0];
        int n2 = 0;
        for (int i3 = 1; i3 < nArray.length; ++i3) {
            float f4 = f3;
            if (fArray[i3] < f3) {
                f4 = fArray[i3];
                n2 = i3;
            }
            f3 = f4;
        }
        nArray[n2] = nArray[n2] - 1;
    }

    protected static void increment(int[] nArray, float[] fArray) {
        float f3 = fArray[0];
        int n2 = 0;
        for (int i3 = 1; i3 < nArray.length; ++i3) {
            float f4 = f3;
            if (fArray[i3] > f3) {
                f4 = fArray[i3];
                n2 = i3;
            }
            f3 = f4;
        }
        nArray[n2] = nArray[n2] + 1;
    }

    protected static boolean isFinderPattern(int[] nArray) {
        boolean bl = false;
        int n2 = nArray[0] + nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        float f3 = (float)n2 / (float)(n3 + n2 + n4);
        boolean bl2 = bl;
        if (f3 >= 0.7916667f) {
            bl2 = bl;
            if (f3 <= 0.89285713f) {
                int n5 = Integer.MIN_VALUE;
                int n6 = nArray.length;
                n4 = Integer.MAX_VALUE;
                for (n3 = 0; n3 < n6; ++n3) {
                    int n7 = nArray[n3];
                    n2 = n5;
                    if (n7 > n5) {
                        n2 = n7;
                    }
                    int n8 = n4;
                    if (n7 < n4) {
                        n8 = n7;
                    }
                    n5 = n2;
                    n4 = n8;
                }
                bl2 = bl;
                if (n5 < n4 * 10) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    protected static int parseFinderValue(int[] nArray, int[][] nArray2) throws NotFoundException {
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            if (!(AbstractRSSReader.patternMatchVariance(nArray, nArray2[i3], 0.45f) < 0.2f)) continue;
            return i3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final int[] getDataCharacterCounters() {
        return this.dataCharacterCounters;
    }

    protected final int[] getDecodeFinderCounters() {
        return this.decodeFinderCounters;
    }

    protected final int[] getEvenCounts() {
        return this.evenCounts;
    }

    protected final float[] getEvenRoundingErrors() {
        return this.evenRoundingErrors;
    }

    protected final int[] getOddCounts() {
        return this.oddCounts;
    }

    protected final float[] getOddRoundingErrors() {
        return this.oddRoundingErrors;
    }
}

