/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.oned.UPCEANReader;
import com.ailiwean.core.zxing.core.oned.UPCEANWriter;
import com.ailiwean.core.zxing.core.oned.UPCEReader;
import java.util.Collection;
import java.util.Collections;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    @Override
    public boolean[] encode(String object) {
        Object object2;
        int n2;
        block10: {
            n2 = ((String)object).length();
            if (n2 != 7) {
                if (n2 == 8) {
                    try {
                        if (!UPCEANReader.checkStandardUPCEANChecksum(UPCEReader.convertUPCEtoUPCA((String)object))) {
                            object = new IllegalArgumentException("Contents do not pass checksum");
                            throw object;
                        }
                        break block10;
                    }
                    catch (FormatException formatException) {
                        throw new IllegalArgumentException("Illegal contents");
                    }
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Requested contents should be 7 or 8 digits long, but got ");
                ((StringBuilder)object).append(n2);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            try {
                n2 = UPCEANReader.getStandardUPCEANChecksum(UPCEReader.convertUPCEtoUPCA((String)object));
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
            }
            catch (FormatException formatException) {
                throw new IllegalArgumentException(formatException);
            }
            ((StringBuilder)object2).append(n2);
            object = ((StringBuilder)object2).toString();
        }
        UPCEWriter.checkNumeric((String)object);
        int n3 = Character.digit(((String)object).charAt(0), 10);
        if (n3 != 0 && n3 != 1) {
            throw new IllegalArgumentException("Number system must be 0 or 1");
        }
        n2 = Character.digit(((String)object).charAt(7), 10);
        int n4 = UPCEReader.NUMSYS_AND_CHECK_DIGIT_PATTERNS[n3][n2];
        object2 = new boolean[51];
        n2 = UPCEWriter.appendPattern((boolean[])object2, 0, UPCEANReader.START_END_PATTERN, true);
        for (n3 = 1; n3 <= 6; ++n3) {
            int n5;
            int n6 = n5 = Character.digit(((String)object).charAt(n3), 10);
            if ((n4 >> 6 - n3 & 1) == 1) {
                n6 = n5 + 10;
            }
            n2 += UPCEWriter.appendPattern((boolean[])object2, n2, UPCEANReader.L_AND_G_PATTERNS[n6], false);
        }
        UPCEWriter.appendPattern((boolean[])object2, n2, UPCEANReader.END_PATTERN, false);
        return object2;
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.UPC_E);
    }
}

