/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.ResultPointCallback;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.EANManufacturerOrgSupport;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import com.ailiwean.core.zxing.core.oned.UPCEANExtensionSupport;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    static final int[] END_PATTERN;
    static final int[][] L_AND_G_PATTERNS;
    static final int[][] L_PATTERNS;
    private static final float MAX_AVG_VARIANCE = 0.48f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    static final int[] MIDDLE_PATTERN;
    static final int[] START_END_PATTERN;
    private final StringBuilder decodeRowStringBuffer = new StringBuilder(20);
    private final EANManufacturerOrgSupport eanManSupport;
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();

    static {
        START_END_PATTERN = new int[]{1, 1, 1};
        MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
        END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
        int[] nArray = new int[]{3, 1, 1, 2};
        L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, nArray};
        L_AND_G_PATTERNS = new int[20][];
        System.arraycopy(L_PATTERNS, 0, L_AND_G_PATTERNS, 0, 10);
        for (int i3 = 10; i3 < 20; ++i3) {
            nArray = L_PATTERNS[i3 - 10];
            int[] nArray2 = new int[nArray.length];
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                nArray2[i4] = nArray[nArray.length - i4 - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i3] = nArray2;
        }
    }

    protected UPCEANReader() {
        this.eanManSupport = new EANManufacturerOrgSupport();
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n2 = charSequence.length();
        boolean bl = false;
        if (n2 == 0) {
            return false;
        }
        int n3 = Character.digit(charSequence.charAt(--n2), 10);
        if (UPCEANReader.getStandardUPCEANChecksum(charSequence.subSequence(0, n2)) == n3) {
            bl = true;
        }
        return bl;
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n2, int[][] nArray2) throws NotFoundException {
        UPCEANReader.recordPattern(bitArray, n2, nArray);
        int n3 = nArray2.length;
        float f3 = 0.48f;
        int n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            float f4 = UPCEANReader.patternMatchVariance(nArray, nArray2[n2], 0.7f);
            float f5 = f3;
            if (f4 < f3) {
                n4 = n2;
                f5 = f4;
            }
            f3 = f5;
        }
        if (n4 >= 0) {
            return n4;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int[] findGuardPattern(BitArray bitArray, int n2, boolean bl, int[] nArray) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n2, bl, nArray, new int[nArray.length]);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, boolean bl, int[] nArray, int[] nArray2) throws NotFoundException {
        int n3 = bitArray.getSize();
        n2 = bl ? bitArray.getNextUnset(n2) : bitArray.getNextSet(n2);
        int n4 = nArray.length;
        int n5 = n2;
        int n6 = 0;
        int n7 = n2;
        n2 = n5;
        n5 = n6;
        while (n7 < n3) {
            if (bitArray.get(n7) != bl) {
                nArray2[n5] = nArray2[n5] + 1;
                n6 = n2;
            } else {
                if (n5 == n4 - 1) {
                    if (UPCEANReader.patternMatchVariance(nArray2, nArray, 0.7f) < 0.48f) {
                        return new int[]{n2, n7};
                    }
                    n6 = n2 + (nArray2[0] + nArray2[1]);
                    n2 = n5 - 1;
                    System.arraycopy(nArray2, 2, nArray2, 0, n2);
                    nArray2[n2] = 0;
                    nArray2[n5] = 0;
                    n2 = n5 - 1;
                    n5 = n6;
                } else {
                    n6 = n5 + 1;
                    n5 = n2;
                    n2 = n6;
                }
                nArray2[n2] = 1;
                bl ^= true;
                n6 = n5;
                n5 = n2;
            }
            ++n7;
            n2 = n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        int[] nArray = new int[START_END_PATTERN.length];
        int[] nArray2 = null;
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            Arrays.fill(nArray, 0, START_END_PATTERN.length, 0);
            nArray2 = UPCEANReader.findGuardPattern(bitArray, n2, false, START_END_PATTERN, nArray);
            int n3 = nArray2[0];
            int n4 = n3 - ((n2 = nArray2[1]) - n3);
            if (n4 < 0) continue;
            bl = bitArray.isRange(n4, n3, false);
        }
        return nArray2;
    }

    static int getStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n2;
        int n3 = charSequence.length();
        int n4 = 0;
        for (n2 = n3 - 1; n2 >= 0; n2 -= 2) {
            int n5 = charSequence.charAt(n2) - 48;
            if (n5 >= 0 && n5 <= 9) {
                n4 += n5;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        n4 *= 3;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            n3 = charSequence.charAt(n2) - 48;
            if (n3 >= 0 && n3 <= 9) {
                n4 += n3;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return (1000 - n4) % 10;
    }

    boolean checkChecksum(String string2) throws FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string2);
    }

    int[] decodeEnd(BitArray bitArray, int n2) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n2, false, START_END_PATTERN);
    }

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3) throws NotFoundException;

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n2, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n2, BitArray object, int[] object2, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n3;
        Object var5_6 = null;
        Object object3 = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        int n4 = 1;
        if (object3 != null) {
            object3.foundPossibleResultPoint(new ResultPoint((float)(object2[0] + object2[1]) / 2.0f, n2));
        }
        Object object4 = this.decodeRowStringBuffer;
        object4.setLength(0);
        int n5 = this.decodeMiddle((BitArray)object, (int[])object2, (StringBuilder)object4);
        if (object3 != null) {
            object3.foundPossibleResultPoint(new ResultPoint(n5, n2));
        }
        int[] nArray = this.decodeEnd((BitArray)object, n5);
        if (object3 != null) {
            object3.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n2));
        }
        if ((n5 = (n3 = nArray[1]) - nArray[0] + n3) < ((BitArray)object).getSize() && ((BitArray)object).isRange(n3, n5, false)) {
            object3 = object4.toString();
            if (((String)object3).length() >= 8) {
                if (this.checkChecksum((String)object3)) {
                    float f3 = (float)(object2[1] + object2[0]) / 2.0f;
                    float f4 = (float)(nArray[1] + nArray[0]) / 2.0f;
                    object4 = this.getBarcodeFormat();
                    float f5 = n2;
                    object2 = new Result((String)object3, null, new ResultPoint[]{new ResultPoint(f3, f5), new ResultPoint(f4, f5)}, (BarcodeFormat)((Object)object4));
                    try {
                        object = this.extensionReader.decodeRow(n2, (BitArray)object, nArray[1]);
                        ((Result)object2).putMetadata(ResultMetadataType.UPC_EAN_EXTENSION, ((Result)object).getText());
                        ((Result)object2).putAllMetadata(((Result)object).getResultMetadata());
                        ((Result)object2).addResultPoints(((Result)object).getResultPoints());
                        n2 = ((Result)object).getText().length();
                    }
                    catch (ReaderException readerException) {
                        n2 = 0;
                    }
                    object = map == null ? var5_6 : (Object)((int[])map.get((Object)DecodeHintType.ALLOWED_EAN_EXTENSIONS));
                    if (object != null) {
                        block12: {
                            n3 = ((Object)object).length;
                            for (n5 = 0; n5 < n3; ++n5) {
                                if (n2 != object[n5]) continue;
                                n2 = n4;
                                break block12;
                            }
                            n2 = 0;
                        }
                        if (n2 == 0) {
                            throw NotFoundException.getNotFoundInstance();
                        }
                    }
                    if ((object4 == BarcodeFormat.EAN_13 || object4 == BarcodeFormat.UPC_A) && (object = this.eanManSupport.lookupCountryIdentifier((String)object3)) != null) {
                        ((Result)object2).putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, object);
                    }
                    return object2;
                }
                throw ChecksumException.getChecksumInstance();
            }
            throw FormatException.getFormatInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();
}

