/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    private int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n2;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n3 = bitArray.getSize();
        int n4 = nArray[1];
        int n5 = 0;
        for (n2 = 0; n2 < 5 && n4 < n3; ++n2) {
            int n6;
            int n7 = UPCEANReader.decodeDigit(bitArray, nArray2, n4, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n7 % 10 + 48));
            int n8 = nArray2.length;
            for (n6 = 0; n6 < n8; ++n6) {
                n4 += nArray2[n6];
            }
            n6 = n5;
            if (n7 >= 10) {
                n6 = n5 | 1 << 4 - n2;
            }
            if (n2 != 4) {
                n4 = bitArray.getNextUnset(bitArray.getNextSet(n4));
            }
            n5 = n6;
        }
        if (stringBuilder.length() == 5) {
            n2 = UPCEANExtension5Support.determineCheckDigit(n5);
            if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) == n2) {
                return n4;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int determineCheckDigit(int n2) throws NotFoundException {
        for (int i3 = 0; i3 < 10; ++i3) {
            if (n2 != CHECK_DIGIT_ENCODINGS[i3]) continue;
            return i3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        int n4 = 0;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            n4 += charSequence.charAt(n2) - 48;
        }
        n2 = n4 * 3;
        for (n4 = n3 - 1; n4 >= 0; n4 -= 2) {
            n2 += charSequence.charAt(n4) - 48;
        }
        return n2 * 3 % 10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseExtension5String(String charSequence) {
        String string2;
        int n2;
        int n3;
        block9: {
            block7: {
                block8: {
                    block10: {
                        n3 = 0;
                        n2 = ((String)charSequence).charAt(0);
                        string2 = "";
                        if (n2 == 48) break block7;
                        if (n2 == 53) break block8;
                        if (n2 != 57) break block9;
                        switch (((String)charSequence).hashCode()) {
                            default: {
                                break;
                            }
                            case 54395377: {
                                if (!((String)charSequence).equals("99991")) break;
                                return "0.00";
                            }
                            case 54395376: {
                                if (!((String)charSequence).equals("99990")) break;
                                return "Used";
                            }
                            case 54118329: {
                                if (((String)charSequence).equals("90000")) break block10;
                            }
                        }
                        n3 = -1;
                    }
                    if (n3 == 0) return null;
                    if (n3 == 1) return "0.00";
                    if (n3 == 2) return "Used";
                    break block9;
                }
                string2 = "$";
                break block9;
            }
            string2 = "\u00a3";
        }
        n2 = Integer.parseInt(((String)charSequence).substring(1));
        n3 = n2 / 100;
        if ((n2 %= 100) < 10) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("0");
            ((StringBuilder)charSequence).append(n2);
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = String.valueOf(n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append('.');
        stringBuilder.append((String)charSequence);
        return stringBuilder.toString();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String object) {
        if (((String)object).length() != 5) {
            return null;
        }
        String string2 = UPCEANExtension5Support.parseExtension5String((String)object);
        if (string2 == null) {
            return null;
        }
        object = new EnumMap(ResultMetadataType.class);
        object.put(ResultMetadataType.SUGGESTED_PRICE, string2);
        return object;
    }

    Result decodeRow(int n2, BitArray object, int[] object2) throws NotFoundException {
        CharSequence charSequence = this.decodeRowStringBuffer;
        charSequence.setLength(0);
        int n3 = this.decodeMiddle((BitArray)object, (int[])object2, (StringBuilder)charSequence);
        charSequence = charSequence.toString();
        object = UPCEANExtension5Support.parseExtensionString((String)charSequence);
        float f3 = (float)(object2[0] + object2[1]) / 2.0f;
        float f4 = n2;
        ResultPoint resultPoint = new ResultPoint(f3, f4);
        object2 = new ResultPoint(n3, f4);
        BarcodeFormat barcodeFormat = BarcodeFormat.UPC_EAN_EXTENSION;
        object2 = new Result((String)charSequence, null, new ResultPoint[]{resultPoint, object2}, barcodeFormat);
        if (object != null) {
            ((Result)object2).putAllMetadata((Map<ResultMetadataType, Object>)object);
        }
        return object2;
    }
}

