/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.Writer;
import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class OneDimensionalCodeWriter
implements Writer {
    private static final Pattern NUMERIC = Pattern.compile("[0-9]+");

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl) {
        int n3 = nArray.length;
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5 = nArray[i3];
            int n6 = 0;
            while (n6 < n5) {
                blArray[n2] = bl;
                ++n6;
                ++n2;
            }
            n4 += n5;
            bl ^= true;
        }
        return n4;
    }

    protected static void checkNumeric(String string2) {
        if (NUMERIC.matcher(string2).matches()) {
            return;
        }
        throw new IllegalArgumentException("Input should only contain digits 0-9");
    }

    private static BitMatrix renderResult(boolean[] blArray, int n2, int n3, int n4) {
        int n5 = blArray.length;
        int n6 = n4 + n5;
        int n7 = Math.max(n2, n6);
        n4 = Math.max(1, n3);
        n6 = n7 / n6;
        n2 = (n7 - n5 * n6) / 2;
        BitMatrix bitMatrix = new BitMatrix(n7, n4);
        n3 = 0;
        while (n3 < n5) {
            if (blArray[n3]) {
                bitMatrix.setRegion(n2, 0, n6, n4);
            }
            ++n3;
            n2 += n6;
        }
        return bitMatrix;
    }

    @Override
    public final BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String charSequence, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (!((String)charSequence).isEmpty()) {
            if (n2 >= 0 && n3 >= 0) {
                int n4;
                Collection<BarcodeFormat> collection = this.getSupportedWriteFormats();
                if (collection != null && !collection.contains((Object)barcodeFormat)) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Can only encode ");
                    ((StringBuilder)charSequence).append(collection);
                    ((StringBuilder)charSequence).append(", but got ");
                    ((StringBuilder)charSequence).append((Object)barcodeFormat);
                    throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
                }
                int n5 = n4 = this.getDefaultMargin();
                if (map != null) {
                    n5 = n4;
                    if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                        n5 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
                    }
                }
                return OneDimensionalCodeWriter.renderResult(this.encode((String)charSequence), n2, n3, n5);
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Negative size is not allowed. Input: ");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append('x');
            ((StringBuilder)charSequence).append(n3);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        throw new IllegalArgumentException("Found empty contents");
    }

    public abstract boolean[] encode(String var1);

    public int getDefaultMargin() {
        return 10;
    }

    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return null;
    }
}

