/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.EAN13Reader;
import com.ailiwean.core.zxing.core.oned.EAN8Reader;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import com.ailiwean.core.zxing.core.oned.UPCAReader;
import com.ailiwean.core.zxing.core.oned.UPCEANReader;
import com.ailiwean.core.zxing.core.oned.UPCEReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private static final UPCEANReader[] EMPTY_READER_ARRAY = new UPCEANReader[0];
    private final UPCEANReader[] readers;

    public MultiFormatUPCEANReader(Map<DecodeHintType, ?> object) {
        object = object == null ? null : (Collection)object.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> arrayList = new ArrayList<UPCEANReader>();
        if (object != null) {
            if (object.contains((Object)BarcodeFormat.EAN_13)) {
                arrayList.add(new EAN13Reader());
            } else if (object.contains((Object)BarcodeFormat.UPC_A)) {
                arrayList.add(new UPCAReader());
            }
            if (object.contains((Object)BarcodeFormat.EAN_8)) {
                arrayList.add(new EAN8Reader());
            }
            if (object.contains((Object)BarcodeFormat.UPC_E)) {
                arrayList.add(new UPCEReader());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new EAN13Reader());
            arrayList.add(new EAN8Reader());
            arrayList.add(new UPCEReader());
        }
        this.readers = arrayList.toArray(EMPTY_READER_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        int[] nArray = UPCEANReader.findStartGuardPattern(bitArray);
        for (UPCEANReader object : this.readers) {
            boolean bl;
            boolean bl2;
            Result result;
            block11: {
                block10: {
                    void var8_12;
                    block9: {
                        block8: {
                            try {
                                result = object.decodeRow(n2, bitArray, nArray, map);
                                bl2 = result.getBarcodeFormat() == BarcodeFormat.EAN_13 && result.getText().charAt(0) == '0';
                                if (map != null) break block8;
                                Object var8_10 = null;
                                break block9;
                            }
                            catch (ReaderException readerException) {
                                continue;
                            }
                        }
                        Collection collection = (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
                    }
                    if (var8_12 != null) {
                        if (var8_12.contains((Object)BarcodeFormat.UPC_A)) break block10;
                        bl = false;
                        break block11;
                    }
                }
                bl = true;
            }
            if (bl2 && bl) {
                Result result2 = new Result(result.getText().substring(1), result.getRawBytes(), result.getResultPoints(), BarcodeFormat.UPC_A);
                result2.putAllMetadata(result.getResultMetadata());
                return result2;
            }
            return result;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n2 = uPCEANReaderArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            uPCEANReaderArray[i3].reset();
        }
    }
}

