/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.CodaBarReader;
import com.ailiwean.core.zxing.core.oned.Code128Reader;
import com.ailiwean.core.zxing.core.oned.Code39Reader;
import com.ailiwean.core.zxing.core.oned.Code93Reader;
import com.ailiwean.core.zxing.core.oned.ITFReader;
import com.ailiwean.core.zxing.core.oned.MultiFormatUPCEANReader;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import com.ailiwean.core.zxing.core.oned.rss.expanded.RSSExpandedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatOneDReader
extends OneDReader {
    private static final OneDReader[] EMPTY_ONED_ARRAY = new OneDReader[0];
    private final OneDReader[] readers;

    public MultiFormatOneDReader(Map<DecodeHintType, ?> map) {
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        boolean bl = map != null && map.get((Object)DecodeHintType.ASSUME_CODE_39_CHECK_DIGIT) != null;
        ArrayList<OneDReader> arrayList = new ArrayList<OneDReader>();
        if (collection != null) {
            if (collection.contains((Object)BarcodeFormat.EAN_13) || collection.contains((Object)BarcodeFormat.UPC_A) || collection.contains((Object)BarcodeFormat.EAN_8) || collection.contains((Object)BarcodeFormat.UPC_E)) {
                arrayList.add(new MultiFormatUPCEANReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.CODE_39)) {
                arrayList.add(new Code39Reader(bl));
            }
            if (collection.contains((Object)BarcodeFormat.CODE_93)) {
                arrayList.add(new Code93Reader());
            }
            if (collection.contains((Object)BarcodeFormat.CODE_128)) {
                arrayList.add(new Code128Reader());
            }
            if (collection.contains((Object)BarcodeFormat.ITF)) {
                arrayList.add(new ITFReader());
            }
            if (collection.contains((Object)BarcodeFormat.CODABAR)) {
                arrayList.add(new CodaBarReader());
            }
            collection.contains((Object)BarcodeFormat.RSS_14);
            if (collection.contains((Object)BarcodeFormat.RSS_EXPANDED)) {
                arrayList.add(new RSSExpandedReader());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new MultiFormatUPCEANReader(map));
            arrayList.add(new Code39Reader());
            arrayList.add(new CodaBarReader());
            arrayList.add(new Code93Reader());
            arrayList.add(new Code128Reader());
            arrayList.add(new ITFReader());
            arrayList.add(new RSSExpandedReader());
        }
        this.readers = arrayList.toArray(EMPTY_ONED_ARRAY);
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        for (OneDReader object : this.readers) {
            try {
                Result result = object.decodeRow(n2, bitArray, map);
                return result;
            }
            catch (ReaderException readerException) {
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        OneDReader[] oneDReaderArray = this.readers;
        int n2 = oneDReaderArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            oneDReaderArray[i3].reset();
        }
    }
}

