/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] END_PATTERN;
    private static final int N = 1;
    private static final int[][] PATTERNS;
    private static final int[] START_PATTERN;
    private static final int W = 3;

    static {
        START_PATTERN = new int[]{1, 1, 1, 1};
        END_PATTERN = new int[]{3, 1, 1};
        int[] nArray = new int[]{1, 1, 3, 3, 1};
        int[] nArray2 = new int[]{3, 1, 1, 1, 3};
        int[] nArray3 = new int[]{1, 3, 1, 1, 3};
        int[] nArray4 = new int[]{3, 1, 3, 1, 1};
        int[] nArray5 = new int[]{1, 3, 3, 1, 1};
        int[] nArray6 = new int[]{3, 1, 1, 3, 1};
        PATTERNS = new int[][]{nArray, nArray2, nArray3, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, nArray4, nArray5, {1, 1, 1, 3, 3}, nArray6, {1, 3, 1, 3, 1}};
    }

    @Override
    public boolean[] encode(String charSequence) {
        int n2 = ((String)charSequence).length();
        if (n2 % 2 == 0) {
            if (n2 <= 80) {
                ITFWriter.checkNumeric((String)charSequence);
                boolean[] blArray = new boolean[n2 * 9 + 9];
                int n3 = ITFWriter.appendPattern(blArray, 0, START_PATTERN, true);
                for (int i3 = 0; i3 < n2; i3 += 2) {
                    int n4 = Character.digit(((String)charSequence).charAt(i3), 10);
                    int n5 = Character.digit(((String)charSequence).charAt(i3 + 1), 10);
                    int[] nArray = new int[10];
                    for (int i4 = 0; i4 < 5; ++i4) {
                        int n6 = i4 * 2;
                        int[][] nArray2 = PATTERNS;
                        nArray[n6] = nArray2[n4][i4];
                        nArray[n6 + 1] = nArray2[n5][i4];
                    }
                    n3 += ITFWriter.appendPattern(blArray, n3, nArray, true);
                }
                ITFWriter.appendPattern(blArray, n3, END_PATTERN, true);
                return blArray;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Requested contents should be less than 80 digits long, but got ");
            ((StringBuilder)charSequence).append(n2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        throw new IllegalArgumentException("The length of the input should be even");
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.ITF);
    }
}

