/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{6, 8, 10, 12, 14};
    private static final int[][] END_PATTERN_REVERSED;
    private static final float MAX_AVG_VARIANCE = 0.38f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.5f;
    private static final int N = 1;
    private static final int[][] PATTERNS;
    private static final int[] START_PATTERN;
    private static final int W = 3;
    private static final int w = 2;
    private int narrowLineWidth = -1;

    static {
        START_PATTERN = new int[]{1, 1, 1, 1};
        END_PATTERN_REVERSED = new int[][]{{1, 1, 2}, {1, 1, 3}};
        int[] nArray = new int[]{1, 1, 2, 2, 1};
        int[] nArray2 = new int[]{2, 1, 1, 1, 2};
        int[] nArray3 = new int[]{1, 2, 1, 1, 2};
        int[] nArray4 = new int[]{1, 1, 2, 1, 2};
        int[] nArray5 = new int[]{2, 1, 2, 1, 1};
        int[] nArray6 = new int[]{1, 2, 2, 1, 1};
        int[] nArray7 = new int[]{1, 1, 1, 2, 2};
        int[] nArray8 = new int[]{2, 1, 1, 2, 1};
        int[] nArray9 = new int[]{1, 2, 1, 2, 1};
        int[] nArray10 = new int[]{1, 1, 3, 3, 1};
        int[] nArray11 = new int[]{3, 1, 1, 1, 3};
        int[] nArray12 = new int[]{1, 3, 1, 1, 3};
        int[] nArray13 = new int[]{3, 3, 1, 1, 1};
        int[] nArray14 = new int[]{1, 1, 3, 1, 3};
        int[] nArray15 = new int[]{1, 3, 3, 1, 1};
        int[] nArray16 = new int[]{1, 1, 1, 3, 3};
        int[] nArray17 = new int[]{3, 1, 1, 3, 1};
        int[] nArray18 = new int[]{1, 3, 1, 3, 1};
        PATTERNS = new int[][]{nArray, nArray2, nArray3, {2, 2, 1, 1, 1}, nArray4, nArray5, nArray6, nArray7, nArray8, nArray9, nArray10, nArray11, nArray12, nArray13, nArray14, {3, 1, 3, 1, 1}, nArray15, nArray16, nArray17, nArray18};
    }

    private static int decodeDigit(int[] nArray) throws NotFoundException {
        int n2 = PATTERNS.length;
        int n3 = -1;
        float f3 = 0.38f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f4;
            float f5 = ITFReader.patternMatchVariance(nArray, PATTERNS[i3], 0.5f);
            if (f5 < f3) {
                n3 = i3;
                f4 = f5;
            } else {
                f4 = f3;
                if (f5 == f3) {
                    n3 = -1;
                    f4 = f3;
                }
            }
            f3 = f4;
        }
        if (n3 >= 0) {
            return n3 % 10;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] decodeEnd(BitArray bitArray) throws NotFoundException {
        int[] nArray;
        bitArray.reverse();
        int n2 = ITFReader.skipWhiteSpace(bitArray);
        try {
            nArray = ITFReader.findGuardPattern(bitArray, n2, END_PATTERN_REVERSED[0]);
        }
        catch (NotFoundException notFoundException) {
            nArray = ITFReader.findGuardPattern(bitArray, n2, END_PATTERN_REVERSED[1]);
        }
        this.validateQuietZone(bitArray, nArray[0]);
        n2 = nArray[0];
        try {
            nArray[0] = bitArray.getSize() - nArray[1];
            nArray[1] = bitArray.getSize() - n2;
            return nArray;
        }
        finally {
            bitArray.reverse();
        }
    }

    private static void decodeMiddle(BitArray bitArray, int n2, int n3, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        block0: while (n2 < n3) {
            int n4;
            int n5;
            ITFReader.recordPattern(bitArray, n2, nArray);
            int n6 = 0;
            for (n5 = 0; n5 < 5; ++n5) {
                n4 = n5 * 2;
                nArray2[n5] = nArray[n4];
                nArray3[n5] = nArray[n4 + 1];
            }
            stringBuilder.append((char)(ITFReader.decodeDigit(nArray2) + 48));
            stringBuilder.append((char)(ITFReader.decodeDigit(nArray3) + 48));
            int n7 = nArray.length;
            n4 = n2;
            n5 = n6;
            while (true) {
                n2 = n4;
                if (n5 >= n7) continue block0;
                n4 += nArray[n5];
                ++n5;
            }
        }
    }

    private int[] decodeStart(BitArray bitArray) throws NotFoundException {
        int[] nArray = ITFReader.findGuardPattern(bitArray, ITFReader.skipWhiteSpace(bitArray), START_PATTERN);
        this.narrowLineWidth = (nArray[1] - nArray[0]) / 4;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, int[] nArray) throws NotFoundException {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int n4 = bitArray.getSize();
        int n5 = n2;
        boolean bl = false;
        int n6 = 0;
        int n7 = n2;
        n2 = n5;
        n5 = n6;
        while (n7 < n4) {
            if (bitArray.get(n7) != bl) {
                nArray2[n5] = nArray2[n5] + 1;
                n6 = n2;
            } else {
                if (n5 == n3 - 1) {
                    if (ITFReader.patternMatchVariance(nArray2, nArray, 0.5f) < 0.38f) {
                        return new int[]{n2, n7};
                    }
                    n6 = n2 + (nArray2[0] + nArray2[1]);
                    n2 = n5 - 1;
                    System.arraycopy(nArray2, 2, nArray2, 0, n2);
                    nArray2[n2] = 0;
                    nArray2[n5] = 0;
                    n2 = n5 - 1;
                    n5 = n6;
                } else {
                    n6 = n5 + 1;
                    n5 = n2;
                    n2 = n6;
                }
                nArray2[n2] = 1;
                bl ^= true;
                n6 = n5;
                n5 = n2;
            }
            ++n7;
            n2 = n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int skipWhiteSpace(BitArray bitArray) throws NotFoundException {
        int n2 = bitArray.getSize();
        int n3 = bitArray.getNextSet(0);
        if (n3 != n2) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void validateQuietZone(BitArray bitArray, int n2) throws NotFoundException {
        int n3 = Math.min(this.narrowLineWidth * 10, n2);
        --n2;
        while (n3 > 0 && n2 >= 0 && !bitArray.get(n2)) {
            --n3;
            --n2;
        }
        if (n3 == 0) {
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decodeRow(int n2, BitArray object, Map<DecodeHintType, ?> object2) throws FormatException, NotFoundException {
        Object object3;
        int n3;
        int n4;
        int n5;
        CharSequence charSequence;
        Object object4;
        int[] nArray;
        block7: {
            nArray = this.decodeStart((BitArray)object);
            object4 = this.decodeEnd((BitArray)object);
            charSequence = new StringBuilder(20);
            ITFReader.decodeMiddle((BitArray)object, nArray[1], object4[0], (StringBuilder)charSequence);
            charSequence = ((StringBuilder)charSequence).toString();
            object = object2 != null ? (Object)((int[])object2.get((Object)DecodeHintType.ALLOWED_LENGTHS)) : null;
            object2 = object;
            if (object == null) {
                object2 = DEFAULT_ALLOWED_LENGTHS;
            }
            n5 = ((String)charSequence).length();
            int n6 = ((Object)object2).length;
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                Object object5 = object2[n3];
                if (n5 == object5) {
                    object3 = 1;
                    break block7;
                }
                object3 = n4;
                if (object5 > n4) {
                    object3 = object5;
                }
                n4 = object3;
            }
            object3 = 0;
        }
        n3 = object3;
        if (object3 == 0) {
            n3 = object3;
            if (n5 > n4) {
                n3 = 1;
            }
        }
        if (n3 != 0) {
            float f3 = nArray[1];
            float f4 = n2;
            object = new ResultPoint(f3, f4);
            object2 = new ResultPoint(object4[0], f4);
            object4 = (Object)BarcodeFormat.ITF;
            return new Result((String)charSequence, null, new ResultPoint[]{object, object2}, (BarcodeFormat)((Object)object4));
        }
        throw FormatException.getFormatInstance();
    }
}

