/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.oned.EAN13Reader;
import com.ailiwean.core.zxing.core.oned.UPCEANReader;
import com.ailiwean.core.zxing.core.oned.UPCEANWriter;
import java.util.Collection;
import java.util.Collections;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public boolean[] encode(String object) {
        int n2;
        Object object2;
        int n3;
        block10: {
            n3 = ((String)object).length();
            if (n3 != 12) {
                if (n3 == 13) {
                    try {
                        if (!UPCEANReader.checkStandardUPCEANChecksum((CharSequence)object)) {
                            object = new IllegalArgumentException("Contents do not pass checksum");
                            throw object;
                        }
                        break block10;
                    }
                    catch (FormatException formatException) {
                        throw new IllegalArgumentException("Illegal contents");
                    }
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Requested contents should be 12 or 13 digits long, but got ");
                ((StringBuilder)object).append(n3);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            try {
                n3 = UPCEANReader.getStandardUPCEANChecksum((CharSequence)object);
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
            }
            catch (FormatException formatException) {
                throw new IllegalArgumentException(formatException);
            }
            ((StringBuilder)object2).append(n3);
            object = ((StringBuilder)object2).toString();
        }
        EAN13Writer.checkNumeric((String)object);
        n3 = Character.digit(((String)object).charAt(0), 10);
        int n4 = EAN13Reader.FIRST_DIGIT_ENCODINGS[n3];
        object2 = new boolean[95];
        int n5 = EAN13Writer.appendPattern((boolean[])object2, 0, UPCEANReader.START_END_PATTERN, true) + 0;
        for (n3 = 1; n3 <= 6; ++n3) {
            int n6;
            n2 = n6 = Character.digit(((String)object).charAt(n3), 10);
            if ((n4 >> 6 - n3 & 1) == 1) {
                n2 = n6 + 10;
            }
            n5 += EAN13Writer.appendPattern((boolean[])object2, n5, UPCEANReader.L_AND_G_PATTERNS[n2], false);
        }
        n3 = n5 + EAN13Writer.appendPattern((boolean[])object2, n5, UPCEANReader.MIDDLE_PATTERN, false);
        for (n5 = 7; n5 <= 12; ++n5) {
            n2 = Character.digit(((String)object).charAt(n5), 10);
            n3 += EAN13Writer.appendPattern((boolean[])object2, n3, UPCEANReader.L_PATTERNS[n2], true);
        }
        EAN13Writer.appendPattern((boolean[])object2, n3, UPCEANReader.START_END_PATTERN, true);
        return object2;
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.EAN_13);
    }
}

