/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.oned.Code93Reader;
import com.ailiwean.core.zxing.core.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public class Code93Writer
extends OneDimensionalCodeWriter {
    private static int appendPattern(boolean[] blArray, int n2, int n3) {
        for (int i3 = 0; i3 < 9; ++i3) {
            boolean bl = true;
            if ((1 << 8 - i3 & n3) == 0) {
                bl = false;
            }
            blArray[n2 + i3] = bl;
        }
        return 9;
    }

    @Deprecated
    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl) {
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            bl = nArray[n4] != 0;
            blArray[n2] = bl;
            ++n4;
            ++n2;
        }
        return 9;
    }

    private static int computeChecksumIndex(String string2, int n2) {
        int n3 = 0;
        int n4 = 1;
        for (int i3 = string2.length() - 1; i3 >= 0; --i3) {
            int n5;
            n3 += "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string2.charAt(i3)) * n4;
            n4 = n5 = n4 + 1;
            if (n5 <= n2) continue;
            n4 = 1;
        }
        return n3 % 47;
    }

    static String convertToExtended(String charSequence) {
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (int i3 = 0; i3 < n2; ++i3) {
            char c3 = ((String)charSequence).charAt(i3);
            if (c3 == '\u0000') {
                stringBuilder.append("bU");
                continue;
            }
            if (c3 <= '\u001a') {
                stringBuilder.append('a');
                stringBuilder.append((char)(c3 + 65 - 1));
                continue;
            }
            if (c3 <= '\u001f') {
                stringBuilder.append('b');
                stringBuilder.append((char)(c3 + 65 - 27));
                continue;
            }
            if (c3 != ' ' && c3 != '$' && c3 != '%' && c3 != '+') {
                if (c3 <= ',') {
                    stringBuilder.append('c');
                    stringBuilder.append((char)(c3 + 65 - 33));
                    continue;
                }
                if (c3 <= '9') {
                    stringBuilder.append(c3);
                    continue;
                }
                if (c3 == ':') {
                    stringBuilder.append("cZ");
                    continue;
                }
                if (c3 <= '?') {
                    stringBuilder.append('b');
                    stringBuilder.append((char)(c3 + 70 - 59));
                    continue;
                }
                if (c3 == '@') {
                    stringBuilder.append("bV");
                    continue;
                }
                if (c3 <= 'Z') {
                    stringBuilder.append(c3);
                    continue;
                }
                if (c3 <= '_') {
                    stringBuilder.append('b');
                    stringBuilder.append((char)(c3 + 75 - 91));
                    continue;
                }
                if (c3 == '`') {
                    stringBuilder.append("bW");
                    continue;
                }
                if (c3 <= 'z') {
                    stringBuilder.append('d');
                    stringBuilder.append((char)(c3 + 65 - 97));
                    continue;
                }
                if (c3 <= '\u007f') {
                    stringBuilder.append('b');
                    stringBuilder.append((char)(c3 + 80 - 123));
                    continue;
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Requested content contains a non-encodable character: '");
                ((StringBuilder)charSequence).append(c3);
                ((StringBuilder)charSequence).append("'");
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean[] encode(String charSequence) {
        int n2 = ((String)(charSequence = Code93Writer.convertToExtended((String)charSequence))).length();
        if (n2 <= 80) {
            int n3;
            boolean[] blArray = new boolean[(((String)charSequence).length() + 2 + 2) * 9 + 1];
            int n4 = Code93Reader.ASTERISK_ENCODING;
            n4 = Code93Writer.appendPattern(blArray, 0, n4);
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(((String)charSequence).charAt(n3));
                n4 += Code93Writer.appendPattern(blArray, n4, Code93Reader.CHARACTER_ENCODINGS[n5]);
            }
            n2 = Code93Writer.computeChecksumIndex((String)charSequence, 20);
            n3 = n4 + Code93Writer.appendPattern(blArray, n4, Code93Reader.CHARACTER_ENCODINGS[n2]);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(n2));
            n4 = Code93Writer.computeChecksumIndex(stringBuilder.toString(), 15);
            n3 += Code93Writer.appendPattern(blArray, n3, Code93Reader.CHARACTER_ENCODINGS[n4]);
            blArray[n3 + Code93Writer.appendPattern((boolean[])blArray, (int)n3, (int)Code93Reader.ASTERISK_ENCODING)] = true;
            return blArray;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Requested contents should be less than 80 digits long after converting to extended encoding, but got ");
        ((StringBuilder)charSequence).append(n2);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_93);
    }
}

