/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code93Reader
extends OneDReader {
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    static final int ASTERISK_ENCODING;
    static final int[] CHARACTER_ENCODINGS;
    private final int[] counters;
    private final StringBuilder decodeRowResult = new StringBuilder(20);

    static {
        CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
        ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];
    }

    public Code93Reader() {
        this.counters = new int[6];
    }

    private static void checkChecksums(CharSequence charSequence) throws ChecksumException {
        int n2 = charSequence.length();
        Code93Reader.checkOneChecksum(charSequence, n2 - 2, 20);
        Code93Reader.checkOneChecksum(charSequence, n2 - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n2, int n3) throws ChecksumException {
        int n4 = 0;
        int n5 = 1;
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            int n6;
            n4 += ALPHABET_STRING.indexOf(charSequence.charAt(i3)) * n5;
            n5 = n6 = n5 + 1;
            if (n6 <= n3) continue;
            n5 = 1;
        }
        if (charSequence.charAt(n2) == ALPHABET[n4 % 47]) {
            return;
        }
        throw ChecksumException.getChecksumInstance();
    }

    /*
     * Unable to fully structure code
     */
    private static String decodeExtended(CharSequence var0) throws FormatException {
        var1_1 = var0.length();
        var2_2 = new StringBuilder(var1_1);
        for (var3_3 = 0; var3_3 < var1_1; ++var3_3) {
            block14: {
                block15: {
                    block16: {
                        block17: {
                            var4_4 = var0.charAt(var3_3);
                            if (var4_4 < 97 || var4_4 > 100) break block14;
                            if (var3_3 >= var1_1 - 1) break block15;
                            var5_5 = var3_3 + 1;
                            var3_3 = var0.charAt(var5_5);
                            switch (var4_4) lbl-1000:
                            // 2 sources

                            {
                                default: {
                                    var4_4 = var3_3 = 0;
                                    break block16;
                                }
                                case 100: {
                                    if (var3_3 >= 65 && var3_3 <= 90) {
                                        var3_3 += 32;
                                        break;
                                    }
                                    throw FormatException.getFormatInstance();
                                }
                                case 99: {
                                    if (var3_3 >= 65 && var3_3 <= 79) {
                                        var3_3 -= 32;
                                        break;
                                    }
                                    if (var3_3 != 90) ** GOTO lbl25
                                    var4_4 = var3_3 = 58;
                                    break block16;
lbl25:
                                    // 1 sources

                                    throw FormatException.getFormatInstance();
                                }
                                case 98: {
                                    if (var3_3 >= 65 && var3_3 <= 69) {
                                        var3_3 -= 38;
                                        break;
                                    }
                                    if (var3_3 >= 70 && var3_3 <= 74) {
                                        var3_3 -= 11;
                                        break;
                                    }
                                    if (var3_3 >= 75 && var3_3 <= 79) {
                                        var3_3 += 16;
                                        break;
                                    }
                                    if (var3_3 >= 80 && var3_3 <= 84) {
                                        var3_3 += 43;
                                        break;
                                    }
                                    if (var3_3 == 85) ** GOTO lbl-1000
                                    if (var3_3 != 86) ** GOTO lbl43
                                    var4_4 = var3_3 = 64;
                                    break block16;
lbl43:
                                    // 1 sources

                                    if (var3_3 != 87) ** GOTO lbl46
                                    var4_4 = var3_3 = 96;
                                    break block16;
lbl46:
                                    // 1 sources

                                    if (var3_3 < 88 || var3_3 > 90) ** GOTO lbl49
                                    var4_4 = var3_3 = 127;
                                    break block16;
lbl49:
                                    // 1 sources

                                    throw FormatException.getFormatInstance();
                                }
                                case 97: {
                                    if (var3_3 < 65 || var3_3 > 90) break block17;
                                    var3_3 -= 64;
                                }
                            }
                            var4_4 = var3_3 = (int)((char)var3_3);
                            break block16;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    var2_2.append((char)var4_4);
                    var3_3 = var5_5;
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            var2_2.append((char)var4_4);
        }
        return var2_2.toString();
    }

    private int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n2;
        int n3 = bitArray.getSize();
        Arrays.fill(this.counters, 0);
        int[] nArray = this.counters;
        int n4 = nArray.length;
        int n5 = n2;
        boolean bl = false;
        int n6 = 0;
        for (n2 = bitArray.getNextSet(0); n2 < n3; ++n2) {
            int n7;
            if (bitArray.get(n2) != bl) {
                nArray[n6] = nArray[n6] + 1;
                n7 = n5;
            } else {
                if (n6 == n4 - 1) {
                    if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                        return new int[]{n5, n2};
                    }
                    n7 = n5 + (nArray[0] + nArray[1]);
                    n5 = n6 - 1;
                    System.arraycopy(nArray, 2, nArray, 0, n5);
                    nArray[n5] = 0;
                    nArray[n6] = 0;
                    n5 = n6 - 1;
                    n6 = n7;
                } else {
                    n7 = n6 + 1;
                    n6 = n5;
                    n5 = n7;
                }
                nArray[n5] = 1;
                bl ^= true;
                n7 = n6;
                n6 = n5;
            }
            n5 = n7;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static char patternToChar(int n2) throws NotFoundException {
        int[] nArray;
        for (int i3 = 0; i3 < (nArray = CHARACTER_ENCODINGS).length; ++i3) {
            if (nArray[i3] != n2) continue;
            return ALPHABET[i3];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
        }
        int n5 = nArray.length;
        n2 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = Math.round((float)nArray[n3] * 9.0f / (float)n4);
            if (n6 >= 1 && n6 <= 4) {
                if ((n3 & 1) == 0) {
                    for (int i3 = 0; i3 < n6; ++i3) {
                        n2 = n2 << 1 | 1;
                    }
                    continue;
                }
                n2 <<= n6;
                continue;
            }
            return -1;
        }
        return n2;
    }

    @Override
    public Result decodeRow(int n2, BitArray object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        object2 = this.findAsteriskPattern((BitArray)object);
        int n3 = ((BitArray)object).getNextSet((int)object2[1]);
        int n4 = ((BitArray)object).getSize();
        Object object3 = this.counters;
        Arrays.fill(object3, 0);
        Object object4 = this.decodeRowResult;
        ((StringBuilder)object4).setLength(0);
        while (true) {
            Code93Reader.recordPattern((BitArray)object, n3, object3);
            int n5 = Code93Reader.toPattern(object3);
            if (n5 < 0) break;
            char c3 = Code93Reader.patternToChar(n5);
            ((StringBuilder)object4).append(c3);
            int n6 = ((int[])object3).length;
            int n7 = n3;
            for (n5 = 0; n5 < n6; ++n5) {
                n7 += object3[n5];
            }
            n6 = ((BitArray)object).getNextSet(n7);
            if (c3 == '*') {
                ((StringBuilder)object4).deleteCharAt(((StringBuilder)object4).length() - 1);
                int n8 = ((int[])object3).length;
                n7 = 0;
                for (n5 = 0; n5 < n8; ++n5) {
                    n7 += object3[n5];
                }
                if (n6 != n4 && ((BitArray)object).get(n6)) {
                    if (((StringBuilder)object4).length() >= 2) {
                        Code93Reader.checkChecksums((CharSequence)object4);
                        ((StringBuilder)object4).setLength(((StringBuilder)object4).length() - 2);
                        object = Code93Reader.decodeExtended((CharSequence)object4);
                        float f3 = (float)(object2[1] + object2[0]) / 2.0f;
                        float f4 = n3;
                        float f5 = (float)n7 / 2.0f;
                        float f6 = n2;
                        object4 = new ResultPoint(f3, f6);
                        object2 = new ResultPoint(f4 + f5, f6);
                        object3 = (Object)BarcodeFormat.CODE_93;
                        return new Result((String)object, null, new ResultPoint[]{object4, object2}, (BarcodeFormat)((Object)object3));
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n3 = n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

