/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.oned.Code39Reader;
import com.ailiwean.core.zxing.core.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    private static void toIntArray(int n2, int[] nArray) {
        for (int i3 = 0; i3 < 9; ++i3) {
            int n3 = 1;
            if ((1 << 8 - i3 & n2) != 0) {
                n3 = 2;
            }
            nArray[i3] = n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String tryToConvertToExtendedMode(String string2) {
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            block7: {
                block8: {
                    char c3;
                    block9: {
                        block10: {
                            block11: {
                                block14: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block13: {
                                                    block12: {
                                                        if (n3 >= n2) {
                                                            return stringBuilder.toString();
                                                        }
                                                        c3 = string2.charAt(n3);
                                                        if (c3 == '\u0000') break block8;
                                                        if (c3 == ' ') break block9;
                                                        if (c3 == '@') break block10;
                                                        if (c3 == '`') break block11;
                                                        if (c3 == '-' || c3 == '.') break block9;
                                                        if (c3 > '\u001a') break block12;
                                                        stringBuilder.append('$');
                                                        stringBuilder.append((char)(c3 - '\u0001' + 65));
                                                        break block7;
                                                    }
                                                    if (c3 >= ' ') break block13;
                                                    stringBuilder.append('%');
                                                    stringBuilder.append((char)(c3 - 27 + 65));
                                                    break block7;
                                                }
                                                if (c3 <= ',' || c3 == '/' || c3 == ':') break block14;
                                                if (c3 > '9') break block15;
                                                stringBuilder.append((char)(c3 - 48 + 48));
                                                break block7;
                                            }
                                            if (c3 > '?') break block16;
                                            stringBuilder.append('%');
                                            stringBuilder.append((char)(c3 - 59 + 70));
                                            break block7;
                                        }
                                        if (c3 > 'Z') break block17;
                                        stringBuilder.append((char)(c3 - 65 + 65));
                                        break block7;
                                    }
                                    if (c3 <= '_') {
                                        stringBuilder.append('%');
                                        stringBuilder.append((char)(c3 - 91 + 75));
                                        break block7;
                                    } else if (c3 <= 'z') {
                                        stringBuilder.append('+');
                                        stringBuilder.append((char)(c3 - 97 + 65));
                                        break block7;
                                    } else {
                                        if (c3 > '\u007f') {
                                            stringBuilder = new StringBuilder();
                                            stringBuilder.append("Requested content contains a non-encodable character: '");
                                            stringBuilder.append(string2.charAt(n3));
                                            stringBuilder.append("'");
                                            throw new IllegalArgumentException(stringBuilder.toString());
                                        }
                                        stringBuilder.append('%');
                                        stringBuilder.append((char)(c3 - 123 + 80));
                                    }
                                    break block7;
                                }
                                stringBuilder.append('/');
                                stringBuilder.append((char)(c3 - 33 + 65));
                                break block7;
                            }
                            stringBuilder.append("%W");
                            break block7;
                        }
                        stringBuilder.append("%V");
                        break block7;
                    }
                    stringBuilder.append(c3);
                    break block7;
                }
                stringBuilder.append("%U");
            }
            ++n3;
        }
    }

    @Override
    public boolean[] encode(String object) {
        int n2 = ((String)object).length();
        if (n2 <= 80) {
            CharSequence charSequence;
            int n3;
            int n4 = 0;
            while (true) {
                n3 = n2;
                charSequence = object;
                if (n4 >= n2) break;
                if ("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(((String)object).charAt(n4)) < 0) {
                    charSequence = Code39Writer.tryToConvertToExtendedMode((String)object);
                    n3 = ((String)charSequence).length();
                    if (n3 <= 80) break;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Requested contents should be less than 80 digits long, but got ");
                    ((StringBuilder)object).append(n3);
                    ((StringBuilder)object).append(" (extended full ASCII mode)");
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                ++n4;
            }
            int[] nArray = new int[9];
            boolean[] blArray = new boolean[n3 * 13 + 25];
            Code39Writer.toIntArray(148, nArray);
            n4 = Code39Writer.appendPattern(blArray, 0, nArray, true);
            object = new int[1];
            object[0] = true;
            n2 = n4 + Code39Writer.appendPattern(blArray, n4, (int[])object, false);
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(((String)charSequence).charAt(n4));
                Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n5], nArray);
                n2 += Code39Writer.appendPattern(blArray, n2, nArray, true);
                n2 += Code39Writer.appendPattern(blArray, n2, (int[])object, false);
            }
            Code39Writer.toIntArray(148, nArray);
            Code39Writer.appendPattern(blArray, n2, nArray, true);
            return blArray;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Requested contents should be less than 80 digits long, but got ");
        ((StringBuilder)object).append(n2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_39);
    }
}

