/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    static final int ASTERISK_ENCODING = 148;
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 168, 162, 138, 42};
    private final int[] counters;
    private final StringBuilder decodeRowResult;
    private final boolean extendedMode;
    private final boolean usingCheckDigit;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl) {
        this(bl, false);
    }

    public Code39Reader(boolean bl, boolean bl2) {
        this.usingCheckDigit = bl;
        this.extendedMode = bl2;
        this.decodeRowResult = new StringBuilder(20);
        this.counters = new int[9];
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (true) {
            block13: {
                int n4;
                int n5;
                block11: {
                    block10: {
                        block14: {
                            block23: {
                                block17: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block15: {
                                                        block16: {
                                                            block18: {
                                                                block12: {
                                                                    if (n3 >= n2) {
                                                                        return stringBuilder.toString();
                                                                    }
                                                                    n5 = charSequence.charAt(n3);
                                                                    if (n5 == 43 || n5 == 36 || n5 == 37 || n5 == 47) break block12;
                                                                    stringBuilder.append((char)n5);
                                                                    break block13;
                                                                }
                                                                n4 = n3 + 1;
                                                                n3 = charSequence.charAt(n4);
                                                                if (n5 == 36) break block14;
                                                                if (n5 == 37) break block15;
                                                                if (n5 == 43) break block16;
                                                                if (n5 != 47) break block17;
                                                                if (n3 < 65 || n3 > 79) break block18;
                                                                n3 -= 32;
                                                                break block10;
                                                            }
                                                            if (n3 != 90) {
                                                                throw FormatException.getFormatInstance();
                                                            }
                                                            n5 = n3 = 58;
                                                            break block11;
                                                        }
                                                        if (n3 >= 65 && n3 <= 90) {
                                                            n3 += 32;
                                                            break block10;
                                                        } else {
                                                            throw FormatException.getFormatInstance();
                                                        }
                                                    }
                                                    if (n3 < 65 || n3 > 69) break block19;
                                                    n3 -= 38;
                                                    break block10;
                                                }
                                                if (n3 < 70 || n3 > 74) break block20;
                                                n3 -= 11;
                                                break block10;
                                            }
                                            if (n3 < 75 || n3 > 79) break block21;
                                            n3 += 16;
                                            break block10;
                                        }
                                        if (n3 < 80 || n3 > 84) break block22;
                                        n3 += 43;
                                        break block10;
                                    }
                                    if (n3 != 85) break block23;
                                }
                                n5 = n3 = 0;
                                break block11;
                            }
                            if (n3 == 86) {
                                n5 = n3 = 64;
                                break block11;
                            } else if (n3 == 87) {
                                n5 = n3 = 96;
                                break block11;
                            } else {
                                if (n3 != 88 && n3 != 89 && n3 != 90) {
                                    throw FormatException.getFormatInstance();
                                }
                                n5 = n3 = 127;
                            }
                            break block11;
                        }
                        if (n3 < 65 || n3 > 90) break;
                        n3 -= 64;
                    }
                    n5 = n3 = (int)((char)n3);
                }
                stringBuilder.append((char)n5);
                n3 = n4;
            }
            ++n3;
        }
        throw FormatException.getFormatInstance();
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) throws NotFoundException {
        int n2;
        int n3 = bitArray.getSize();
        int n4 = nArray.length;
        int n5 = n2;
        boolean bl = false;
        int n6 = 0;
        for (n2 = bitArray.getNextSet(0); n2 < n3; ++n2) {
            int n7;
            if (bitArray.get(n2) != bl) {
                nArray[n6] = nArray[n6] + 1;
                n7 = n5;
            } else {
                if (n6 == n4 - 1) {
                    if (Code39Reader.toNarrowWidePattern(nArray) == 148 && bitArray.isRange(Math.max(0, n5 - (n2 - n5) / 2), n5, false)) {
                        return new int[]{n5, n2};
                    }
                    n7 = n5 + (nArray[0] + nArray[1]);
                    n5 = n6 - 1;
                    System.arraycopy(nArray, 2, nArray, 0, n5);
                    nArray[n5] = 0;
                    nArray[n6] = 0;
                    n5 = n6 - 1;
                    n6 = n7;
                } else {
                    n7 = n6 + 1;
                    n6 = n5;
                    n5 = n7;
                }
                nArray[n5] = 1;
                bl ^= true;
                n7 = n6;
                n6 = n5;
            }
            n5 = n7;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static char patternToChar(int n2) throws NotFoundException {
        int[] nArray;
        for (int i3 = 0; i3 < (nArray = CHARACTER_ENCODINGS).length; ++i3) {
            if (nArray[i3] != n2) continue;
            return ALPHABET_STRING.charAt(i3);
        }
        if (n2 == 148) {
            return '*';
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = nArray.length;
            int n10 = Integer.MAX_VALUE;
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = nArray[n8];
                n6 = n10;
                if (n7 < n10) {
                    n6 = n10;
                    if (n7 > n4) {
                        n6 = n7;
                    }
                }
                n10 = n6;
            }
            n4 = 0;
            n8 = 0;
            n6 = 0;
            for (n9 = 0; n9 < n2; ++n9) {
                int n11 = nArray[n9];
                int n12 = n4;
                n5 = n8;
                n7 = n6;
                if (n11 > n10) {
                    n5 = n8 | 1 << n2 - 1 - n9;
                    n12 = n4 + 1;
                    n7 = n6 + n11;
                }
                n4 = n12;
                n8 = n5;
                n6 = n7;
            }
            if (n4 == 3) {
                n9 = n4;
                for (n7 = n3; n7 < n2 && n9 > 0; ++n7) {
                    n5 = nArray[n7];
                    n4 = n9;
                    if (n5 > n10) {
                        n4 = n9 - 1;
                        if (n5 * 2 >= n6) {
                            return -1;
                        }
                    }
                    n9 = n4;
                }
                return n8;
            }
            if (n4 <= 3) {
                return -1;
            }
            n4 = n10;
        }
    }

    @Override
    public Result decodeRow(int n2, BitArray object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        Object object3 = this.counters;
        Arrays.fill(object3, 0);
        Object object4 = this.decodeRowResult;
        ((StringBuilder)object4).setLength(0);
        object2 = Code39Reader.findAsteriskPattern((BitArray)object, object3);
        int n3 = ((BitArray)object).getNextSet((int)object2[1]);
        int n4 = ((BitArray)object).getSize();
        while (true) {
            int n5;
            Code39Reader.recordPattern((BitArray)object, n3, object3);
            int n6 = Code39Reader.toNarrowWidePattern(object3);
            if (n6 < 0) break;
            char c3 = Code39Reader.patternToChar(n6);
            ((StringBuilder)object4).append(c3);
            int n7 = ((int[])object3).length;
            n6 = n3;
            for (n5 = 0; n5 < n7; ++n5) {
                n6 += object3[n5];
            }
            n7 = ((BitArray)object).getNextSet(n6);
            if (c3 == '*') {
                ((StringBuilder)object4).setLength(((StringBuilder)object4).length() - 1);
                int n8 = ((int[])object3).length;
                n6 = 0;
                for (n5 = 0; n5 < n8; ++n5) {
                    n6 += object3[n5];
                }
                if (n7 != n4 && (n7 - n3 - n6) * 2 < n6) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (this.usingCheckDigit) {
                    n4 = ((StringBuilder)object4).length() - 1;
                    n7 = 0;
                    for (n5 = 0; n5 < n4; ++n5) {
                        n7 += ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(n5));
                    }
                    if (((StringBuilder)object4).charAt(n4) == ALPHABET_STRING.charAt(n7 % 43)) {
                        ((StringBuilder)object4).setLength(n4);
                    } else {
                        throw ChecksumException.getChecksumInstance();
                    }
                }
                if (((StringBuilder)object4).length() != 0) {
                    object = this.extendedMode ? Code39Reader.decodeExtended((CharSequence)object4) : ((StringBuilder)object4).toString();
                    float f3 = (float)(object2[1] + object2[0]) / 2.0f;
                    float f4 = n3;
                    float f5 = (float)n6 / 2.0f;
                    float f6 = n2;
                    object2 = new ResultPoint(f3, f6);
                    object4 = new ResultPoint(f4 + f5, f6);
                    object3 = (Object)BarcodeFormat.CODE_39;
                    return new Result((String)object, null, new ResultPoint[]{object2, object4}, (BarcodeFormat)((Object)object3));
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n3 = n7;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

