/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.oned.Code128Reader;
import com.ailiwean.core.zxing.core.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_CODE_A = 101;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';

    private static int chooseCode(CharSequence charSequence, int n2, int n3) {
        CType cType = Code128Writer.findCType(charSequence, n2);
        if (cType == CType.ONE_DIGIT) {
            if (n3 == 101) {
                return 101;
            }
            return 100;
        }
        if (cType == CType.UNCODABLE) {
            if (n2 < charSequence.length() && ((n2 = (int)charSequence.charAt(n2)) < 32 || n3 == 101 && (n2 < 96 || n2 >= 241 && n2 <= 244))) {
                return 101;
            }
            return 100;
        }
        if (n3 == 101 && cType == CType.FNC_1) {
            return 101;
        }
        if (n3 == 99) {
            return 99;
        }
        if (n3 == 100) {
            if (cType == CType.FNC_1) {
                return 100;
            }
            CType cType2 = Code128Writer.findCType(charSequence, n2 + 2);
            if (cType2 != CType.UNCODABLE && cType2 != CType.ONE_DIGIT) {
                if (cType2 == CType.FNC_1) {
                    if (Code128Writer.findCType(charSequence, n2 + 3) == CType.TWO_DIGITS) {
                        return 99;
                    }
                    return 100;
                }
                n2 += 4;
                while ((cType2 = Code128Writer.findCType(charSequence, n2)) == CType.TWO_DIGITS) {
                    n2 += 2;
                }
                if (cType2 == CType.ONE_DIGIT) {
                    return 100;
                }
                return 99;
            }
            return 100;
        }
        CType cType3 = cType;
        if (cType == CType.FNC_1) {
            cType3 = Code128Writer.findCType(charSequence, n2 + 1);
        }
        if (cType3 == CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }

    private static CType findCType(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        if (n2 >= n3) {
            return CType.UNCODABLE;
        }
        char c3 = charSequence.charAt(n2);
        if (c3 == '\u00f1') {
            return CType.FNC_1;
        }
        if (c3 >= '0' && c3 <= '9') {
            if (++n2 >= n3) {
                return CType.ONE_DIGIT;
            }
            if ((n2 = (int)charSequence.charAt(n2)) >= 48 && n2 <= 57) {
                return CType.TWO_DIGITS;
            }
            return CType.ONE_DIGIT;
        }
        return CType.UNCODABLE;
    }

    @Override
    public boolean[] encode(String object) {
        int n2;
        block20: {
            int n3;
            n2 = ((String)object).length();
            if (n2 < 1 || n2 > 80) break block20;
            int n4 = 0;
            block9: for (n3 = 0; n3 < n2; ++n3) {
                char c3 = ((String)object).charAt(n3);
                switch (c3) {
                    default: {
                        if (c3 > '\u007f') break;
                    }
                    case '\u00f1': 
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': {
                        continue block9;
                    }
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Bad character in input: ");
                ((StringBuilder)object).append(c3);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            Object object2 = new ArrayList<int[]>();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 1;
            while (n5 < n2) {
                int n9;
                int n10;
                block23: {
                    block21: {
                        block22: {
                            n10 = Code128Writer.chooseCode((CharSequence)object, n5, n7);
                            n3 = 100;
                            if (n10 != n7) break block21;
                            switch (((String)object).charAt(n5)) {
                                default: {
                                    break;
                                }
                                case '\u00f4': {
                                    n10 = n5;
                                    if (n7 == 101) {
                                        n3 = 101;
                                        n10 = n5;
                                    }
                                    break block22;
                                }
                                case '\u00f3': {
                                    n3 = 96;
                                    n10 = n5;
                                    break block22;
                                }
                                case '\u00f2': {
                                    n3 = 97;
                                    n10 = n5;
                                    break block22;
                                }
                                case '\u00f1': {
                                    n3 = 102;
                                    n10 = n5;
                                    break block22;
                                }
                            }
                            if (n7 != 100) {
                                if (n7 != 101) {
                                    n3 = Integer.parseInt(((String)object).substring(n5, n5 + 2));
                                    n10 = n5 + 1;
                                } else {
                                    n9 = ((String)object).charAt(n5) - 32;
                                    n10 = n5;
                                    n3 = n9;
                                    if (n9 < 0) {
                                        n3 = n9 + 96;
                                        n10 = n5;
                                    }
                                }
                            } else {
                                n3 = ((String)object).charAt(n5) - 32;
                                n10 = n5;
                            }
                        }
                        n9 = n10 + 1;
                        n10 = n7;
                        break block23;
                    }
                    n3 = n7 == 0 ? (n10 != 100 ? (n10 != 101 ? 105 : 103) : 104) : n10;
                    n9 = n5;
                }
                object2.add(Code128Reader.CODE_PATTERNS[n3]);
                n3 = n6 + n3 * n8;
                n5 = n9;
                n6 = n3;
                n7 = n10;
                if (n9 == 0) continue;
                ++n8;
                n5 = n9;
                n6 = n3;
                n7 = n10;
            }
            object2.add(Code128Reader.CODE_PATTERNS[n6 % 103]);
            object2.add(Code128Reader.CODE_PATTERNS[106]);
            object = object2.iterator();
            n3 = 0;
            while (object.hasNext()) {
                int[] nArray = (int[])object.next();
                n8 = nArray.length;
                for (n5 = 0; n5 < n8; ++n5) {
                    n3 += nArray[n5];
                }
            }
            object = new boolean[n3];
            object2 = object2.iterator();
            n3 = n4;
            while (object2.hasNext()) {
                n3 += Code128Writer.appendPattern((boolean[])object, n3, (int[])object2.next(), true);
            }
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Contents length should be between 1 and 80 characters, but got ");
        ((StringBuilder)object).append(n2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_128);
    }

    private static enum CType {
        UNCODABLE,
        ONE_DIGIT,
        TWO_DIGITS,
        FNC_1;

    }
}

