/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.oned;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final float MAX_ACCEPTABLE = 2.0f;
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final float PADDING = 1.5f;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private int counterLength = 0;
    private int[] counters;
    private final StringBuilder decodeRowResult = new StringBuilder(20);

    public CodaBarReader() {
        this.counters = new int[80];
    }

    static boolean arrayContains(char[] cArray, char c3) {
        if (cArray != null) {
            int n2 = cArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (cArray[i3] != c3) continue;
                return true;
            }
        }
        return false;
    }

    private void counterAppend(int n2) {
        int[] nArray = this.counters;
        int n3 = this.counterLength;
        nArray[n3] = n2;
        this.counterLength = n3 + 1;
        n2 = this.counterLength;
        if (n2 >= nArray.length) {
            int[] nArray2 = new int[n2 * 2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            this.counters = nArray2;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i3 = 1; i3 < this.counterLength; i3 += 2) {
            int n2 = this.toNarrowWidePattern(i3);
            if (n2 == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n2])) continue;
            n2 = 0;
            for (int i4 = i3; i4 < i3 + 7; ++i4) {
                n2 += this.counters[i4];
            }
            if (i3 != 1 && this.counters[i3 - 1] < n2 / 2) continue;
            return i3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void setCounters(BitArray bitArray) throws NotFoundException {
        int n2;
        int n3 = 0;
        this.counterLength = 0;
        int n4 = bitArray.getNextUnset(0);
        if (n4 < (n2 = bitArray.getSize())) {
            boolean bl = true;
            while (n4 < n2) {
                if (bitArray.get(n4) != bl) {
                    ++n3;
                } else {
                    this.counterAppend(n3);
                    bl ^= true;
                    n3 = 1;
                }
                ++n4;
            }
            this.counterAppend(n3);
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int toNarrowWidePattern(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 + 7;
        if (n7 >= this.counterLength) {
            return -1;
        }
        int[] nArray = this.counters;
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        int n10 = Integer.MAX_VALUE;
        int n11 = 0;
        for (n6 = n2; n6 < n7; n6 += 2) {
            n5 = nArray[n6];
            n4 = n10;
            if (n5 < n10) {
                n4 = n5;
            }
            n3 = n11;
            if (n5 > n11) {
                n3 = n5;
            }
            n10 = n4;
            n11 = n3;
        }
        int n12 = (n10 + n11) / 2;
        n4 = 0;
        n3 = n8;
        for (n11 = n2 + 1; n11 < n7; n11 += 2) {
            n5 = nArray[n11];
            n6 = n3;
            if (n5 < n3) {
                n6 = n5;
            }
            n10 = n4;
            if (n5 > n4) {
                n10 = n5;
            }
            n3 = n6;
            n4 = n10;
        }
        n5 = (n3 + n4) / 2;
        n4 = 0;
        n6 = 128;
        n11 = 0;
        while (true) {
            if (n4 >= 7) break;
            n3 = (n4 & 1) == 0 ? n12 : n5;
            n6 >>= 1;
            n10 = n11;
            if (nArray[n2 + n4] > n3) {
                n10 = n11 | n6;
            }
            ++n4;
            n11 = n10;
        }
        for (n10 = n9; n10 < (nArray = CHARACTER_ENCODINGS).length; ++n10) {
            if (nArray[n10] != n11) continue;
            return n10;
        }
        return -1;
    }

    private void validatePattern(int n2) throws NotFoundException {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = nArray2 = new int[4];
        nArray2[0] = 0;
        nArray3[1] = 0;
        nArray3[2] = 0;
        nArray3[3] = 0;
        int[] nArray4 = nArray = new int[4];
        nArray[0] = 0;
        nArray4[1] = 0;
        nArray4[2] = 0;
        nArray4[3] = 0;
        int n3 = this.decodeRowResult.length() - 1;
        int n4 = 0;
        int n5 = n2;
        int n6 = 0;
        while (true) {
            int n7;
            int n8 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n6)];
            for (n7 = 6; n7 >= 0; --n7) {
                int n9 = (n7 & 1) + (n8 & 1) * 2;
                nArray2[n9] = nArray2[n9] + this.counters[n5 + n7];
                nArray[n9] = nArray[n9] + 1;
                n8 >>= 1;
            }
            if (n6 >= n3) {
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                n7 = 0;
                while (true) {
                    n5 = n4;
                    n6 = n2;
                    if (n7 >= 2) break;
                    fArray2[n7] = 0.0f;
                    n5 = n7 + 2;
                    fArray2[n5] = ((float)nArray2[n7] / (float)nArray[n7] + (float)nArray2[n5] / (float)nArray[n5]) / 2.0f;
                    fArray[n7] = fArray2[n5];
                    fArray[n5] = ((float)nArray2[n5] * 2.0f + 1.5f) / (float)nArray[n5];
                    ++n7;
                }
                while (true) {
                    n2 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n5)];
                    for (n7 = 6; n7 >= 0; --n7) {
                        float f3 = this.counters[n6 + n7];
                        n8 = (n7 & 1) + (n2 & 1) * 2;
                        if (!(f3 < fArray2[n8]) && !(f3 > fArray[n8])) {
                            n2 >>= 1;
                            continue;
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    if (n5 >= n3) {
                        return;
                    }
                    n6 += 8;
                    ++n5;
                }
            }
            n5 += 8;
            ++n6;
        }
    }

    @Override
    public Result decodeRow(int n2, BitArray object, Map<DecodeHintType, ?> object2) throws NotFoundException {
        int n3;
        Arrays.fill(this.counters, 0);
        this.setCounters((BitArray)object);
        int n4 = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        int n5 = n4;
        while ((n3 = this.toNarrowWidePattern(n5)) != -1) {
            this.decodeRowResult.append((char)n3);
            int n6 = n5 + 8;
            if (this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n3])) {
                n5 = n6;
                if (n6 < this.counterLength) continue;
            }
            object = this.counters;
            int n7 = n6 - 1;
            Object object3 = object[n7];
            n5 = 0;
            for (n3 = -8; n3 < -1; ++n3) {
                n5 += this.counters[n6 + n3];
            }
            if (n6 < this.counterLength && object3 < n5 / 2) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.validatePattern(n4);
            for (n5 = 0; n5 < this.decodeRowResult.length(); ++n5) {
                object = this.decodeRowResult;
                ((StringBuilder)object).setCharAt(n5, ALPHABET[((StringBuilder)object).charAt(n5)]);
            }
            char c3 = this.decodeRowResult.charAt(0);
            if (CodaBarReader.arrayContains(STARTEND_ENCODING, c3)) {
                object = this.decodeRowResult;
                c3 = ((StringBuilder)object).charAt(((StringBuilder)object).length() - 1);
                if (CodaBarReader.arrayContains(STARTEND_ENCODING, c3)) {
                    if (this.decodeRowResult.length() > 3) {
                        if (object2 == null || !object2.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
                            object = this.decodeRowResult;
                            ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
                            this.decodeRowResult.deleteCharAt(0);
                        }
                        n5 = 0;
                        for (n3 = 0; n3 < n4; ++n3) {
                            n5 += this.counters[n3];
                        }
                        float f3 = n5;
                        while (n4 < n7) {
                            n5 += this.counters[n4];
                            ++n4;
                        }
                        float f4 = n5;
                        String string2 = this.decodeRowResult.toString();
                        float f5 = n2;
                        object = new ResultPoint(f3, f5);
                        ResultPoint resultPoint = new ResultPoint(f4, f5);
                        object2 = BarcodeFormat.CODABAR;
                        return new Result(string2, null, new ResultPoint[]{object, resultPoint}, (BarcodeFormat)((Object)object2));
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

