/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.multi.qrcode.detector;

import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.ResultPointCallback;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPattern;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPatternFinder;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final FinderPattern[][] EMPTY_FP_2D_ARRAY;
    private static final FinderPattern[] EMPTY_FP_ARRAY;
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY;
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;

    static {
        EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
        EMPTY_FP_ARRAY = new FinderPattern[0];
        EMPTY_FP_2D_ARRAY = new FinderPattern[0][];
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMultipleBestPatterns() throws NotFoundException {
        List<FinderPattern> list = this.getPossibleCenters();
        int n2 = list.size();
        if (n2 >= 3) {
            if (n2 == 3) {
                return new FinderPattern[][]{list.toArray(EMPTY_FP_ARRAY)};
            }
            Collections.sort(list, new ModuleSizeComparator());
            ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
            block0: for (int i3 = 0; i3 < n2 - 2; ++i3) {
                FinderPattern finderPattern = list.get(i3);
                if (finderPattern == null) continue;
                block1: for (int i4 = i3 + 1; i4 < n2 - 1; ++i4) {
                    FinderPattern finderPattern2 = list.get(i4);
                    if (finderPattern2 == null) continue;
                    float f3 = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                    if (Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) > 0.5f && f3 >= 0.05f) continue block0;
                    for (int i5 = i4 + 1; i5 < n2; ++i5) {
                        double d3;
                        double d4;
                        Object object = list.get(i5);
                        if (object == null) continue;
                        f3 = (finderPattern2.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), ((FinderPattern)object).getEstimatedModuleSize());
                        if (Math.abs(finderPattern2.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) > 0.5f && f3 >= 0.05f) continue block1;
                        ResultPoint[] resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, object};
                        ResultPoint.orderBestPatterns(resultPointArray);
                        object = new FinderPatternInfo((FinderPattern[])resultPointArray);
                        float f4 = ResultPoint.distance(((FinderPatternInfo)object).getTopLeft(), ((FinderPatternInfo)object).getBottomLeft());
                        f3 = ResultPoint.distance(((FinderPatternInfo)object).getTopRight(), ((FinderPatternInfo)object).getBottomLeft());
                        float f5 = ResultPoint.distance(((FinderPatternInfo)object).getTopLeft(), ((FinderPatternInfo)object).getTopRight());
                        float f6 = (f4 + f5) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                        if (f6 > 180.0f || f6 < 9.0f || Math.abs((f4 - f5) / Math.min(f4, f5)) >= 0.1f || Math.abs((f3 - (f4 = (float)Math.sqrt((d4 = (double)f4) * d4 + (d3 = (double)f5) * d3))) / Math.min(f3, f4)) >= 0.1f) continue;
                        arrayList.add(resultPointArray);
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                return (FinderPattern[][])arrayList.toArray((T[])EMPTY_FP_2D_ARRAY);
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> resultPointArray) throws NotFoundException {
        int n2;
        int n3 = 0;
        int n4 = resultPointArray != null && resultPointArray.containsKey((Object)DecodeHintType.TRY_HARDER) ? 1 : 0;
        FinderPattern[][] finderPatternArray = this.getImage();
        int n5 = finderPatternArray.getHeight();
        int n6 = finderPatternArray.getWidth();
        int n7 = n5 * 3 / 388;
        if (n7 < 3 || n4 != 0) {
            n7 = 3;
        }
        resultPointArray = (ResultPoint[])new int[5];
        for (int i3 = n7 - 1; i3 < n5; i3 += n7) {
            MultiFinderPatternFinder.doClearCounts((int[])resultPointArray);
            n4 = 0;
            for (int i4 = 0; i4 < n6; ++i4) {
                if (finderPatternArray.get(i4, i3)) {
                    n2 = n4;
                    if ((n4 & 1) == 1) {
                        n2 = n4 + 1;
                    }
                    resultPointArray[n2] = resultPointArray[n2] + true;
                    n4 = n2;
                    continue;
                }
                if ((n4 & 1) == 0) {
                    if (n4 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross((int[])resultPointArray) && this.handlePossibleCenter((int[])resultPointArray, i3, i4)) {
                            MultiFinderPatternFinder.doClearCounts((int[])resultPointArray);
                            n4 = 0;
                            continue;
                        }
                        MultiFinderPatternFinder.doShiftCounts2((int[])resultPointArray);
                        n4 = 3;
                        continue;
                    }
                    resultPointArray[++n4] = resultPointArray[n4] + true;
                    continue;
                }
                resultPointArray[n4] = resultPointArray[n4] + true;
            }
            if (!MultiFinderPatternFinder.foundPatternCross((int[])resultPointArray)) continue;
            this.handlePossibleCenter((int[])resultPointArray, i3, n6);
        }
        finderPatternArray = this.selectMultipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList = new ArrayList<FinderPatternInfo>();
        n2 = finderPatternArray.length;
        for (n4 = n3; n4 < n2; ++n4) {
            resultPointArray = finderPatternArray[n4];
            ResultPoint.orderBestPatterns(resultPointArray);
            arrayList.add(new FinderPatternInfo((FinderPattern[])resultPointArray));
        }
        if (arrayList.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return arrayList.toArray(EMPTY_RESULT_ARRAY);
    }

    private static final class ModuleSizeComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            double d3 = finderPattern2.getEstimatedModuleSize() - finderPattern.getEstimatedModuleSize();
            int n2 = d3 < 0.0 ? -1 : (d3 > 0.0 ? 1 : 0);
            return n2;
        }
    }
}

