/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.multi.qrcode;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.multi.MultipleBarcodeReader;
import com.ailiwean.core.zxing.core.multi.qrcode.detector.MultiDetector;
import com.ailiwean.core.zxing.core.qrcode.QRCodeReader;
import com.ailiwean.core.zxing.core.qrcode.decoder.QRCodeDecoderMetaData;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];

    static List<Result> processStructuredAppend(List<Result> object) {
        Object object2;
        ArrayList<Result> arrayList = new ArrayList<Result>();
        Object object3 = new ArrayList<Result>();
        Object object4 = object.iterator();
        while (object4.hasNext()) {
            object2 = object4.next();
            if (((Result)object2).getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) {
                object3.add(object2);
                continue;
            }
            arrayList.add((Result)object2);
        }
        if (object3.isEmpty()) {
            return object;
        }
        Collections.sort(object3, new SAComparator());
        object2 = new StringBuilder();
        object4 = new ByteArrayOutputStream();
        object = new ByteArrayOutputStream();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            Object object5 = (Result)object3.next();
            ((StringBuilder)object2).append(((Result)object5).getText());
            Object object6 = ((Result)object5).getRawBytes();
            ((ByteArrayOutputStream)object4).write((byte[])object6, 0, ((byte[])object6).length);
            object6 = (Iterable)((Result)object5).getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS);
            if (object6 == null) continue;
            object6 = object6.iterator();
            while (object6.hasNext()) {
                object5 = (byte[])object6.next();
                ((ByteArrayOutputStream)object).write((byte[])object5, 0, ((Object)object5).length);
            }
        }
        object2 = new Result(((StringBuilder)object2).toString(), ((ByteArrayOutputStream)object4).toByteArray(), NO_POINTS, BarcodeFormat.QR_CODE);
        if (((ByteArrayOutputStream)object).size() > 0) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, Collections.singletonList(((ByteArrayOutputStream)object).toByteArray()));
        }
        arrayList.add((Result)object2);
        return arrayList;
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public Result[] decodeMultiple(BinaryBitmap detectorResultArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        detectorResultArray = new MultiDetector(detectorResultArray.getBlackMatrix()).detectMulti(map);
        int n2 = detectorResultArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                if (!arrayList.isEmpty()) return QRCodeMultiReader.processStructuredAppend(arrayList).toArray(EMPTY_RESULT_ARRAY);
                return EMPTY_RESULT_ARRAY;
            }
            DetectorResult detectorResult = detectorResultArray[n3];
            try {
                String string2;
                DecoderResult decoderResult = this.getDecoder().decode(detectorResult.getBits(), map);
                ResultPoint[] resultPointArray = detectorResult.getPoints();
                if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
                    ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
                }
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
                List<byte[]> list = decoderResult.getByteSegments();
                if (list != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
                }
                if ((string2 = decoderResult.getECLevel()) != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
                }
                if (decoderResult.hasStructuredAppend()) {
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
                }
                arrayList.add(result);
            }
            catch (ReaderException readerException) {}
            ++n3;
        }
    }

    private static final class SAComparator
    implements Comparator<Result>,
    Serializable {
        private SAComparator() {
        }

        @Override
        public int compare(Result result, Result result2) {
            return Integer.compare((Integer)result.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE), (Integer)result2.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE));
        }
    }
}

