/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.maxicode;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final int MATRIX_HEIGHT = 33;
    private static final int MATRIX_WIDTH = 30;
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        Object object = bitMatrix.getEnclosingRectangle();
        if (object != null) {
            int n2 = object[0];
            int n3 = object[1];
            int n4 = object[2];
            int n5 = object[3];
            object = new BitMatrix(30, 33);
            for (int i3 = 0; i3 < 33; ++i3) {
                int n6 = (i3 * n5 + n5 / 2) / 33;
                for (int i4 = 0; i4 < 30; ++i4) {
                    if (!bitMatrix.get((i4 * n4 + n4 / 2 + (i3 & 1) * n4 / 2) / 30 + n2, n6 + n3)) continue;
                    object.set(i4, i3);
                }
            }
            return object;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        object = MaxiCodeReader.extractPureBits(((BinaryBitmap)object).getBlackMatrix());
        object2 = this.decoder.decode((BitMatrix)object, (Map<DecodeHintType, ?>)object2);
        object = new Result(((DecoderResult)object2).getText(), ((DecoderResult)object2).getRawBytes(), NO_POINTS, BarcodeFormat.MAXICODE);
        if ((object2 = ((DecoderResult)object2).getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object2);
        }
        return object;
    }

    @Override
    public void reset() {
    }
}

