/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.encoder;

import com.ailiwean.core.zxing.core.datamatrix.encoder.C40Encoder;
import com.ailiwean.core.zxing.core.datamatrix.encoder.EncoderContext;
import com.ailiwean.core.zxing.core.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c3 = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            this.encodeChar(c3, stringBuilder);
            if (stringBuilder.length() % 3 != 0) continue;
            X12Encoder.writeNextTriplet(encoderContext, stringBuilder);
            if (HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode()) == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(0);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    @Override
    int encodeChar(char c3, StringBuilder stringBuilder) {
        if (c3 != '\r') {
            if (c3 != ' ') {
                if (c3 != '*') {
                    if (c3 != '>') {
                        if (c3 >= '0' && c3 <= '9') {
                            stringBuilder.append((char)(c3 - 48 + 4));
                        } else if (c3 >= 'A' && c3 <= 'Z') {
                            stringBuilder.append((char)(c3 - 65 + 14));
                        } else {
                            HighLevelEncoder.illegalCharacter(c3);
                        }
                    } else {
                        stringBuilder.append('\u0002');
                    }
                } else {
                    stringBuilder.append('\u0001');
                }
            } else {
                stringBuilder.append('\u0003');
            }
        } else {
            stringBuilder.append('\u0000');
        }
        return 1;
    }

    @Override
    public int getEncodingMode() {
        return 3;
    }

    @Override
    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.updateSymbolInfo();
        int n2 = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
        int n3 = stringBuilder.length();
        encoderContext.pos -= n3;
        if (encoderContext.getRemainingCharacters() > 1 || n2 > 1 || encoderContext.getRemainingCharacters() != n2) {
            encoderContext.writeCodeword('\u00fe');
        }
        if (encoderContext.getNewEncoding() < 0) {
            encoderContext.signalEncoderChange(0);
        }
    }
}

