/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.encoder;

import java.util.Arrays;

public class DefaultPlacement {
    private final byte[] bits;
    private final CharSequence codewords;
    private final int numcols;
    private final int numrows;

    public DefaultPlacement(CharSequence charSequence, int n2, int n3) {
        this.codewords = charSequence;
        this.numcols = n2;
        this.numrows = n3;
        this.bits = new byte[n2 * n3];
        Arrays.fill(this.bits, (byte)-1);
    }

    private void corner1(int n2) {
        this.module(this.numrows - 1, 0, n2, 1);
        this.module(this.numrows - 1, 1, n2, 2);
        this.module(this.numrows - 1, 2, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 1, n2, 6);
        this.module(2, this.numcols - 1, n2, 7);
        this.module(3, this.numcols - 1, n2, 8);
    }

    private void corner2(int n2) {
        this.module(this.numrows - 3, 0, n2, 1);
        this.module(this.numrows - 2, 0, n2, 2);
        this.module(this.numrows - 1, 0, n2, 3);
        this.module(0, this.numcols - 4, n2, 4);
        this.module(0, this.numcols - 3, n2, 5);
        this.module(0, this.numcols - 2, n2, 6);
        this.module(0, this.numcols - 1, n2, 7);
        this.module(1, this.numcols - 1, n2, 8);
    }

    private void corner3(int n2) {
        this.module(this.numrows - 3, 0, n2, 1);
        this.module(this.numrows - 2, 0, n2, 2);
        this.module(this.numrows - 1, 0, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 1, n2, 6);
        this.module(2, this.numcols - 1, n2, 7);
        this.module(3, this.numcols - 1, n2, 8);
    }

    private void corner4(int n2) {
        this.module(this.numrows - 1, 0, n2, 1);
        this.module(this.numrows - 1, this.numcols - 1, n2, 2);
        this.module(0, this.numcols - 3, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 3, n2, 6);
        this.module(1, this.numcols - 2, n2, 7);
        this.module(1, this.numcols - 1, n2, 8);
    }

    private void module(int n2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n3;
        if (n2 < 0) {
            n7 = this.numrows;
            n6 = n2 + n7;
            n7 = n3 + (4 - (n7 + 4) % 8);
        }
        n3 = n6;
        n2 = n7;
        if (n7 < 0) {
            n3 = this.numcols;
            n2 = n7 + n3;
            n3 = n6 + (4 - (n3 + 4) % 8);
        }
        n4 = this.codewords.charAt(n4);
        boolean bl = true;
        if ((n4 & 1 << 8 - n5) == 0) {
            bl = false;
        }
        this.setBit(n2, n3, bl);
    }

    private boolean noBit(int n2, int n3) {
        boolean bl = this.bits[n3 * this.numcols + n2] < 0;
        return bl;
    }

    private void setBit(int n2, int n3, boolean bl) {
        this.bits[n3 * this.numcols + n2] = (byte)(bl ? 1 : 0);
    }

    private void utah(int n2, int n3, int n4) {
        int n5 = n2 - 2;
        int n6 = n3 - 2;
        this.module(n5, n6, n4, 1);
        int n7 = n3 - 1;
        this.module(n5, n7, n4, 2);
        n5 = n2 - 1;
        this.module(n5, n6, n4, 3);
        this.module(n5, n7, n4, 4);
        this.module(n5, n3, n4, 5);
        this.module(n2, n6, n4, 6);
        this.module(n2, n7, n4, 7);
        this.module(n2, n3, n4, 8);
    }

    public final boolean getBit(int n2, int n3) {
        n2 = this.bits[n3 * this.numcols + n2];
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    final byte[] getBits() {
        return this.bits;
    }

    final int getNumcols() {
        return this.numcols;
    }

    final int getNumrows() {
        return this.numrows;
    }

    public final void place() {
        int n2;
        int n3;
        int n4 = 4;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            int n7 = n6;
            if (n4 == this.numrows) {
                n7 = n6;
                if (n5 == 0) {
                    this.corner1(n6);
                    n7 = n6 + 1;
                }
            }
            int n8 = n7;
            if (n4 == this.numrows - 2) {
                n8 = n7;
                if (n5 == 0) {
                    n8 = n7;
                    if (this.numcols % 4 != 0) {
                        this.corner2(n7);
                        n8 = n7 + 1;
                    }
                }
            }
            n6 = n8;
            if (n4 == this.numrows - 2) {
                n6 = n8;
                if (n5 == 0) {
                    n6 = n8;
                    if (this.numcols % 8 == 4) {
                        this.corner3(n8);
                        n6 = n8 + 1;
                    }
                }
            }
            int n9 = n4;
            n8 = n5;
            n7 = n6;
            if (n4 == this.numrows + 4) {
                n9 = n4;
                n8 = n5;
                n7 = n6;
                if (n5 == 2) {
                    n9 = n4;
                    n8 = n5;
                    n7 = n6;
                    if (this.numcols % 8 == 0) {
                        this.corner4(n6);
                        n7 = n6 + 1;
                        n8 = n5;
                        n9 = n4;
                    }
                }
            }
            do {
                n5 = n7;
                if (n9 < this.numrows) {
                    n5 = n7;
                    if (n8 >= 0) {
                        n5 = n7;
                        if (this.noBit(n8, n9)) {
                            this.utah(n9, n8, n7);
                            n5 = n7 + 1;
                        }
                    }
                }
                n6 = n9 - 2;
                n4 = n8 + 2;
                if (n6 < 0) break;
                n9 = n6;
                n8 = n4;
                n7 = n5;
            } while (n4 < this.numcols);
            ++n6;
            n4 += 3;
            do {
                n7 = n5;
                if (n6 >= 0) {
                    n7 = n5;
                    if (n4 < this.numcols) {
                        n7 = n5;
                        if (this.noBit(n4, n6)) {
                            this.utah(n6, n4, n5);
                            n7 = n5 + 1;
                        }
                    }
                }
                n8 = n6 + 2;
                n9 = n4 - 2;
                if (n8 >= this.numrows) break;
                n6 = n8;
                n4 = n9;
                n5 = n7;
            } while (n9 >= 0);
            n3 = this.numrows;
            n4 = n8 += 3;
            n5 = ++n9;
            n6 = n7;
            if (n8 < n3) continue;
            n2 = this.numcols;
            n4 = n8;
            n5 = n9;
            n6 = n7;
            if (n9 >= n2) break;
        }
        if (this.noBit(n2 - 1, n3 - 1)) {
            this.setBit(this.numcols - 1, this.numrows - 1, true);
            this.setBit(this.numcols - 2, this.numrows - 2, true);
        }
    }
}

