/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.encoder;

import com.ailiwean.core.zxing.core.datamatrix.encoder.Encoder;
import com.ailiwean.core.zxing.core.datamatrix.encoder.EncoderContext;
import com.ailiwean.core.zxing.core.datamatrix.encoder.HighLevelEncoder;

class C40Encoder
implements Encoder {
    C40Encoder() {
    }

    private int backtrackOneCharacter(EncoderContext encoderContext, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n2) {
        int n3 = stringBuilder.length();
        stringBuilder.delete(n3 - n2, n3);
        --encoderContext.pos;
        n2 = this.encodeChar(encoderContext.getCurrentChar(), stringBuilder2);
        encoderContext.resetSymbolInfo();
        return n2;
    }

    private static String encodeToCodewords(CharSequence charSequence, int n2) {
        n2 = charSequence.charAt(n2) * 1600 + charSequence.charAt(n2 + 1) * 40 + charSequence.charAt(n2 + 2) + 1;
        return new String(new char[]{(char)(n2 / 256), (char)(n2 % 256)});
    }

    static void writeNextTriplet(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.writeCodewords(C40Encoder.encodeToCodewords(stringBuilder, 0));
        stringBuilder.delete(0, 3);
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c3 = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            int n2 = this.encodeChar(c3, stringBuilder);
            int n3 = stringBuilder.length() / 3;
            n3 = encoderContext.getCodewordCount() + n3 * 2;
            encoderContext.updateSymbolInfo(n3);
            int n4 = encoderContext.getSymbolInfo().getDataCapacity() - n3;
            if (!encoderContext.hasMoreCharacters()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                n3 = n2;
                if (stringBuilder.length() % 3 == 2) {
                    n3 = n2;
                    if (n4 != 2) {
                        n3 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n2);
                    }
                }
                while (stringBuilder.length() % 3 == 1 && (n3 > 3 || n4 != 1)) {
                    n3 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n3);
                }
                break;
            }
            if (stringBuilder.length() % 3 != 0 || HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode()) == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(0);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    int encodeChar(char c3, StringBuilder stringBuilder) {
        if (c3 == ' ') {
            stringBuilder.append('\u0003');
            return 1;
        }
        if (c3 >= '0' && c3 <= '9') {
            stringBuilder.append((char)(c3 - 48 + 4));
            return 1;
        }
        if (c3 >= 'A' && c3 <= 'Z') {
            stringBuilder.append((char)(c3 - 65 + 14));
            return 1;
        }
        if (c3 < ' ') {
            stringBuilder.append('\u0000');
            stringBuilder.append(c3);
            return 2;
        }
        if (c3 <= '/') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c3 - 33));
            return 2;
        }
        if (c3 <= '@') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c3 - 58 + 15));
            return 2;
        }
        if (c3 <= '_') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c3 - 91 + 22));
            return 2;
        }
        if (c3 <= '\u007f') {
            stringBuilder.append('\u0002');
            stringBuilder.append((char)(c3 - 96));
            return 2;
        }
        stringBuilder.append("\u0001\u001e");
        return this.encodeChar((char)(c3 - 128), stringBuilder) + 2;
    }

    @Override
    public int getEncodingMode() {
        return 1;
    }

    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        block13: {
            block11: {
                int n2;
                int n3;
                block12: {
                    block10: {
                        n3 = stringBuilder.length() / 3;
                        n2 = stringBuilder.length() % 3;
                        n3 = encoderContext.getCodewordCount() + n3 * 2;
                        encoderContext.updateSymbolInfo(n3);
                        n3 = encoderContext.getSymbolInfo().getDataCapacity() - n3;
                        if (n2 != 2) break block10;
                        stringBuilder.append('\u0000');
                        while (stringBuilder.length() >= 3) {
                            C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                        }
                        if (encoderContext.hasMoreCharacters()) {
                            encoderContext.writeCodeword('\u00fe');
                        }
                        break block11;
                    }
                    if (n3 != 1 || n2 != 1) break block12;
                    while (stringBuilder.length() >= 3) {
                        C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                    }
                    if (encoderContext.hasMoreCharacters()) {
                        encoderContext.writeCodeword('\u00fe');
                    }
                    --encoderContext.pos;
                    break block11;
                }
                if (n2 != 0) break block13;
                while (stringBuilder.length() >= 3) {
                    C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                }
                if (n3 > 0 || encoderContext.hasMoreCharacters()) {
                    encoderContext.writeCodeword('\u00fe');
                }
            }
            encoderContext.signalEncoderChange(0);
            return;
        }
        throw new IllegalStateException("Unexpected case. Please report!");
    }
}

