/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.detector;

import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.common.GridSampler;
import com.ailiwean.core.zxing.core.common.detector.WhiteRectangleDetector;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) throws NotFoundException {
        this.image = bitMatrix;
        this.rectangleDetector = new WhiteRectangleDetector(bitMatrix);
    }

    private ResultPoint correctTopRight(ResultPoint[] object) {
        ResultPoint resultPoint = object[0];
        ResultPoint resultPoint2 = object[1];
        ResultPoint resultPoint3 = object[2];
        ResultPoint resultPoint4 = object[3];
        int n2 = this.transitionsBetween(resultPoint, resultPoint4);
        ResultPoint resultPoint5 = Detector.shiftPoint(resultPoint, resultPoint2, (this.transitionsBetween(resultPoint2, resultPoint4) + 1) * 4);
        object = Detector.shiftPoint(resultPoint3, resultPoint2, (n2 + 1) * 4);
        n2 = this.transitionsBetween(resultPoint5, resultPoint4);
        int n3 = this.transitionsBetween((ResultPoint)object, resultPoint4);
        float f3 = resultPoint4.getX();
        float f4 = resultPoint3.getX();
        float f5 = resultPoint2.getX();
        float f6 = n2 + 1;
        resultPoint3 = new ResultPoint(f3 + (f4 - f5) / f6, resultPoint4.getY() + (resultPoint3.getY() - resultPoint2.getY()) / f6);
        f6 = resultPoint4.getX();
        f4 = resultPoint.getX();
        f5 = resultPoint2.getX();
        f3 = n3 + 1;
        resultPoint2 = new ResultPoint(f6 + (f4 - f5) / f3, resultPoint4.getY() + (resultPoint.getY() - resultPoint2.getY()) / f3);
        if (!this.isValid(resultPoint3)) {
            if (this.isValid(resultPoint2)) {
                return resultPoint2;
            }
            return null;
        }
        if (!this.isValid(resultPoint2)) {
            return resultPoint3;
        }
        if (this.transitionsBetween(resultPoint5, resultPoint3) + this.transitionsBetween((ResultPoint)object, resultPoint3) > this.transitionsBetween(resultPoint5, resultPoint2) + this.transitionsBetween((ResultPoint)object, resultPoint2)) {
            return resultPoint3;
        }
        return resultPoint2;
    }

    private ResultPoint[] detectSolid1(ResultPoint[] resultPointArray) {
        ResultPoint resultPoint = resultPointArray[0];
        ResultPoint resultPoint2 = resultPointArray[1];
        ResultPoint resultPoint3 = resultPointArray[3];
        ResultPoint resultPoint4 = resultPointArray[2];
        int n2 = this.transitionsBetween(resultPoint, resultPoint2);
        int n3 = this.transitionsBetween(resultPoint2, resultPoint3);
        int n4 = this.transitionsBetween(resultPoint3, resultPoint4);
        int n5 = this.transitionsBetween(resultPoint4, resultPoint);
        resultPointArray = new ResultPoint[]{resultPoint4, resultPoint, resultPoint2, resultPoint3};
        int n6 = n2;
        if (n2 > n3) {
            resultPointArray[0] = resultPoint;
            resultPointArray[1] = resultPoint2;
            resultPointArray[2] = resultPoint3;
            resultPointArray[3] = resultPoint4;
            n6 = n3;
        }
        n2 = n6;
        if (n6 > n4) {
            resultPointArray[0] = resultPoint2;
            resultPointArray[1] = resultPoint3;
            resultPointArray[2] = resultPoint4;
            resultPointArray[3] = resultPoint;
            n2 = n4;
        }
        if (n2 > n5) {
            resultPointArray[0] = resultPoint3;
            resultPointArray[1] = resultPoint4;
            resultPointArray[2] = resultPoint;
            resultPointArray[3] = resultPoint2;
        }
        return resultPointArray;
    }

    private ResultPoint[] detectSolid2(ResultPoint[] resultPointArray) {
        ResultPoint resultPoint = resultPointArray[0];
        ResultPoint resultPoint2 = resultPointArray[1];
        ResultPoint resultPoint3 = resultPointArray[2];
        ResultPoint resultPoint4 = resultPointArray[3];
        int n2 = (this.transitionsBetween(resultPoint, resultPoint4) + 1) * 4;
        ResultPoint resultPoint5 = Detector.shiftPoint(resultPoint2, resultPoint3, n2);
        ResultPoint resultPoint6 = Detector.shiftPoint(resultPoint3, resultPoint2, n2);
        if (this.transitionsBetween(resultPoint5, resultPoint) < this.transitionsBetween(resultPoint6, resultPoint4)) {
            resultPointArray[0] = resultPoint;
            resultPointArray[1] = resultPoint2;
            resultPointArray[2] = resultPoint3;
            resultPointArray[3] = resultPoint4;
        } else {
            resultPointArray[0] = resultPoint2;
            resultPointArray[1] = resultPoint3;
            resultPointArray[2] = resultPoint4;
            resultPointArray[3] = resultPoint;
        }
        return resultPointArray;
    }

    private boolean isValid(ResultPoint resultPoint) {
        boolean bl = resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.getWidth() && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.getHeight();
        return bl;
    }

    private static ResultPoint moveAway(ResultPoint resultPoint, float f3, float f4) {
        float f5 = resultPoint.getX();
        float f6 = resultPoint.getY();
        f3 = f5 < f3 ? f5 - 1.0f : f5 + 1.0f;
        f4 = f6 < f4 ? f6 - 1.0f : f6 + 1.0f;
        return new ResultPoint(f3, f4);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2, int n3) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        float f3 = (float)n2 - 0.5f;
        float f4 = (float)n3 - 0.5f;
        return gridSampler.sampleGrid(bitMatrix, n2, n3, 0.5f, 0.5f, f3, 0.5f, f3, f4, 0.5f, f4, resultPoint.getX(), resultPoint.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private static ResultPoint shiftPoint(ResultPoint resultPoint, ResultPoint resultPoint2, int n2) {
        float f3 = resultPoint2.getX();
        float f4 = resultPoint.getX();
        float f5 = n2 + 1;
        f4 = (f3 - f4) / f5;
        f5 = (resultPoint2.getY() - resultPoint.getY()) / f5;
        return new ResultPoint(resultPoint.getX() + f4, resultPoint.getY() + f5);
    }

    private ResultPoint[] shiftToModuleCenter(ResultPoint[] object) {
        ResultPoint resultPoint = object[0];
        ResultPoint resultPoint2 = object[1];
        ResultPoint resultPoint3 = object[2];
        object = object[3];
        int n2 = this.transitionsBetween(resultPoint, (ResultPoint)object);
        ResultPoint resultPoint4 = Detector.shiftPoint(resultPoint, resultPoint2, (this.transitionsBetween(resultPoint3, (ResultPoint)object) + 1) * 4);
        ResultPoint resultPoint5 = Detector.shiftPoint(resultPoint3, resultPoint2, (n2 + 1) * 4);
        int n3 = this.transitionsBetween(resultPoint4, (ResultPoint)object) + 1;
        int n4 = this.transitionsBetween(resultPoint5, (ResultPoint)object) + 1;
        n2 = n3;
        if ((n3 & 1) == 1) {
            n2 = n3 + 1;
        }
        n3 = n4;
        if ((n4 & 1) == 1) {
            n3 = n4 + 1;
        }
        float f3 = (resultPoint.getX() + resultPoint2.getX() + resultPoint3.getX() + ((ResultPoint)object).getX()) / 4.0f;
        float f4 = (resultPoint.getY() + resultPoint2.getY() + resultPoint3.getY() + ((ResultPoint)object).getY()) / 4.0f;
        resultPoint = Detector.moveAway(resultPoint, f3, f4);
        resultPoint2 = Detector.moveAway(resultPoint2, f3, f4);
        resultPoint3 = Detector.moveAway(resultPoint3, f3, f4);
        resultPoint4 = Detector.moveAway((ResultPoint)object, f3, f4);
        object = Detector.shiftPoint(resultPoint, resultPoint2, n3 *= 4);
        return new ResultPoint[]{Detector.shiftPoint((ResultPoint)object, resultPoint4, n2 *= 4), Detector.shiftPoint(Detector.shiftPoint(resultPoint2, resultPoint, n3), resultPoint3, n2), Detector.shiftPoint(Detector.shiftPoint(resultPoint3, resultPoint4, n3), resultPoint2, n2), Detector.shiftPoint(Detector.shiftPoint(resultPoint4, resultPoint3, n3), resultPoint, n2)};
    }

    private int transitionsBetween(ResultPoint object, ResultPoint resultPoint) {
        int n2 = (int)((ResultPoint)object).getX();
        int n3 = (int)((ResultPoint)object).getY();
        int n4 = (int)resultPoint.getX();
        int n5 = (int)resultPoint.getY();
        int n6 = Math.abs(n5 - n3);
        int n7 = Math.abs(n4 - n2);
        int n8 = 0;
        int n9 = 1;
        boolean bl = n6 > n7;
        n7 = n2;
        n6 = n3;
        int n10 = n4;
        int n11 = n5;
        if (bl) {
            n6 = n2;
            n7 = n3;
            n11 = n4;
            n10 = n5;
        }
        int n12 = Math.abs(n10 - n7);
        int n13 = Math.abs(n11 - n6);
        n3 = -n12 / 2;
        n2 = n6 < n11 ? 1 : -1;
        if (n7 >= n10) {
            n9 = -1;
        }
        object = this.image;
        n5 = bl ? n6 : n7;
        n4 = bl ? n7 : n6;
        boolean bl2 = ((BitMatrix)object).get(n5, n4);
        n5 = n8;
        while (true) {
            n4 = n5;
            if (n7 == n10) break;
            object = this.image;
            n4 = bl ? n6 : n7;
            n8 = bl ? n7 : n6;
            boolean bl3 = ((BitMatrix)object).get(n4, n8);
            n4 = n5;
            boolean bl4 = bl2;
            if (bl3 != bl2) {
                n4 = n5 + 1;
                bl4 = bl3;
            }
            n8 = n3 + n13;
            n5 = n6;
            n3 = n8;
            if (n8 > 0) {
                if (n6 == n11) break;
                n5 = n6 + n2;
                n3 = n8 - n12;
            }
            n7 += n9;
            n6 = n5;
            n5 = n4;
            bl2 = bl4;
        }
        return n4;
    }

    public DetectorResult detect() throws NotFoundException {
        Object object = this.detectSolid2(this.detectSolid1(this.rectangleDetector.detect()));
        object[3] = this.correctTopRight((ResultPoint[])object);
        if (object[3] != null) {
            Object object2 = this.shiftToModuleCenter((ResultPoint[])object);
            ResultPoint resultPoint = object2[0];
            object = object2[1];
            ResultPoint resultPoint2 = object2[2];
            object2 = object2[3];
            int n2 = this.transitionsBetween(resultPoint, (ResultPoint)object2) + 1;
            int n3 = this.transitionsBetween(resultPoint2, (ResultPoint)object2) + 1;
            int n4 = n2;
            if ((n2 & 1) == 1) {
                n4 = n2 + 1;
            }
            n2 = n3;
            if ((n3 & 1) == 1) {
                n2 = n3 + 1;
            }
            if (n4 * 4 < n2 * 7 && n2 * 4 < n4 * 7) {
                n2 = n4 = Math.max(n4, n2);
            }
            return new DetectorResult(Detector.sampleGrid(this.image, resultPoint, (ResultPoint)object, resultPoint2, (ResultPoint)object2, n4, n2), new ResultPoint[]{resultPoint, object, resultPoint2, object2});
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

