/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.decoder;

import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonDecoder;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonException;
import com.ailiwean.core.zxing.core.datamatrix.decoder.BitMatrixParser;
import com.ailiwean.core.zxing.core.datamatrix.decoder.DataBlock;
import com.ailiwean.core.zxing.core.datamatrix.decoder.DecodedBitStreamParser;
import com.ailiwean.core.zxing.core.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        try {
            this.rsDecoder.decode(nArray, byArray.length - n2);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n3 = n5; n3 < n2; ++n3) {
            byArray[n3] = (byte)nArray[n3];
        }
        return;
    }

    public DecoderResult decode(BitMatrix object) throws FormatException, ChecksumException {
        int n2;
        BitMatrixParser object22 = new BitMatrixParser((BitMatrix)object);
        object = object22.getVersion();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(object22.readCodewords(), (Version)object);
        int n3 = dataBlockArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += dataBlockArray[n2].getNumDataCodewords();
        }
        object = new byte[n4];
        for (DataBlock dataBlock : dataBlockArray) {
            byte[] byArray = dataBlock.getCodewords();
            int n5 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray, n5);
            for (n2 = 0; n2 < n5; ++n2) {
                object[n2 * n3 + n4] = byArray[n2];
            }
        }
        return DecodedBitStreamParser.decode((byte[])object);
    }

    public DecoderResult decode(boolean[][] blArray) throws FormatException, ChecksumException {
        return this.decode(BitMatrix.parse(blArray));
    }
}

