/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.decoder;

import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitSource;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT2_SET_CHARS = C40_SHIFT2_SET_CHARS;
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DecoderResult decode(byte[] byArray) throws FormatException {
        void var5_13;
        void var5_10;
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(0);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        do {
            void var5_7;
            if (var5_7 == Mode.ASCII_ENCODE) {
                Mode mode2 = DecodedBitStreamParser.decodeAsciiSegment(bitSource, stringBuilder, stringBuilder2);
                continue;
            }
            int n2 = 1.$SwitchMap$com$ailiwean$core$zxing$core$datamatrix$decoder$DecodedBitStreamParser$Mode[var5_7.ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) {
                            if (n2 != 5) throw FormatException.getFormatInstance();
                            DecodedBitStreamParser.decodeBase256Segment(bitSource, stringBuilder, arrayList);
                        } else {
                            DecodedBitStreamParser.decodeEdifactSegment(bitSource, stringBuilder);
                        }
                    } else {
                        DecodedBitStreamParser.decodeAnsiX12Segment(bitSource, stringBuilder);
                    }
                } else {
                    DecodedBitStreamParser.decodeTextSegment(bitSource, stringBuilder);
                }
            } else {
                DecodedBitStreamParser.decodeC40Segment(bitSource, stringBuilder);
            }
            Mode mode3 = Mode.ASCII_ENCODE;
        } while (var5_10 != Mode.PAD_ENCODE && bitSource.available() > 0);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        String string2 = stringBuilder.toString();
        ArrayList<byte[]> arrayList2 = arrayList;
        if (!arrayList.isEmpty()) return new DecoderResult(byArray, string2, (List<byte[]>)var5_13, null);
        return new DecoderResult(byArray, string2, (List<byte[]>)var5_13, null);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            for (n2 = 0; n2 < 3; ++n2) {
                int n3 = nArray[n2];
                if (n3 != 0) {
                    if (n3 != 1) {
                        if (n3 != 2) {
                            if (n3 != 3) {
                                if (n3 < 14) {
                                    stringBuilder.append((char)(n3 + 44));
                                    continue;
                                }
                                if (n3 < 40) {
                                    stringBuilder.append((char)(n3 + 51));
                                    continue;
                                }
                                throw FormatException.getFormatInstance();
                            }
                            stringBuilder.append(' ');
                            continue;
                        }
                        stringBuilder.append('>');
                        continue;
                    }
                    stringBuilder.append('*');
                    continue;
                }
                stringBuilder.append('\r');
            }
        } while (bitSource.available() > 0);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws FormatException {
        int n2 = 0;
        do {
            int n3;
            int n4;
            if ((n4 = bitSource.readBits(8)) == 0) throw FormatException.getFormatInstance();
            if (n4 <= 128) {
                n3 = n4;
                if (n2 != 0) {
                    n3 = n4 + 128;
                }
                stringBuilder.append((char)(n3 - 1));
                return Mode.ASCII_ENCODE;
            }
            if (n4 == 129) {
                return Mode.PAD_ENCODE;
            }
            if (n4 <= 229) {
                n3 = n4 - 130;
                if (n3 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n3);
                n3 = n2;
            } else {
                n3 = n2;
                switch (n4) {
                    default: {
                        if (n4 != 254) throw FormatException.getFormatInstance();
                        if (bitSource.available() != 0) throw FormatException.getFormatInstance();
                        n3 = n2;
                        break;
                    }
                    case 240: {
                        return Mode.EDIFACT_ENCODE;
                    }
                    case 239: {
                        return Mode.TEXT_ENCODE;
                    }
                    case 238: {
                        return Mode.ANSIX12_ENCODE;
                    }
                    case 237: {
                        stringBuilder.append("[)>\u001e06\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                        n3 = n2;
                        break;
                    }
                    case 236: {
                        stringBuilder.append("[)>\u001e05\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                        n3 = n2;
                        break;
                    }
                    case 235: {
                        n3 = 1;
                        break;
                    }
                    case 232: {
                        stringBuilder.append('\u001d');
                        n3 = n2;
                        break;
                    }
                    case 231: {
                        return Mode.BASE256_ENCODE;
                    }
                    case 230: {
                        return Mode.C40_ENCODE;
                    }
                    case 233: 
                    case 234: 
                    case 241: 
                }
            }
            n2 = n3;
        } while (bitSource.available() > 0);
        return Mode.ASCII_ENCODE;
    }

    private static void decodeBase256Segment(BitSource object, StringBuilder stringBuilder, Collection<byte[]> collection) throws FormatException {
        int n2 = ((BitSource)object).getByteOffset() + 1;
        int n3 = ((BitSource)object).readBits(8);
        int n4 = n2 + 1;
        if ((n2 = DecodedBitStreamParser.unrandomize255State(n3, n2)) == 0) {
            n2 = ((BitSource)object).available() / 8;
        } else if (n2 >= 250) {
            n2 = (n2 - 249) * 250 + DecodedBitStreamParser.unrandomize255State(((BitSource)object).readBits(8), n4);
            ++n4;
        }
        if (n2 >= 0) {
            byte[] byArray = new byte[n2];
            n3 = 0;
            while (n3 < n2) {
                if (((BitSource)object).available() >= 8) {
                    byArray[n3] = (byte)DecodedBitStreamParser.unrandomize255State(((BitSource)object).readBits(8), n4);
                    ++n3;
                    ++n4;
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            collection.add(byArray);
            try {
                object = new String(byArray, "ISO8859_1");
                stringBuilder.append((String)object);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Platform does not support required encoding: ");
                ((StringBuilder)object).append(unsupportedEncodingException);
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
        }
        throw FormatException.getFormatInstance();
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeC40Segment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = new int[3];
        var3_3 = false;
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_5 = var0.readBits(8);
            if (var5_5 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_5, var0.readBits(8), var2_2);
            for (var5_5 = 0; var5_5 < 3; ++var5_5) {
                block11: {
                    block16: {
                        block12: {
                            block17: {
                                block18: {
                                    block13: {
                                        block14: {
                                            block15: {
                                                var6_6 = var2_2[var5_5];
                                                if (var4_4 == 0) break block11;
                                                if (var4_4 == true) break block12;
                                                if (var4_4 == 2) break block13;
                                                if (var4_4 != 3) break block14;
                                                if (!var3_3) break block15;
                                                var1_1.append((char)(var6_6 + 224));
                                                ** GOTO lbl52
                                            }
                                            var1_1.append((char)(var6_6 + 96));
                                            break block16;
                                        }
                                        throw FormatException.getFormatInstance();
                                    }
                                    var7_7 = DecodedBitStreamParser.C40_SHIFT2_SET_CHARS;
                                    if (var6_6 >= var7_7.length) break block17;
                                    var8_8 = var7_7[var6_6];
                                    if (!var3_3) break block18;
                                    var1_1.append((char)(var8_8 + 128));
                                    ** GOTO lbl52
                                }
                                var1_1.append(var8_8);
                                break block16;
                            }
                            if (var6_6 == 27) ** GOTO lbl45
                            if (var6_6 == 30) {
                                var3_3 = true;
                            } else {
                                throw FormatException.getFormatInstance();
lbl45:
                                // 1 sources

                                var1_1.append('\u001d');
                            }
                            break block16;
                        }
                        if (var3_3) {
                            var1_1.append((char)(var6_6 + 128));
lbl52:
                            // 3 sources

                            var3_3 = false;
                        } else {
                            var1_1.append((char)var6_6);
                        }
                    }
                    var4_4 = 0;
                    continue;
                }
                if (var6_6 < 3) {
                    var4_4 = var6_6 + 1;
                    continue;
                }
                var7_7 = DecodedBitStreamParser.C40_BASIC_SET_CHARS;
                if (var6_6 < var7_7.length) {
                    var8_8 = var7_7[var6_6];
                    if (var3_3) {
                        var1_1.append((char)(var8_8 + 128));
                        var3_3 = false;
                        continue;
                    }
                    var1_1.append(var8_8);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i3 = 0; i3 < 4; ++i3) {
                int n2 = bitSource.readBits(6);
                if (n2 == 31) {
                    i3 = 8 - bitSource.getBitOffset();
                    if (i3 != 8) {
                        bitSource.readBits(i3);
                    }
                    return;
                }
                int n3 = n2;
                if ((n2 & 0x20) == 0) {
                    n3 = n2 | 0x40;
                }
                stringBuilder.append((char)n3);
            }
        } while (bitSource.available() > 0);
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeTextSegment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = new int[3];
        var3_3 = false;
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_5 = var0.readBits(8);
            if (var5_5 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_5, var0.readBits(8), var2_2);
            for (var5_5 = 0; var5_5 < 3; ++var5_5) {
                block11: {
                    block17: {
                        block12: {
                            block18: {
                                block19: {
                                    block13: {
                                        block14: {
                                            block15: {
                                                block16: {
                                                    var6_6 = var2_2[var5_5];
                                                    if (var4_4 == 0) break block11;
                                                    if (var4_4 == true) break block12;
                                                    if (var4_4 == 2) break block13;
                                                    if (var4_4 != 3) break block14;
                                                    var7_7 = DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS;
                                                    if (var6_6 >= var7_7.length) break block15;
                                                    var8_8 = var7_7[var6_6];
                                                    if (!var3_3) break block16;
                                                    var1_1.append((char)(var8_8 + 128));
                                                    ** GOTO lbl57
                                                }
                                                var1_1.append(var8_8);
                                                break block17;
                                            }
                                            throw FormatException.getFormatInstance();
                                        }
                                        throw FormatException.getFormatInstance();
                                    }
                                    var7_7 = DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS;
                                    if (var6_6 >= var7_7.length) break block18;
                                    var8_8 = var7_7[var6_6];
                                    if (!var3_3) break block19;
                                    var1_1.append((char)(var8_8 + 128));
                                    ** GOTO lbl57
                                }
                                var1_1.append(var8_8);
                                break block17;
                            }
                            if (var6_6 == 27) ** GOTO lbl50
                            if (var6_6 == 30) {
                                var3_3 = true;
                            } else {
                                throw FormatException.getFormatInstance();
lbl50:
                                // 1 sources

                                var1_1.append('\u001d');
                            }
                            break block17;
                        }
                        if (var3_3) {
                            var1_1.append((char)(var6_6 + 128));
lbl57:
                            // 3 sources

                            var3_3 = false;
                        } else {
                            var1_1.append((char)var6_6);
                        }
                    }
                    var4_4 = 0;
                    continue;
                }
                if (var6_6 < 3) {
                    var4_4 = var6_6 + 1;
                    continue;
                }
                var7_7 = DecodedBitStreamParser.TEXT_BASIC_SET_CHARS;
                if (var6_6 < var7_7.length) {
                    var8_8 = var7_7[var6_6];
                    if (var3_3) {
                        var1_1.append((char)(var8_8 + 128));
                        var3_3 = false;
                        continue;
                    }
                    var1_1.append(var8_8);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    private static void parseTwoBytes(int n2, int n3, int[] nArray) {
        n2 = (n2 << 8) + n3 - 1;
        nArray[0] = n3 = n2 / 1600;
        n3 = n2 - n3 * 1600;
        nArray[1] = n2 = n3 / 40;
        nArray[2] = n3 - n2 * 40;
    }

    private static int unrandomize255State(int n2, int n3) {
        if ((n2 -= n3 * 149 % 255 + 1) < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE;

    }
}

