/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.decoder;

import com.ailiwean.core.zxing.core.datamatrix.decoder.Version;

final class DataBlock {
    private final byte[] codewords;
    private final int numDataCodewords;

    private DataBlock(int n2, byte[] byArray) {
        this.numDataCodewords = n2;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version) {
        int n2;
        int n3;
        Version.ECBlocks eCBlocks = version.getECBlocks();
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        int n4 = eCBArray.length;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n5 += eCBArray[n3].getCount();
        }
        DataBlock[] dataBlockArray = new DataBlock[n5];
        int n6 = eCBArray.length;
        n3 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            Version.ECB eCB = eCBArray[n5];
            n4 = 0;
            while (n4 < eCB.getCount()) {
                n2 = eCB.getDataCodewords();
                dataBlockArray[n3] = new DataBlock(n2, new byte[eCBlocks.getECCodewords() + n2]);
                ++n4;
                ++n3;
            }
        }
        int n7 = dataBlockArray[0].codewords.length - eCBlocks.getECCodewords();
        int n8 = n7 - 1;
        n5 = 0;
        for (n4 = 0; n4 < n8; ++n4) {
            n6 = 0;
            while (n6 < n3) {
                dataBlockArray[n6].codewords[n4] = byArray[n5];
                ++n6;
                ++n5;
            }
        }
        n6 = version.getVersionNumber() == 24 ? 1 : 0;
        n4 = n6 != 0 ? 8 : n3;
        n2 = 0;
        while (n2 < n4) {
            dataBlockArray[n2].codewords[n8] = byArray[n5];
            ++n2;
            ++n5;
        }
        int n9 = dataBlockArray[0].codewords.length;
        n2 = n5;
        for (n5 = n7; n5 < n9; ++n5) {
            n4 = 0;
            while (n4 < n3) {
                n7 = n6 != 0 ? (n4 + 8) % n3 : n4;
                n8 = n6 != 0 && n7 > 7 ? n5 - 1 : n5;
                dataBlockArray[n7].codewords[n8] = byArray[n2];
                ++n4;
                ++n2;
            }
        }
        if (n2 == byArray.length) {
            return dataBlockArray;
        }
        throw new IllegalArgumentException();
    }

    byte[] getCodewords() {
        return this.codewords;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }
}

