/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix.decoder;

import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.datamatrix.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix mappingBitMatrix;
    private final BitMatrix readMappingMatrix;
    private final Version version;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 >= 8 && n2 <= 144 && (n2 & 1) == 0) {
            this.version = BitMatrixParser.readVersion(bitMatrix);
            this.mappingBitMatrix = this.extractDataRegion(bitMatrix);
            this.readMappingMatrix = new BitMatrix(this.mappingBitMatrix.getWidth(), this.mappingBitMatrix.getHeight());
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private BitMatrix extractDataRegion(BitMatrix bitMatrix) {
        int n2 = this.version.getSymbolSizeRows();
        int n3 = this.version.getSymbolSizeColumns();
        if (bitMatrix.getHeight() == n2) {
            int n4 = this.version.getDataRegionSizeRows();
            int n5 = this.version.getDataRegionSizeColumns();
            int n6 = n2 / n4;
            int n7 = n3 / n5;
            BitMatrix bitMatrix2 = new BitMatrix(n7 * n5, n6 * n4);
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        for (int i4 = 0; i4 < n5; ++i4) {
                            if (!bitMatrix.get((n5 + 2) * n2 + 1 + i4, (n4 + 2) * n3 + 1 + i3)) continue;
                            bitMatrix2.set(n2 * n5 + i4, n3 * n4 + i3);
                        }
                    }
                }
            }
            return bitMatrix2;
        }
        throw new IllegalArgumentException("Dimension of bitMatrix must match the version size");
    }

    private int readCorner1(int n2, int n3) {
        int n4;
        int n5 = n2 - 1;
        int n6 = this.readModule(n5, 0, n2, n3) ? 1 : 0;
        n6 = n4 = n6 << 1;
        if (this.readModule(n5, 1, n2, n3)) {
            n6 = n4 | 1;
        }
        n6 = n4 = n6 << 1;
        if (this.readModule(n5, 2, n2, n3)) {
            n6 = n4 | 1;
        }
        n6 = n4 = n6 << 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n6 = n4 | 1;
        }
        n4 = n6 << 1;
        n5 = n3 - 1;
        n6 = n4;
        if (this.readModule(0, n5, n2, n3)) {
            n6 = n4 | 1;
        }
        n6 = n4 = n6 << 1;
        if (this.readModule(1, n5, n2, n3)) {
            n6 = n4 | 1;
        }
        n6 = n4 = n6 << 1;
        if (this.readModule(2, n5, n2, n3)) {
            n6 = n4 | 1;
        }
        n6 = n4 = n6 << 1;
        if (this.readModule(3, n5, n2, n3)) {
            n6 = n4 | 1;
        }
        return n6;
    }

    private int readCorner2(int n2, int n3) {
        int n4;
        int n5 = this.readModule(n2 - 3, 0, n2, n3) ? 1 : 0;
        n5 = n4 = n5 << 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(0, n3 - 4, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(0, n3 - 3, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n5 = n4 | 1;
        }
        n4 = n5 << 1;
        int n6 = n3 - 1;
        n5 = n4;
        if (this.readModule(0, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(1, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        return n5;
    }

    private int readCorner3(int n2, int n3) {
        int n4 = n2 - 1;
        int n5 = this.readModule(n4, 0, n2, n3) ? 1 : 0;
        int n6 = n5 << 1;
        int n7 = n3 - 1;
        n5 = n6;
        if (this.readModule(n4, n7, n2, n3)) {
            n5 = n6 | 1;
        }
        n6 = n5 << 1;
        int n8 = n3 - 3;
        n5 = n6;
        if (this.readModule(0, n8, n2, n3)) {
            n5 = n6 | 1;
        }
        n6 = n5 << 1;
        n4 = n3 - 2;
        n5 = n6;
        if (this.readModule(0, n4, n2, n3)) {
            n5 = n6 | 1;
        }
        n5 = n6 = n5 << 1;
        if (this.readModule(0, n7, n2, n3)) {
            n5 = n6 | 1;
        }
        n5 = n6 = n5 << 1;
        if (this.readModule(1, n8, n2, n3)) {
            n5 = n6 | 1;
        }
        n5 = n6 = n5 << 1;
        if (this.readModule(1, n4, n2, n3)) {
            n5 = n6 | 1;
        }
        n5 = n6 = n5 << 1;
        if (this.readModule(1, n7, n2, n3)) {
            n5 = n6 | 1;
        }
        return n5;
    }

    private int readCorner4(int n2, int n3) {
        int n4;
        int n5 = this.readModule(n2 - 3, 0, n2, n3) ? 1 : 0;
        n5 = n4 = n5 << 1;
        if (this.readModule(n2 - 2, 0, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(n2 - 1, 0, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(0, n3 - 2, n2, n3)) {
            n5 = n4 | 1;
        }
        n4 = n5 << 1;
        int n6 = n3 - 1;
        n5 = n4;
        if (this.readModule(0, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(1, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(2, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        n5 = n4 = n5 << 1;
        if (this.readModule(3, n6, n2, n3)) {
            n5 = n4 | 1;
        }
        return n5;
    }

    private boolean readModule(int n2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n3;
        if (n2 < 0) {
            n6 = n2 + n4;
            n7 = n3 + (4 - (n4 + 4 & 7));
        }
        n3 = n6;
        n2 = n7;
        if (n7 < 0) {
            n2 = n7 + n5;
            n3 = n6 + (4 - (n5 + 4 & 7));
        }
        this.readMappingMatrix.set(n2, n3);
        return this.mappingBitMatrix.get(n2, n3);
    }

    private int readUtah(int n2, int n3, int n4, int n5) {
        int n6 = n2 - 2;
        int n7 = n3 - 2;
        int n8 = this.readModule(n6, n7, n4, n5) ? 1 : 0;
        int n9 = n8 << 1;
        int n10 = n3 - 1;
        n8 = n9;
        if (this.readModule(n6, n10, n4, n5)) {
            n8 = n9 | 1;
        }
        n9 = n8 << 1;
        n6 = n2 - 1;
        n8 = n9;
        if (this.readModule(n6, n7, n4, n5)) {
            n8 = n9 | 1;
        }
        n8 = n9 = n8 << 1;
        if (this.readModule(n6, n10, n4, n5)) {
            n8 = n9 | 1;
        }
        n8 = n9 = n8 << 1;
        if (this.readModule(n6, n3, n4, n5)) {
            n8 = n9 | 1;
        }
        n8 = n9 = n8 << 1;
        if (this.readModule(n2, n7, n4, n5)) {
            n8 = n9 | 1;
        }
        n8 = n9 = n8 << 1;
        if (this.readModule(n2, n10, n4, n5)) {
            n8 = n9 | 1;
        }
        n8 = n9 = n8 << 1;
        if (this.readModule(n2, n3, n4, n5)) {
            n8 = n9 | 1;
        }
        return n8;
    }

    private static Version readVersion(BitMatrix bitMatrix) throws FormatException {
        return Version.getVersionForDimensions(bitMatrix.getHeight(), bitMatrix.getWidth());
    }

    Version getVersion() {
        return this.version;
    }

    /*
     * Unable to fully structure code
     */
    byte[] readCodewords() throws FormatException {
        var1_1 = new byte[this.version.getTotalCodewords()];
        var2_2 = this.mappingBitMatrix.getHeight();
        var3_3 = this.mappingBitMatrix.getWidth();
        var4_4 = 4;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        while (true) {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (var4_4 != var2_2 || var5_5 != 0 || var6_6 != 0) break block12;
                            var1_1[var7_7] = (byte)this.readCorner1(var2_2, var3_3);
                            var11_11 = var4_4 - 2;
                            var12_12 = var5_5 + 2;
                            var13_13 = var7_7 + 1;
                            var14_14 = 1;
                            var15_15 = var8_8;
                            var16_16 = var9_9;
                            var17_17 = var10_10;
                            break block13;
                        }
                        var11_11 = var2_2 - 2;
                        if (var4_4 != var11_11 || var5_5 != 0 || (var3_3 & 3) == 0 || var8_8) break block14;
                        var1_1[var7_7] = (byte)this.readCorner2(var2_2, var3_3);
                        var11_11 = var4_4 - 2;
                        var12_12 = var5_5 + 2;
                        var13_13 = var7_7 + 1;
                        var15_15 = true;
                        var14_14 = var6_6;
                        var16_16 = var9_9;
                        var17_17 = var10_10;
                        break block13;
                    }
                    if (var4_4 != var2_2 + 4 || var5_5 != 2 || (var3_3 & 7) != 0 || var9_9) break block15;
                    var1_1[var7_7] = (byte)this.readCorner3(var2_2, var3_3);
                    var11_11 = var4_4 - 2;
                    var12_12 = var5_5 + 2;
                    var13_13 = var7_7 + 1;
                    var16_16 = true;
                    var14_14 = var6_6;
                    var15_15 = var8_8;
                    var17_17 = var10_10;
                    break block13;
                }
                var12_12 = var4_4;
                var13_13 = var5_5;
                var14_14 = var7_7;
                if (var4_4 != var11_11) ** GOTO lbl-1000
                var12_12 = var4_4;
                var13_13 = var5_5;
                var14_14 = var7_7;
                if (var5_5 != 0) ** GOTO lbl-1000
                var12_12 = var4_4;
                var13_13 = var5_5;
                var14_14 = var7_7;
                if ((var3_3 & 7) != 4) ** GOTO lbl-1000
                var12_12 = var4_4;
                var13_13 = var5_5;
                var14_14 = var7_7;
                if (!var10_10) {
                    var1_1[var7_7] = (byte)this.readCorner4(var2_2, var3_3);
                    var11_11 = var4_4 - 2;
                    var12_12 = var5_5 + 2;
                    var13_13 = var7_7 + 1;
                    var17_17 = true;
                    var14_14 = var6_6;
                    var15_15 = var8_8;
                    var16_16 = var9_9;
                } else lbl-1000:
                // 4 sources

                {
                    do {
                        var11_11 = var14_14;
                        if (var12_12 < var2_2) {
                            var11_11 = var14_14;
                            if (var13_13 >= 0) {
                                var11_11 = var14_14;
                                if (!this.readMappingMatrix.get(var13_13, var12_12)) {
                                    var1_1[var14_14] = (byte)this.readUtah(var12_12, var13_13, var2_2, var3_3);
                                    var11_11 = var14_14 + 1;
                                }
                            }
                        }
                        var5_5 = var12_12 - 2;
                        var7_7 = var13_13 + 2;
                        if (var5_5 < 0) break;
                        var12_12 = var5_5;
                        var13_13 = var7_7;
                        var14_14 = var11_11;
                    } while (var7_7 < var3_3);
                    var13_13 = var5_5 + 1;
                    var12_12 = var7_7 + 3;
                    var7_7 = var13_13;
                    do {
                        var13_13 = var11_11;
                        if (var7_7 >= 0) {
                            var13_13 = var11_11;
                            if (var12_12 < var3_3) {
                                var13_13 = var11_11;
                                if (!this.readMappingMatrix.get(var12_12, var7_7)) {
                                    var1_1[var11_11] = (byte)this.readUtah(var7_7, var12_12, var2_2, var3_3);
                                    var13_13 = var11_11 + 1;
                                }
                            }
                        }
                        var4_4 = var7_7 + 2;
                        var5_5 = var12_12 - 2;
                        if (var4_4 >= var2_2) break;
                        var7_7 = var4_4;
                        var12_12 = var5_5;
                        var11_11 = var13_13;
                    } while (var5_5 >= 0);
                    var11_11 = var4_4 + 3;
                    var12_12 = var5_5 + 1;
                    var17_17 = var10_10;
                    var16_16 = var9_9;
                    var15_15 = var8_8;
                    var14_14 = var6_6;
                }
            }
            var4_4 = var11_11;
            var5_5 = var12_12;
            var6_6 = var14_14;
            var7_7 = var13_13;
            var8_8 = var15_15;
            var9_9 = var16_16;
            var10_10 = var17_17;
            if (var11_11 < var2_2) continue;
            var4_4 = var11_11;
            var5_5 = var12_12;
            var6_6 = var14_14;
            var7_7 = var13_13;
            var8_8 = var15_15;
            var9_9 = var16_16;
            var10_10 = var17_17;
            if (var12_12 >= var3_3) break;
        }
        if (var13_13 == this.version.getTotalCodewords()) {
            return var1_1;
        }
        throw FormatException.getFormatInstance();
    }
}

