/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.Dimension;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.Writer;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.datamatrix.encoder.DefaultPlacement;
import com.ailiwean.core.zxing.core.datamatrix.encoder.ErrorCorrection;
import com.ailiwean.core.zxing.core.datamatrix.encoder.HighLevelEncoder;
import com.ailiwean.core.zxing.core.datamatrix.encoder.SymbolInfo;
import com.ailiwean.core.zxing.core.datamatrix.encoder.SymbolShapeHint;
import com.ailiwean.core.zxing.core.qrcode.encoder.ByteMatrix;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix, int n2, int n3) {
        BitMatrix bitMatrix;
        int n4 = byteMatrix.getWidth();
        int n5 = byteMatrix.getHeight();
        int n6 = Math.max(n2, n4);
        int n7 = Math.max(n3, n5);
        int n8 = Math.min(n6 / n4, n7 / n5);
        n6 = (n6 - n4 * n8) / 2;
        n7 = (n7 - n5 * n8) / 2;
        if (n3 >= n5 && n2 >= n4) {
            bitMatrix = new BitMatrix(n2, n3);
            n2 = n6;
            n3 = n7;
        } else {
            bitMatrix = new BitMatrix(n4, n5);
            n2 = 0;
            n3 = 0;
        }
        bitMatrix.clear();
        n6 = 0;
        while (n6 < n5) {
            int n9 = n2;
            n7 = 0;
            while (n7 < n4) {
                if (byteMatrix.get(n7, n6) == 1) {
                    bitMatrix.setRegion(n9, n3, n8, n8);
                }
                ++n7;
                n9 += n8;
            }
            ++n6;
            n3 += n8;
        }
        return bitMatrix;
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo, int n2, int n3) {
        int n4 = symbolInfo.getSymbolDataWidth();
        int n5 = symbolInfo.getSymbolDataHeight();
        ByteMatrix byteMatrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int n6 = 0;
        for (int i3 = 0; i3 < n5; ++i3) {
            boolean bl;
            int n7;
            int n8 = n6;
            if (i3 % symbolInfo.matrixHeight == 0) {
                n8 = 0;
                for (n7 = 0; n7 < symbolInfo.getSymbolWidth(); ++n7) {
                    bl = n7 % 2 == 0;
                    byteMatrix.set(n8, n6, bl);
                    ++n8;
                }
                n8 = n6 + 1;
            }
            n6 = 0;
            for (n7 = 0; n7 < n4; ++n7) {
                int n9 = n6;
                if (n7 % symbolInfo.matrixWidth == 0) {
                    byteMatrix.set(n6, n8, true);
                    n9 = n6 + 1;
                }
                byteMatrix.set(n9, n8, defaultPlacement.getBit(n7, i3));
                n6 = ++n9;
                if (n7 % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                bl = i3 % 2 == 0;
                byteMatrix.set(n9, n8, bl);
                n6 = n9 + 1;
            }
            n6 = n7 = n8 + 1;
            if (i3 % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            n8 = 0;
            for (n6 = 0; n6 < symbolInfo.getSymbolWidth(); ++n6) {
                byteMatrix.set(n8, n7, true);
                ++n8;
            }
            n6 = n7 + 1;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix, n2, n3);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String object, BarcodeFormat object2, int n2, int n3, Map<EncodeHintType, ?> object3) {
        if (!((String)object).isEmpty()) {
            if (object2 == BarcodeFormat.DATA_MATRIX) {
                if (n2 >= 0 && n3 >= 0) {
                    Object object4;
                    object2 = SymbolShapeHint.FORCE_NONE;
                    Dimension dimension = null;
                    if (object3 != null) {
                        Object object5 = (SymbolShapeHint)((Object)object3.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
                        if (object5 != null) {
                            object2 = object5;
                        }
                        if ((object5 = (Dimension)object3.get((Object)EncodeHintType.MIN_SIZE)) == null) {
                            object5 = null;
                        }
                        Dimension dimension2 = (Dimension)object3.get((Object)EncodeHintType.MAX_SIZE);
                        object4 = object5;
                        object3 = object2;
                        if (dimension2 != null) {
                            dimension = dimension2;
                            object4 = object5;
                            object3 = object2;
                        }
                    } else {
                        object4 = null;
                        object3 = object2;
                    }
                    object = HighLevelEncoder.encodeHighLevel((String)object, (SymbolShapeHint)((Object)object3), object4, dimension);
                    object2 = SymbolInfo.lookup(((String)object).length(), (SymbolShapeHint)((Object)object3), object4, dimension, true);
                    object = new DefaultPlacement(ErrorCorrection.encodeECC200((String)object, (SymbolInfo)object2), ((SymbolInfo)object2).getSymbolDataWidth(), ((SymbolInfo)object2).getSymbolDataHeight());
                    ((DefaultPlacement)object).place();
                    return DataMatrixWriter.encodeLowLevel((DefaultPlacement)object, (SymbolInfo)object2, n2, n3);
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Requested dimensions can't be negative: ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append('x');
                ((StringBuilder)object).append(n3);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Can only encode DATA_MATRIX, but got ");
            ((StringBuilder)object).append(object2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

