/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.datamatrix;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.datamatrix.decoder.Decoder;
import com.ailiwean.core.zxing.core.datamatrix.detector.Detector;
import java.util.List;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        Object object = bitMatrix.getBottomRightOnBit();
        if (nArray != null && object != null) {
            int n2 = DataMatrixReader.moduleSize(nArray, bitMatrix);
            int n3 = nArray[1];
            int n4 = object[1];
            int n5 = nArray[0];
            int n6 = (object[0] - n5 + 1) / n2;
            int n7 = (n4 - n3 + 1) / n2;
            if (n6 > 0 && n7 > 0) {
                int n8 = n2 / 2;
                object = new BitMatrix(n6, n7);
                for (n4 = 0; n4 < n7; ++n4) {
                    for (int i3 = 0; i3 < n6; ++i3) {
                        if (!bitMatrix.get(i3 * n2 + (n5 + n8), n4 * n2 + (n3 + n8))) continue;
                        ((BitMatrix)object).set(i3, n4);
                    }
                }
                return object;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int n3 = bitMatrix.getWidth();
        int n4 = nArray[1];
        for (n2 = nArray[0]; n2 < n3 && bitMatrix.get(n2, n4); ++n2) {
        }
        if (n2 != n3) {
            if ((n2 -= nArray[0]) != 0) {
                return n2;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = DataMatrixReader.extractPureBits(((BinaryBitmap)object).getBlackMatrix());
            object = this.decoder.decode((BitMatrix)object);
            object2 = NO_POINTS;
        } else {
            object2 = new Detector(((BinaryBitmap)object).getBlackMatrix()).detect();
            object = this.decoder.decode(((DetectorResult)object2).getBits());
            object2 = ((DetectorResult)object2).getPoints();
        }
        object2 = new Result(((DecoderResult)object).getText(), ((DecoderResult)object).getRawBytes(), (ResultPoint[])object2, BarcodeFormat.DATA_MATRIX);
        List<byte[]> list = ((DecoderResult)object).getByteSegments();
        if (list != null) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((object = ((DecoderResult)object).getECLevel()) != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object);
        }
        return object2;
    }

    @Override
    public void reset() {
    }
}

