/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common.reedsolomon;

import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGFPoly;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF genericGF) {
        this.field = genericGF;
    }

    private int[] findErrorLocations(GenericGFPoly genericGFPoly) throws ReedSolomonException {
        int n2 = genericGFPoly.getDegree();
        int n3 = 0;
        if (n2 == 1) {
            return new int[]{genericGFPoly.getCoefficient(1)};
        }
        int[] nArray = new int[n2];
        for (int i3 = 1; i3 < this.field.getSize() && n3 < n2; ++i3) {
            int n4 = n3;
            if (genericGFPoly.evaluateAt(i3) == 0) {
                nArray[n3] = this.field.inverse(i3);
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        if (n3 == n2) {
            return nArray;
        }
        throw new ReedSolomonException("Error locator degree does not match number of roots");
    }

    private int[] findErrorMagnitudes(GenericGFPoly genericGFPoly, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3 = this.field.inverse(nArray[i3]);
            int n4 = 1;
            for (int i4 = 0; i4 < n2; ++i4) {
                int n5 = n4;
                if (i3 != i4) {
                    n5 = this.field.multiply(nArray[i4], n3);
                    n5 = (n5 & 1) == 0 ? (n5 |= 1) : (n5 &= 0xFFFFFFFE);
                    n5 = this.field.multiply(n4, n5);
                }
                n4 = n5;
            }
            nArray2[i3] = this.field.multiply(genericGFPoly.evaluateAt(n3), this.field.inverse(n4));
            if (this.field.getGeneratorBase() == 0) continue;
            nArray2[i3] = this.field.multiply(nArray2[i3], n3);
        }
        return nArray2;
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly genericGFPoly, GenericGFPoly genericGFPoly2, int n2) throws ReedSolomonException {
        GenericGFPoly genericGFPoly3;
        block4: {
            block5: {
                GenericGFPoly genericGFPoly4 = genericGFPoly;
                genericGFPoly3 = genericGFPoly2;
                if (genericGFPoly.getDegree() < genericGFPoly2.getDegree()) {
                    genericGFPoly3 = genericGFPoly;
                    genericGFPoly4 = genericGFPoly2;
                }
                GenericGFPoly genericGFPoly5 = this.field.getZero();
                genericGFPoly2 = this.field.getOne();
                genericGFPoly = genericGFPoly3;
                genericGFPoly3 = genericGFPoly4;
                genericGFPoly4 = genericGFPoly5;
                while (true) {
                    genericGFPoly5 = genericGFPoly4;
                    genericGFPoly4 = genericGFPoly3;
                    genericGFPoly3 = genericGFPoly;
                    if (genericGFPoly3.getDegree() < n2 / 2) break block4;
                    if (genericGFPoly3.isZero()) break block5;
                    GenericGFPoly genericGFPoly6 = this.field.getZero();
                    int n3 = genericGFPoly3.getCoefficient(genericGFPoly3.getDegree());
                    n3 = this.field.inverse(n3);
                    genericGFPoly = genericGFPoly4;
                    genericGFPoly4 = genericGFPoly6;
                    while (genericGFPoly.getDegree() >= genericGFPoly3.getDegree() && !genericGFPoly.isZero()) {
                        int n4 = genericGFPoly.getDegree() - genericGFPoly3.getDegree();
                        int n5 = this.field.multiply(genericGFPoly.getCoefficient(genericGFPoly.getDegree()), n3);
                        genericGFPoly4 = genericGFPoly4.addOrSubtract(this.field.buildMonomial(n4, n5));
                        genericGFPoly = genericGFPoly.addOrSubtract(genericGFPoly3.multiplyByMonomial(n4, n5));
                    }
                    genericGFPoly5 = genericGFPoly4.multiply(genericGFPoly2).addOrSubtract(genericGFPoly5);
                    if (genericGFPoly.getDegree() >= genericGFPoly3.getDegree()) break;
                    genericGFPoly4 = genericGFPoly2;
                    genericGFPoly2 = genericGFPoly5;
                }
                throw new IllegalStateException("Division algorithm failed to reduce polynomial?");
            }
            throw new ReedSolomonException("r_{i-1} was zero");
        }
        n2 = genericGFPoly2.getCoefficient(0);
        if (n2 != 0) {
            n2 = this.field.inverse(n2);
            return new GenericGFPoly[]{genericGFPoly2.multiply(n2), genericGFPoly3.multiply(n2)};
        }
        throw new ReedSolomonException("sigmaTilde(0) was zero");
    }

    public void decode(int[] nArray, int n2) throws ReedSolomonException {
        Object object;
        int n3;
        GenericGFPoly genericGFPoly = new GenericGFPoly(this.field, nArray);
        Object object2 = new int[n2];
        int n4 = 0;
        boolean bl = true;
        for (n3 = 0; n3 < n2; ++n3) {
            int n5;
            object = this.field;
            object2[((int[])object2).length - 1 - n3] = n5 = genericGFPoly.evaluateAt(object.exp(object.getGeneratorBase() + n3));
            if (n5 == 0) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        object2 = new GenericGFPoly(this.field, (int[])object2);
        object2 = this.runEuclideanAlgorithm(this.field.buildMonomial(n2, 1), (GenericGFPoly)object2, n2);
        object = object2[0];
        object2 = object2[1];
        object = this.findErrorLocations((GenericGFPoly)object);
        object2 = this.findErrorMagnitudes((GenericGFPoly)object2, (int[])object);
        for (n2 = n4; n2 < ((GenericGF)object).length; ++n2) {
            n3 = nArray.length - 1 - this.field.log((int)object[n2]);
            if (n3 >= 0) {
                nArray[n3] = GenericGF.addOrSubtract(nArray[n3], object2[n2]);
                continue;
            }
            throw new ReedSolomonException("Bad error location");
        }
    }
}

