/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common.reedsolomon;

import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final int[] coefficients;
    private final GenericGF field;

    GenericGFPoly(GenericGF object, int[] nArray) {
        if (nArray.length != 0) {
            this.field = object;
            int n2 = nArray.length;
            if (n2 > 1 && nArray[0] == 0) {
                int n3;
                for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
                }
                if (n3 == n2) {
                    this.coefficients = new int[]{0};
                } else {
                    this.coefficients = new int[n2 - n3];
                    object = this.coefficients;
                    System.arraycopy(nArray, n3, object, 0, ((Object)object).length);
                }
            } else {
                this.coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    GenericGFPoly addOrSubtract(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((GenericGFPoly)object).isZero()) {
                return this;
            }
            int[] nArray = this.coefficients;
            int[] nArray2 = ((GenericGFPoly)object).coefficients;
            int[] nArray3 = nArray;
            object = nArray2;
            if (nArray.length > nArray2.length) {
                nArray3 = nArray2;
                object = nArray;
            }
            nArray = new int[((Object)object).length];
            int n2 = ((Object)object).length - nArray3.length;
            System.arraycopy(object, 0, nArray, 0, n2);
            for (int i3 = n2; i3 < ((Object)object).length; ++i3) {
                nArray[i3] = GenericGF.addOrSubtract(nArray3[i3 - n2], (int)object[i3]);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly[] divide(GenericGFPoly genericGFPoly) {
        if (this.field.equals(genericGFPoly.field)) {
            if (!genericGFPoly.isZero()) {
                GenericGFPoly genericGFPoly2 = this.field.getZero();
                int n2 = genericGFPoly.getCoefficient(genericGFPoly.getDegree());
                int n3 = this.field.inverse(n2);
                GenericGFPoly genericGFPoly3 = this;
                while (genericGFPoly3.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly3.isZero()) {
                    n2 = genericGFPoly3.getDegree() - genericGFPoly.getDegree();
                    int n4 = this.field.multiply(genericGFPoly3.getCoefficient(genericGFPoly3.getDegree()), n3);
                    GenericGFPoly genericGFPoly4 = genericGFPoly.multiplyByMonomial(n2, n4);
                    genericGFPoly2 = genericGFPoly2.addOrSubtract(this.field.buildMonomial(n2, n4));
                    genericGFPoly3 = genericGFPoly3.addOrSubtract(genericGFPoly4);
                }
                return new GenericGFPoly[]{genericGFPoly2, genericGFPoly3};
            }
            throw new IllegalArgumentException("Divide by 0");
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    int evaluateAt(int n2) {
        int n3;
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        int n4 = 1;
        if (n2 == 1) {
            int[] nArray = this.coefficients;
            int n5 = nArray.length;
            n2 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = GenericGF.addOrSubtract(n2, nArray[n3]);
            }
            return n2;
        }
        int[] nArray = this.coefficients;
        int n6 = nArray[0];
        int n7 = nArray.length;
        for (n3 = n4; n3 < n7; ++n3) {
            n6 = GenericGF.addOrSubtract(this.field.multiply(n2, n6), this.coefficients[n3]);
        }
        return n6;
    }

    int getCoefficient(int n2) {
        int[] nArray = this.coefficients;
        return nArray[nArray.length - 1 - n2];
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        int[] nArray = this.coefficients;
        boolean bl = false;
        if (nArray[0] == 0) {
            bl = true;
        }
        return bl;
    }

    GenericGFPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray[i3] = this.field.multiply(this.coefficients[i3], n2);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiply(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (!this.isZero() && !((GenericGFPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n2 = nArray.length;
                int[] nArray2 = ((GenericGFPoly)object).coefficients;
                int n3 = nArray2.length;
                object = new int[n2 + n3 - 1];
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = nArray[i3];
                    for (int i4 = 0; i4 < n3; ++i4) {
                        int n5 = i3 + i4;
                        object[n5] = GenericGF.addOrSubtract((int)object[n5], this.field.multiply(n4, nArray2[i4]));
                    }
                }
                return new GenericGFPoly(this.field, (int[])object);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly multiplyByMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.field.getZero();
            }
            int n4 = this.coefficients.length;
            int[] nArray = new int[n2 + n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = this.field.multiply(this.coefficients[n2], n3);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i3 = this.getDegree(); i3 >= 0; --i3) {
            int n2;
            int n3 = this.getCoefficient(i3);
            if (n3 == 0) continue;
            if (n3 < 0) {
                if (i3 == this.getDegree()) {
                    stringBuilder.append("-");
                } else {
                    stringBuilder.append(" - ");
                }
                n2 = -n3;
            } else {
                n2 = n3;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" + ");
                    n2 = n3;
                }
            }
            if (i3 == 0 || n2 != 1) {
                if ((n2 = this.field.log(n2)) == 0) {
                    stringBuilder.append('1');
                } else if (n2 == 1) {
                    stringBuilder.append('a');
                } else {
                    stringBuilder.append("a^");
                    stringBuilder.append(n2);
                }
            }
            if (i3 == 0) continue;
            if (i3 == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i3);
        }
        return stringBuilder.toString();
    }
}

