/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common.detector;

import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int CORR = 1;
    private static final int INIT_SIZE = 10;
    private final int downInit;
    private final int height;
    private final BitMatrix image;
    private final int leftInit;
    private final int rightInit;
    private final int upInit;
    private final int width;

    public WhiteRectangleDetector(BitMatrix bitMatrix) throws NotFoundException {
        this(bitMatrix, 10, bitMatrix.getWidth() / 2, bitMatrix.getHeight() / 2);
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n2, int n3, int n4) throws NotFoundException {
        this.image = bitMatrix;
        this.height = bitMatrix.getHeight();
        this.width = bitMatrix.getWidth();
        this.leftInit = n3 - (n2 /= 2);
        this.rightInit = n3 + n2;
        this.upInit = n4 - n2;
        this.downInit = n4 + n2;
        if (this.upInit >= 0 && this.leftInit >= 0 && this.downInit < this.height && this.rightInit < this.width) {
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint[] centerEdges(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        float f3 = resultPoint.getX();
        float f4 = resultPoint.getY();
        float f5 = resultPoint2.getX();
        float f6 = resultPoint2.getY();
        float f7 = resultPoint3.getX();
        float f8 = resultPoint3.getY();
        float f9 = resultPoint4.getX();
        float f10 = resultPoint4.getY();
        if (f3 < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(f9 - 1.0f, f10 + 1.0f), new ResultPoint(f5 + 1.0f, f6 + 1.0f), new ResultPoint(f7 - 1.0f, f8 - 1.0f), new ResultPoint(f3 + 1.0f, f4 - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(f9 + 1.0f, f10 + 1.0f), new ResultPoint(f5 + 1.0f, f6 - 1.0f), new ResultPoint(f7 - 1.0f, f8 + 1.0f), new ResultPoint(f3 - 1.0f, f4 - 1.0f)};
    }

    private boolean containsBlackPoint(int n2, int n3, int n4, boolean bl) {
        if (bl) {
            while (n2 <= n3) {
                if (this.image.get(n2, n4)) {
                    return true;
                }
                ++n2;
            }
        } else {
            for (int i3 = n2; i3 <= n3; ++i3) {
                if (!this.image.get(n4, i3)) continue;
                return true;
            }
        }
        return false;
    }

    private ResultPoint getBlackPointOnSegment(float f3, float f4, float f5, float f6) {
        int n2 = MathUtils.round(MathUtils.distance(f3, f4, f5, f6));
        float f7 = n2;
        f5 = (f5 - f3) / f7;
        f6 = (f6 - f4) / f7;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            f7 = i3;
            int n4 = MathUtils.round(f7 * f5 + f3);
            if (!this.image.get(n4, n3 = MathUtils.round(f7 * f6 + f4))) continue;
            return new ResultPoint(n4, n3);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public ResultPoint[] detect() throws NotFoundException {
        var1_1 = this.leftInit;
        var2_2 = this.rightInit;
        var3_3 = this.upInit;
        var4_4 = this.downInit;
        var5_5 = false;
        var6_6 = 1;
        var7_7 = 1;
        var8_8 = 0;
        var9_9 = false;
        var10_10 = false;
        var11_11 = false;
        block0: while (true) {
            var12_12 = var2_2;
            var13_13 = var3_3;
            var14_14 = var4_4;
            var15_15 = var5_5;
            var16_16 = var1_1;
            if (var7_7 == 0) break;
            var17_17 = true;
            var12_12 = 0;
            var14_14 = var8_8;
            while ((var17_17 || var14_14 == 0) && var2_2 < this.width) {
                var18_18 = this.containsBlackPoint(var3_3, var4_4, var2_2, false);
                if (var18_18) {
                    ++var2_2;
                    var14_14 = 1;
                    var12_12 = 1;
                    var17_17 = var18_18;
                    continue;
                }
                var17_17 = var18_18;
                if (var14_14 != 0) continue;
                ++var2_2;
                var17_17 = var18_18;
            }
            if (var2_2 >= this.width) lbl-1000:
            // 4 sources

            {
                while (true) {
                    var15_15 = true;
                    var12_12 = var2_2;
                    var13_13 = var3_3;
                    var14_14 = var4_4;
                    var16_16 = var1_1;
                    break block0;
                    break;
                }
            }
            var17_17 = true;
            while ((var17_17 || !var9_9) && var4_4 < this.height) {
                var18_18 = this.containsBlackPoint(var1_1, var2_2, var4_4, true);
                if (var18_18) {
                    ++var4_4;
                    var9_9 = true;
                    var12_12 = 1;
                    var17_17 = var18_18;
                    continue;
                }
                var17_17 = var18_18;
                if (var9_9) continue;
                ++var4_4;
                var17_17 = var18_18;
            }
            if (var4_4 >= this.height) ** GOTO lbl-1000
            var17_17 = true;
            while ((var17_17 || !var10_10) && var1_1 >= 0) {
                var18_18 = this.containsBlackPoint(var3_3, var4_4, var1_1, false);
                if (var18_18) {
                    --var1_1;
                    var10_10 = true;
                    var12_12 = 1;
                    var17_17 = var18_18;
                    continue;
                }
                var17_17 = var18_18;
                if (var10_10) continue;
                --var1_1;
                var17_17 = var18_18;
            }
            if (var1_1 < 0) ** GOTO lbl-1000
            var17_17 = true;
            while ((var17_17 || !var11_11) && var3_3 >= 0) {
                var18_18 = this.containsBlackPoint(var1_1, var2_2, var3_3, true);
                if (var18_18) {
                    --var3_3;
                    var11_11 = true;
                    var12_12 = 1;
                    var17_17 = var18_18;
                    continue;
                }
                var17_17 = var18_18;
                if (var11_11) continue;
                --var3_3;
                var17_17 = var18_18;
            }
            if (var3_3 >= 0) ** break;
            ** continue;
            var7_7 = var12_12;
            var8_8 = var14_14;
        }
        if (!var15_15) {
            var1_1 = var12_12 - var16_16;
            var19_19 = null;
            var20_20 = null;
            for (var3_3 = 1; var20_20 == null && var3_3 < var1_1; ++var3_3) {
                var20_20 = this.getBlackPointOnSegment(var16_16, var14_14 - var3_3, var16_16 + var3_3, var14_14);
            }
            if (var20_20 != null) {
                var21_21 = null;
                for (var3_3 = 1; var21_21 == null && var3_3 < var1_1; ++var3_3) {
                    var21_21 = this.getBlackPointOnSegment(var16_16, var13_13 + var3_3, var16_16 + var3_3, var13_13);
                }
                if (var21_21 != null) {
                    var22_22 = null;
                    for (var3_3 = 1; var22_22 == null && var3_3 < var1_1; ++var3_3) {
                        var22_22 = this.getBlackPointOnSegment(var12_12, var13_13 + var3_3, var12_12 - var3_3, var13_13);
                    }
                    if (var22_22 != null) {
                        for (var3_3 = var6_6; var19_19 == null && var3_3 < var1_1; ++var3_3) {
                            var19_19 = this.getBlackPointOnSegment(var12_12, var14_14 - var3_3, var12_12 - var3_3, var14_14);
                        }
                        if (var19_19 != null) {
                            return this.centerEdges(var19_19, var20_20, var22_22, var21_21);
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

