/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common;

import com.ailiwean.core.zxing.core.Binarizer;
import com.ailiwean.core.zxing.core.LuminanceSource;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.GlobalHistogramBinarizer;

public final class HybridBinarizerCrude
extends GlobalHistogramBinarizer {
    private final int BLOCK_SIZE;
    private final int BLOCK_SIZE_MASK;
    private final int BLOCK_SIZE_POWER = HybridBinarizerCrude.getRandom();
    private final int MINIMUM_DIMENSION;
    private BitMatrix matrix;

    public HybridBinarizerCrude(LuminanceSource luminanceSource) {
        super(luminanceSource);
        int n2 = this.BLOCK_SIZE = 1 << this.BLOCK_SIZE_POWER;
        this.BLOCK_SIZE_MASK = n2 - 1;
        this.MINIMUM_DIMENSION = n2 * 5;
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n5 - n6;
        int n9 = n4 - n6;
        int[][] nArray = new int[n3][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n10 = n5 = i3 << n7;
            if (n5 > n8) {
                n10 = n8;
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                int n11;
                int n12;
                n5 = n12 = i4 << n7;
                if (n12 > n9) {
                    n5 = n9;
                }
                n5 = n10 * n4 + n5;
                n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 255;
                while (n12 < n6) {
                    int n16;
                    int n17;
                    for (n11 = 0; n11 < n6; ++n11) {
                        n17 = byArray[n5 + n11] & 0xFF;
                        n16 = n13 + n17;
                        n13 = n15;
                        if (n17 < n15) {
                            n13 = n17;
                        }
                        n15 = n14;
                        if (n17 > n14) {
                            n15 = n17;
                        }
                        n14 = n15;
                        n15 = n13;
                        n13 = n16;
                    }
                    n16 = n12;
                    n17 = n5;
                    n11 = n13;
                    if (n14 - n15 > 24) {
                        n11 = n5;
                        int n18 = n12;
                        block4: while (true) {
                            n12 = n18 + 1;
                            n5 = n11 + n4;
                            n16 = n12;
                            n17 = n5;
                            n11 = n13;
                            if (n12 >= n6) break;
                            n16 = 0;
                            n17 = n13;
                            while (true) {
                                n18 = n12;
                                n11 = n5;
                                n13 = n17;
                                if (n16 >= n6) continue block4;
                                n17 += byArray[n5 + n16] & 0xFF;
                                ++n16;
                            }
                            break;
                        }
                    }
                    n13 = n11;
                    n12 = n16 + 1;
                    n5 = n17 + n4;
                }
                n5 = n13 >> n7 * 2;
                if (n14 - n15 <= 24) {
                    n5 = n12 = n15 / 2;
                    if (i3 > 0) {
                        n5 = n12;
                        if (i4 > 0) {
                            n11 = i3 - 1;
                            n5 = nArray[n11][i4];
                            int[] nArray2 = nArray[i3];
                            n13 = i4 - 1;
                            n13 = (n5 + nArray2[n13] * 2 + nArray[n11][n13]) / 4;
                            n5 = n12;
                            if (n15 < n13) {
                                n5 = n13;
                            }
                        }
                    }
                }
                nArray[i3][i4] = n5;
            }
        }
        return nArray;
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n2, int n3, int n4, int n5, int[][] nArray, BitMatrix bitMatrix, int n6, int n7) {
        int n8 = n5 - n6;
        int n9 = n4 - n6;
        for (n5 = 0; n5 < n3; ++n5) {
            int n10 = n5 << n7;
            if (n10 > n8) {
                n10 = n8;
            }
            int n11 = HybridBinarizerCrude.cap(n5, n3 - 3);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n12 = i3 << n7;
                if (n12 > n9) {
                    n12 = n9;
                }
                int n13 = HybridBinarizerCrude.cap(i3, n2 - 3);
                int n14 = 0;
                for (int i4 = -2; i4 <= 2; ++i4) {
                    int[] nArray2 = nArray[n11 + i4];
                    n14 += nArray2[n13 - 2] + nArray2[n13 - 1] + nArray2[n13] + nArray2[n13 + 1] + nArray2[2 + n13];
                }
                HybridBinarizerCrude.thresholdBlock(byArray, n12, n10, n14 / 25, n4, n6, bitMatrix);
            }
        }
    }

    private static int cap(int n2, int n3) {
        int n4 = 2;
        n2 = n2 < 2 ? n4 : Math.min(n2, n3);
        return n2;
    }

    private static int getRandom() {
        return (int)(Math.random() * (double)7) + 1;
    }

    private static void thresholdBlock(byte[] byArray, int n2, int n3, int n4, int n5, int n6, BitMatrix bitMatrix) {
        int n7 = n3 * n5 + n2;
        int n8 = 0;
        while (n8 < n6) {
            for (int i3 = 0; i3 < n6; ++i3) {
                if ((byArray[n7 + i3] & 0xFF) > n4) continue;
                bitMatrix.set(n2 + i3, n3 + n8);
            }
            ++n8;
            n7 += n5;
        }
    }

    @Override
    protected BitMatrix creatBitMatrix() throws NotFoundException {
        Object object = this.getLuminanceSource();
        int n2 = ((LuminanceSource)object).getWidth();
        int n3 = ((LuminanceSource)object).getHeight();
        int n4 = this.MINIMUM_DIMENSION;
        if (n2 >= n4 && n3 >= n4) {
            int n5;
            int n6;
            byte[] byArray = ((LuminanceSource)object).getMatrix();
            n4 = n6 = n2 >> this.BLOCK_SIZE_POWER;
            if ((this.BLOCK_SIZE_MASK & n2) != 0) {
                n4 = n6 + 1;
            }
            n6 = n5 = n3 >> this.BLOCK_SIZE_POWER;
            if ((this.BLOCK_SIZE_MASK & n3) != 0) {
                n6 = n5 + 1;
            }
            object = HybridBinarizerCrude.calculateBlackPoints(byArray, n4, n6, n2, n3, this.BLOCK_SIZE, this.BLOCK_SIZE_POWER);
            BitMatrix bitMatrix = new BitMatrix(n2, n3);
            HybridBinarizerCrude.calculateThresholdForBlock(byArray, n4, n6, n2, n3, (int[][])object, bitMatrix, this.BLOCK_SIZE, this.BLOCK_SIZE_POWER);
            this.matrix = bitMatrix;
            return this.matrix;
        }
        return null;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizerCrude(luminanceSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.bitMatrix != null) return this.bitMatrix;
        synchronized (this) {
            if (this.bitMatrix != null) return this.bitMatrix;
            this.bitMatrix = this.creatBitMatrix();
            return this.bitMatrix;
        }
    }
}

