/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common;

import com.ailiwean.core.zxing.core.Binarizer;
import com.ailiwean.core.zxing.core.LuminanceSource;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = 8;
        int n7 = n5 - 8;
        int n8 = n4 - 8;
        int[][] nArray = new int[n3][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n9 = n5 = i3 << 3;
            if (n5 > n7) {
                n9 = n7;
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                int n10;
                n5 = n10 = i4 << 3;
                if (n10 > n8) {
                    n5 = n8;
                }
                n10 = n9 * n4 + n5;
                int n11 = 0;
                n5 = 0;
                int n12 = 0;
                int n13 = 255;
                while (n11 < n6) {
                    int n14;
                    int n15;
                    for (n15 = 0; n15 < n6; ++n15) {
                        n6 = byArray[n10 + n15] & 0xFF;
                        n14 = n5 + n6;
                        n5 = n13;
                        if (n6 < n13) {
                            n5 = n6;
                        }
                        n13 = n12;
                        if (n6 > n12) {
                            n13 = n6;
                        }
                        n6 = 8;
                        n12 = n13;
                        n13 = n5;
                        n5 = n14;
                    }
                    if (n12 - n13 > 24) {
                        n6 = n11 + 1;
                        n11 = n5;
                        n5 = n10 += n4;
                        n10 = n6;
                        while (true) {
                            n14 = ++n10;
                            n15 = n5;
                            n6 = n11;
                            if (n10 < 8) {
                                for (n6 = 0; n6 < 8; ++n6) {
                                    n11 += byArray[n5 + n6] & 0xFF;
                                }
                                n5 += n4;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n6 = n5;
                        n15 = n10;
                        n14 = n11;
                    }
                    n11 = 8;
                    n5 = n6;
                    n10 = n15 + n4;
                    n6 = n11;
                    n11 = ++n14;
                }
                n5 >>= 6;
                if (n12 - n13 <= 24) {
                    n5 = n10 = n13 / 2;
                    if (i3 > 0) {
                        n5 = n10;
                        if (i4 > 0) {
                            n5 = i3 - 1;
                            n11 = nArray[n5][i4];
                            int[] nArray2 = nArray[i3];
                            n12 = i4 - 1;
                            n11 = (n11 + nArray2[n12] * 2 + nArray[n5][n12]) / 4;
                            n5 = n10;
                            if (n13 < n11) {
                                n5 = n11;
                            }
                        }
                    }
                }
                nArray[i3][i4] = n5;
            }
        }
        return nArray;
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n2, int n3, int n4, int n5, int[][] nArray, BitMatrix bitMatrix) {
        int n6 = n5 - 8;
        int n7 = n4 - 8;
        for (n5 = 0; n5 < n3; ++n5) {
            int n8 = n5 << 3;
            if (n8 > n6) {
                n8 = n6;
            }
            int n9 = HybridBinarizer.cap(n5, n3 - 3);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n10 = i3 << 3;
                if (n10 > n7) {
                    n10 = n7;
                }
                int n11 = HybridBinarizer.cap(i3, n2 - 3);
                int n12 = 0;
                for (int i4 = -2; i4 <= 2; ++i4) {
                    int[] nArray2 = nArray[n9 + i4];
                    n12 += nArray2[n11 - 2] + nArray2[n11 - 1] + nArray2[n11] + nArray2[n11 + 1] + nArray2[2 + n11];
                }
                HybridBinarizer.thresholdBlock(byArray, n10, n8, n12 / 25, n4, bitMatrix);
            }
        }
    }

    private static int cap(int n2, int n3) {
        int n4 = 2;
        n2 = n2 < 2 ? n4 : Math.min(n2, n3);
        return n2;
    }

    private static void thresholdBlock(byte[] byArray, int n2, int n3, int n4, int n5, BitMatrix bitMatrix) {
        int n6 = n3 * n5 + n2;
        int n7 = 0;
        while (n7 < 8) {
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((byArray[n6 + i3] & 0xFF) > n4) continue;
                bitMatrix.set(n2 + i3, n3 + n7);
            }
            ++n7;
            n6 += n5;
        }
    }

    @Override
    protected BitMatrix creatBitMatrix() throws NotFoundException {
        Object object = this.getLuminanceSource();
        int n2 = ((LuminanceSource)object).getWidth();
        int n3 = ((LuminanceSource)object).getHeight();
        if (n2 >= 40 && n3 >= 40) {
            int n4;
            int n5;
            byte[] byArray = ((LuminanceSource)object).getMatrix();
            int n6 = n5 = n2 >> 3;
            if ((n2 & 7) != 0) {
                n6 = n5 + 1;
            }
            n5 = n4 = n3 >> 3;
            if ((n3 & 7) != 0) {
                n5 = n4 + 1;
            }
            int[][] nArray = HybridBinarizer.calculateBlackPoints(byArray, n6, n5, n2, n3);
            object = new BitMatrix(n2, n3);
            HybridBinarizer.calculateThresholdForBlock(byArray, n6, n5, n2, n3, nArray, (BitMatrix)object);
            this.matrix = object;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.bitMatrix != null) return this.bitMatrix;
        synchronized (this) {
            if (this.bitMatrix != null) return this.bitMatrix;
            this.bitMatrix = this.creatBitMatrix();
            return this.bitMatrix;
        }
    }
}

