/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common;

import com.ailiwean.core.zxing.core.Binarizer;
import com.ailiwean.core.zxing.core.LuminanceSource;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final byte[] EMPTY = new byte[0];
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final int LUMINANCE_SHIFT = 3;
    protected BitMatrix bitMatrix;
    private final int[] buckets;
    private byte[] luminances = EMPTY;

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
        this.buckets = new int[32];
    }

    private static int estimateBlackPoint(int[] nArray) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n7;
            if (nArray[n4] > n7) {
                n3 = nArray[n4];
                n9 = n4;
            }
            n2 = n8;
            if (nArray[n4] > n8) {
                n2 = nArray[n4];
            }
            n7 = n3;
            n8 = n2;
        }
        n4 = 0;
        n7 = 0;
        for (n3 = n6; n3 < n5; ++n3) {
            n2 = n3 - n9;
            n6 = nArray[n3] * n2 * n2;
            n2 = n7;
            if (n6 > n7) {
                n4 = n3;
                n2 = n6;
            }
            n7 = n2;
        }
        n7 = n4;
        n3 = n9;
        if (n9 > n4) {
            n3 = n4;
            n7 = n9;
        }
        if (n7 - n3 > n5 / 16) {
            n6 = n9 = n7 - 1;
            n4 = -1;
            while (n9 > n3) {
                n2 = n9 - n3;
                n5 = n2 * n2 * (n7 - n9) * (n8 - nArray[n9]);
                n2 = n4;
                if (n5 > n4) {
                    n6 = n9;
                    n2 = n5;
                }
                --n9;
                n4 = n2;
            }
            return n6 << 3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void initArrays(int n2) {
        if (this.luminances.length < n2) {
            this.luminances = new byte[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.buckets[n2] = 0;
        }
    }

    protected BitMatrix creatBitMatrix() throws NotFoundException {
        int n2;
        int n3;
        int n4;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n5 = luminanceSource.getWidth();
        int n6 = luminanceSource.getHeight();
        this.bitMatrix = new BitMatrix(n5, n6);
        this.initArrays(n5);
        Object[] objectArray = this.buckets;
        for (n4 = 1; n4 < 5; ++n4) {
            byte[] byArray = luminanceSource.getRow(n6 * n4 / 5, this.luminances);
            n3 = n5 * 4 / 5;
            for (n2 = n5 / 5; n2 < n3; ++n2) {
                int n7 = (byArray[n2] & 0xFF) >> 3;
                objectArray[n7] = objectArray[n7] + 1;
            }
        }
        n3 = GlobalHistogramBinarizer.estimateBlackPoint(objectArray);
        objectArray = luminanceSource.getMatrix();
        for (n4 = 0; n4 < n6; ++n4) {
            for (n2 = 0; n2 < n5; ++n2) {
                if ((objectArray[n4 * n5 + n2] & 0xFF) >= n3) continue;
                this.bitMatrix.set(n2, n4);
            }
        }
        return this.bitMatrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.bitMatrix != null) return this.bitMatrix;
        synchronized (this) {
            if (this.bitMatrix != null) return this.bitMatrix;
            this.bitMatrix = this.creatBitMatrix();
            return this.bitMatrix;
        }
    }

    @Override
    public BitArray getBlackRow(int n2, BitArray bitArray) throws NotFoundException {
        int n3;
        Object object = this.getLuminanceSource();
        int n4 = ((LuminanceSource)object).getWidth();
        if (bitArray != null && bitArray.getSize() >= n4) {
            bitArray.clear();
        } else {
            bitArray = new BitArray(n4);
        }
        this.initArrays(n4);
        byte[] byArray = ((LuminanceSource)object).getRow(n2, this.luminances);
        object = this.buckets;
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n3 = (byArray[n2] & 0xFF) >> 3;
            object[n3] = object[n3] + true;
        }
        int n6 = GlobalHistogramBinarizer.estimateBlackPoint((int[])object);
        if (n4 < 3) {
            for (n2 = n5; n2 < n4; ++n2) {
                if ((byArray[n2] & 0xFF) >= n6) continue;
                bitArray.set(n2);
            }
        } else {
            n5 = byArray[0];
            n2 = byArray[1] & 0xFF;
            n3 = n5 & 0xFF;
            n5 = 1;
            while (n5 < n4 - 1) {
                int n7 = n5 + 1;
                int n8 = byArray[n7] & 0xFF;
                if ((n2 * 4 - n3 - n8) / 2 < n6) {
                    bitArray.set(n5);
                }
                n3 = n2;
                n5 = n7;
                n2 = n8;
            }
        }
        return bitArray;
    }
}

