/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common;

import com.ailiwean.core.zxing.core.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int[] bits;
    private final int height;
    private final int rowSize;
    private final int width;

    public BitMatrix(int n2) {
        this(n2, n2);
    }

    public BitMatrix(int n2, int n3) {
        if (n2 >= 1 && n3 >= 1) {
            this.width = n2;
            this.height = n3;
            this.rowSize = (n2 + 31) / 32;
            this.bits = new int[this.rowSize * n3];
            return;
        }
        throw new IllegalArgumentException("Both dimensions must be greater than 0");
    }

    private BitMatrix(int n2, int n3, int n4, int[] nArray) {
        this.width = n2;
        this.height = n3;
        this.rowSize = n4;
        this.bits = nArray;
    }

    private String buildToString(String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i3 = 0; i3 < this.height; ++i3) {
            for (int i4 = 0; i4 < this.width; ++i4) {
                String string5 = this.get(i4, i3) ? string2 : string3;
                stringBuilder.append(string5);
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BitMatrix parse(String object, String charSequence, String string2) {
        int n2;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        boolean[] blArray = new boolean[((String)object).length()];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        while (n4 < ((String)object).length()) {
            if (((String)object).charAt(n4) != '\n' && ((String)object).charAt(n4) != '\r') {
                if (((String)object).substring(n4, ((String)charSequence).length() + n4).equals(charSequence)) {
                    n4 += ((String)charSequence).length();
                    blArray[n5] = true;
                } else {
                    if (!((String)object).substring(n4, string2.length() + n4).equals(string2)) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("illegal character encountered: ");
                        ((StringBuilder)charSequence).append(((String)object).substring(n4));
                        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
                    }
                    n4 += string2.length();
                    blArray[n5] = false;
                }
                ++n5;
                continue;
            }
            n2 = n6;
            int n9 = n7;
            int n10 = n8;
            if (n5 > n6) {
                if (n7 == -1) {
                    n7 = n5 - n6;
                } else if (n5 - n6 != n7) {
                    throw new IllegalArgumentException("row lengths do not match");
                }
                n10 = n8 + 1;
                n2 = n5;
                n9 = n7;
            }
            ++n4;
            n6 = n2;
            n7 = n9;
            n8 = n10;
        }
        n4 = n7;
        n2 = n8;
        if (n5 > n6) {
            if (n7 == -1) {
                n7 = n5 - n6;
            } else if (n5 - n6 != n7) {
                throw new IllegalArgumentException("row lengths do not match");
            }
            n2 = n8 + 1;
            n4 = n7;
        }
        object = new BitMatrix(n4, n2);
        n7 = n3;
        while (n7 < n5) {
            if (blArray[n7]) {
                ((BitMatrix)object).set(n7 % n4, n7 / n4);
            }
            ++n7;
        }
        return object;
    }

    public static BitMatrix parse(boolean[][] blArray) {
        int n2 = blArray.length;
        int n3 = blArray[0].length;
        BitMatrix bitMatrix = new BitMatrix(n3, n2);
        for (int i3 = 0; i3 < n2; ++i3) {
            boolean[] blArray2 = blArray[i3];
            for (int i4 = 0; i4 < n3; ++i4) {
                if (!blArray2[i4]) continue;
                bitMatrix.set(i4, i3);
            }
        }
        return bitMatrix;
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.bits[i3] = 0;
        }
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }

    public byte[] covertYData() {
        byte[] byArray = new byte[this.width * this.height];
        for (int i3 = 0; i3 < this.height; ++i3) {
            int n2;
            for (int i4 = 0; i4 < (n2 = this.width); ++i4) {
                int n3 = this.get(i4, i3) ? 0 : 255;
                byArray[n2 * i3 + i4] = (byte)n3;
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof BitMatrix;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (BitMatrix)object;
        bl = bl2;
        if (this.width == ((BitMatrix)object).width) {
            bl = bl2;
            if (this.height == ((BitMatrix)object).height) {
                bl = bl2;
                if (this.rowSize == ((BitMatrix)object).rowSize) {
                    bl = bl2;
                    if (Arrays.equals(this.bits, ((BitMatrix)object).bits)) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public void flip(int n2, int n3) {
        n3 = n3 * this.rowSize + n2 / 32;
        int[] nArray = this.bits;
        nArray[n3] = 1 << (n2 & 0x1F) ^ nArray[n3];
    }

    public boolean get(int n2, int n3) {
        int n4 = this.rowSize;
        int n5 = n2 / 32;
        n3 = this.bits[n3 * n4 + n5];
        boolean bl = true;
        if ((n3 >>> (n2 & 0x1F) & 1) == 0) {
            bl = false;
        }
        return bl;
    }

    public int[] getBottomRightOnBit() {
        int n2;
        for (n2 = this.bits.length - 1; n2 >= 0 && this.bits[n2] == 0; --n2) {
        }
        if (n2 < 0) {
            return null;
        }
        int n3 = this.rowSize;
        int n4 = n2 / n3;
        int n5 = this.bits[n2];
        int n6 = 31;
        while (n5 >>> n6 == 0) {
            --n6;
        }
        return new int[]{n2 % n3 * 32 + n6, n4};
    }

    public int[] getEnclosingRectangle() {
        int n2 = this.width;
        int n3 = this.height;
        int n4 = -1;
        int n5 = -1;
        for (int i3 = 0; i3 < this.height; ++i3) {
            int n6 = n5;
            n5 = n4;
            n4 = n6;
            for (int i4 = 0; i4 < (n6 = this.rowSize); ++i4) {
                int n7 = this.bits[n6 * i3 + i4];
                int n8 = n2;
                int n9 = n5;
                int n10 = n3;
                int n11 = n4;
                if (n7 != 0) {
                    n6 = n3;
                    if (i3 < n3) {
                        n6 = i3;
                    }
                    n3 = n4;
                    if (i3 > n4) {
                        n3 = i3;
                    }
                    int n12 = i4 * 32;
                    int n13 = 31;
                    n4 = n2;
                    if (n12 < n2) {
                        n4 = 0;
                        while (n7 << 31 - n4 == 0) {
                            ++n4;
                        }
                        n11 = n4 + n12;
                        n4 = n2;
                        if (n11 < n2) {
                            n4 = n11;
                        }
                    }
                    n8 = n4;
                    n9 = n5;
                    n10 = n6;
                    n11 = n3;
                    if (n12 + 31 > n5) {
                        n2 = n13;
                        while (n7 >>> n2 == 0) {
                            --n2;
                        }
                        n2 = n12 + n2;
                        n8 = n4;
                        n9 = n5;
                        n10 = n6;
                        n11 = n3;
                        if (n2 > n5) {
                            n9 = n2;
                            n11 = n3;
                            n10 = n6;
                            n8 = n4;
                        }
                    }
                }
                n2 = n8;
                n5 = n9;
                n3 = n10;
                n4 = n11;
            }
            n6 = n5;
            n5 = n4;
            n4 = n6;
        }
        if (n4 >= n2 && n5 >= n3) {
            return new int[]{n2, n3, n4 - n2 + 1, n5 - n3 + 1};
        }
        return null;
    }

    public int getHeight() {
        return this.height;
    }

    public BitArray getRow(int n2, BitArray bitArray) {
        if (bitArray != null && bitArray.getSize() >= this.width) {
            bitArray.clear();
        } else {
            bitArray = new BitArray(this.width);
        }
        int n3 = this.rowSize;
        for (int i3 = 0; i3 < this.rowSize; ++i3) {
            bitArray.setBulk(i3 * 32, this.bits[n2 * n3 + i3]);
        }
        return bitArray;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public int[] getTopLeftOnBit() {
        int[] nArray;
        int n2;
        for (n2 = 0; n2 < (nArray = this.bits).length && nArray[n2] == 0; ++n2) {
        }
        nArray = this.bits;
        if (n2 == nArray.length) {
            return null;
        }
        int n3 = this.rowSize;
        int n4 = n2 / n3;
        int n5 = nArray[n2];
        int n6 = 0;
        while (n5 << 31 - n6 == 0) {
            ++n6;
        }
        return new int[]{n2 % n3 * 32 + n6, n4};
    }

    public int getWidth() {
        return this.width;
    }

    public int hashCode() {
        int n2 = this.width;
        return (((n2 * 31 + n2) * 31 + this.height) * 31 + this.rowSize) * 31 + Arrays.hashCode(this.bits);
    }

    public void rotate180() {
        BitArray bitArray = new BitArray(this.width);
        BitArray bitArray2 = new BitArray(this.width);
        int n2 = (this.height + 1) / 2;
        for (int i3 = 0; i3 < n2; ++i3) {
            bitArray = this.getRow(i3, bitArray);
            int n3 = this.height - 1 - i3;
            bitArray2 = this.getRow(n3, bitArray2);
            bitArray.reverse();
            bitArray2.reverse();
            this.setRow(i3, bitArray2);
            this.setRow(n3, bitArray);
        }
    }

    public void set(int n2, int n3) {
        n3 = n3 * this.rowSize + n2 / 32;
        int[] nArray = this.bits;
        nArray[n3] = 1 << (n2 & 0x1F) | nArray[n3];
    }

    public void setRegion(int n2, int n3, int n4, int n5) {
        if (n3 >= 0 && n2 >= 0) {
            if (n5 >= 1 && n4 >= 1) {
                int n6 = n4 + n2;
                if ((n5 += n3) <= this.height && n6 <= this.width) {
                    while (n3 < n5) {
                        int n7 = this.rowSize;
                        for (n4 = n2; n4 < n6; ++n4) {
                            int[] nArray = this.bits;
                            int n8 = n4 / 32 + n7 * n3;
                            nArray[n8] = nArray[n8] | 1 << (n4 & 0x1F);
                        }
                        ++n3;
                    }
                    return;
                }
                throw new IllegalArgumentException("The region must fit inside the matrix");
            }
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        throw new IllegalArgumentException("Left and top must be nonnegative");
    }

    public void setRow(int n2, BitArray object) {
        int[] nArray = ((BitArray)object).getBitArray();
        object = this.bits;
        int n3 = this.rowSize;
        System.arraycopy(nArray, 0, object, n2 * n3, n3);
    }

    public int size() {
        return this.bits.length;
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String string2, String string3) {
        return this.buildToString(string2, string3, "\n");
    }

    @Deprecated
    public String toString(String string2, String string3, String string4) {
        return this.buildToString(string2, string3, string4);
    }

    public void unset(int n2, int n3) {
        n3 = n3 * this.rowSize + n2 / 32;
        int[] nArray = this.bits;
        nArray[n3] = 1 << (n2 & 0x1F) & nArray[n3];
    }

    public void xor(BitMatrix bitMatrix) {
        int n2 = this.width;
        if (n2 == bitMatrix.width && this.height == bitMatrix.height && this.rowSize == bitMatrix.rowSize) {
            BitArray bitArray = new BitArray(n2);
            for (n2 = 0; n2 < this.height; ++n2) {
                int n3 = this.rowSize;
                int[] nArray = bitMatrix.getRow(n2, bitArray).getBitArray();
                for (int i3 = 0; i3 < this.rowSize; ++i3) {
                    int[] nArray2 = this.bits;
                    int n4 = n3 * n2 + i3;
                    nArray2[n4] = nArray2[n4] ^ nArray[i3];
                }
            }
            return;
        }
        throw new IllegalArgumentException("input matrix dimensions do not match");
    }
}

