/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n2) {
        this.size = n2;
        this.bits = BitArray.makeArray(n2);
    }

    BitArray(int[] nArray, int n2) {
        this.bits = nArray;
        this.size = n2;
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.bits.length * 32) {
            int[] nArray = BitArray.makeArray(n2);
            int[] nArray2 = this.bits;
            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
            this.bits = nArray;
        }
    }

    private static int[] makeArray(int n2) {
        return new int[(n2 + 31) / 32];
    }

    public void appendBit(boolean bl) {
        this.ensureCapacity(this.size + 1);
        if (bl) {
            int[] nArray = this.bits;
            int n2 = this.size;
            int n3 = n2 / 32;
            nArray[n3] = 1 << (n2 & 0x1F) | nArray[n3];
        }
        ++this.size;
    }

    public void appendBitArray(BitArray bitArray) {
        int n2 = bitArray.size;
        this.ensureCapacity(this.size + n2);
        for (int i3 = 0; i3 < n2; ++i3) {
            this.appendBit(bitArray.get(i3));
        }
    }

    public void appendBits(int n2, int n3) {
        if (n3 >= 0 && n3 <= 32) {
            this.ensureCapacity(this.size + n3);
            while (n3 > 0) {
                boolean bl = true;
                if ((n2 >> n3 - 1 & 1) != 1) {
                    bl = false;
                }
                this.appendBit(bl);
                --n3;
            }
            return;
        }
        throw new IllegalArgumentException("Num bits must be between 0 and 32");
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.bits[i3] = 0;
        }
    }

    public BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof BitArray;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (BitArray)object;
        bl = bl2;
        if (this.size == ((BitArray)object).size) {
            bl = bl2;
            if (Arrays.equals(this.bits, ((BitArray)object).bits)) {
                bl = true;
            }
        }
        return bl;
    }

    public void flip(int n2) {
        int[] nArray = this.bits;
        int n3 = n2 / 32;
        nArray[n3] = 1 << (n2 & 0x1F) ^ nArray[n3];
    }

    public boolean get(int n2) {
        int n3 = this.bits[n2 / 32];
        boolean bl = true;
        if ((1 << (n2 & 0x1F) & n3) == 0) {
            bl = false;
        }
        return bl;
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public int getNextSet(int n2) {
        int n3 = this.size;
        if (n2 >= n3) {
            return n3;
        }
        n3 = n2 / 32;
        int n4 = this.bits[n3];
        n2 = -(1 << (n2 & 0x1F)) & n4;
        while (n2 == 0) {
            int[] nArray = this.bits;
            if (++n3 == nArray.length) {
                return this.size;
            }
            n2 = nArray[n3];
        }
        return Math.min(n3 * 32 + Integer.numberOfTrailingZeros(n2), this.size);
    }

    public int getNextUnset(int n2) {
        int n3 = this.size;
        if (n2 >= n3) {
            return n3;
        }
        int n4 = n2 / 32;
        n3 = this.bits[n4];
        n3 = -(1 << (n2 & 0x1F)) & n3;
        n2 = n4;
        while (n3 == 0) {
            int[] nArray = this.bits;
            if (++n2 == nArray.length) {
                return this.size;
            }
            n3 = nArray[n2];
        }
        return Math.min(n2 * 32 + Integer.numberOfTrailingZeros(n3), this.size);
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    public int hashCode() {
        return this.size * 31 + Arrays.hashCode(this.bits);
    }

    public boolean isRange(int n2, int n3, boolean bl) {
        if (n3 >= n2 && n2 >= 0 && n3 <= this.size) {
            if (n3 == n2) {
                return true;
            }
            int n4 = n3 - 1;
            int n5 = n2 / 32;
            int n6 = n4 / 32;
            for (int i3 = n5; i3 <= n6; ++i3) {
                int n7 = 31;
                n3 = i3 > n5 ? 0 : n2 & 0x1F;
                if (i3 >= n6) {
                    n7 = 0x1F & n4;
                }
                n7 = (2 << n7) - (1 << n3);
                int n8 = this.bits[i3];
                n3 = bl ? n7 : 0;
                if ((n8 & n7) == n3) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public void reverse() {
        int n2;
        int[] nArray = new int[this.bits.length];
        int n3 = (this.size - 1) / 32;
        int n4 = n3 + 1;
        for (n2 = 0; n2 < n4; ++n2) {
            long l3 = this.bits[n2];
            l3 = (l3 & 0x55555555L) << 1 | l3 >> 1 & 0x55555555L;
            l3 = (l3 & 0x33333333L) << 2 | l3 >> 2 & 0x33333333L;
            l3 = (l3 & 0xF0F0F0FL) << 4 | l3 >> 4 & 0xF0F0F0FL;
            l3 = (l3 & 0xFF00FFL) << 8 | l3 >> 8 & 0xFF00FFL;
            nArray[n3 - n2] = (int)((l3 & 0xFFFFL) << 16 | l3 >> 16 & 0xFFFFL);
        }
        n3 = this.size;
        n2 = n4 * 32;
        if (n3 != n2) {
            int n5 = n2 - n3;
            n2 = nArray[0] >>> n5;
            for (n3 = 1; n3 < n4; ++n3) {
                int n6 = nArray[n3];
                nArray[n3 - 1] = n2 | n6 << 32 - n5;
                n2 = n6 >>> n5;
            }
            nArray[n4 - 1] = n2;
        }
        this.bits = nArray;
    }

    public void set(int n2) {
        int[] nArray = this.bits;
        int n3 = n2 / 32;
        nArray[n3] = 1 << (n2 & 0x1F) | nArray[n3];
    }

    public void setBulk(int n2, int n3) {
        this.bits[n2 / 32] = n3;
    }

    public void setRange(int n2, int n3) {
        if (n3 >= n2 && n2 >= 0 && n3 <= this.size) {
            if (n3 == n2) {
                return;
            }
            int n4 = n3 - 1;
            int n5 = n2 / 32;
            int n6 = n4 / 32;
            for (n3 = n5; n3 <= n6; ++n3) {
                int n7 = 31;
                int n8 = n3 > n5 ? 0 : n2 & 0x1F;
                if (n3 >= n6) {
                    n7 = 0x1F & n4;
                }
                int[] nArray = this.bits;
                nArray[n3] = (2 << n7) - (1 << n8) | nArray[n3];
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void toBytes(int n2, byte[] byArray, int n3, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            int n5 = 0;
            for (int i4 = 0; i4 < 8; ++i4) {
                int n6 = n5;
                if (this.get(n2)) {
                    n6 = n5 | 1 << 7 - i4;
                }
                ++n2;
                n5 = n6;
            }
            byArray[n3 + i3] = (byte)n5;
        }
    }

    public String toString() {
        int n2 = this.size;
        StringBuilder stringBuilder = new StringBuilder(n2 + n2 / 8 + 1);
        for (n2 = 0; n2 < this.size; ++n2) {
            char c3;
            if ((n2 & 7) == 0) {
                stringBuilder.append(' ');
            }
            char c4 = this.get(n2) ? (c3 = 'X') : (c3 = '.');
            stringBuilder.append(c4);
        }
        return stringBuilder.toString();
    }

    public void xor(BitArray bitArray) {
        if (this.size == bitArray.size) {
            int[] nArray;
            for (int i3 = 0; i3 < (nArray = this.bits).length; ++i3) {
                nArray[i3] = nArray[i3] ^ bitArray.bits[i3];
            }
            return;
        }
        throw new IllegalArgumentException("Sizes don't match");
    }
}

