/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.client.result.ResultParser;
import com.ailiwean.core.zxing.core.client.result.VINParsedResult;
import java.util.regex.Pattern;

public final class VINResultParser
extends ResultParser {
    private static final Pattern AZ09;
    private static final Pattern IOQ;

    static {
        IOQ = Pattern.compile("[IOQ]");
        AZ09 = Pattern.compile("[A-Z0-9]{17}");
    }

    private static char checkChar(int n2) {
        if (n2 < 10) {
            return (char)(n2 + 48);
        }
        if (n2 == 10) {
            return 'X';
        }
        throw new IllegalArgumentException();
    }

    private static boolean checkChecksum(CharSequence charSequence) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < charSequence.length()) {
            int n4 = n2 + 1;
            n3 += VINResultParser.vinPositionWeight(n4) * VINResultParser.vinCharValue(charSequence.charAt(n2));
            n2 = n4;
        }
        if (charSequence.charAt(8) == VINResultParser.checkChar(n3 % 11)) {
            bl = true;
        }
        return bl;
    }

    private static String countryCode(CharSequence charSequence) {
        block30: {
            char c3;
            block27: {
                block28: {
                    block29: {
                        char c4 = charSequence.charAt(0);
                        c3 = charSequence.charAt(1);
                        if (c4 == '9') break block27;
                        if (c4 == 'S') break block28;
                        if (c4 == 'Z') break block29;
                        switch (c4) {
                            default: {
                                switch (c4) {
                                    default: {
                                        switch (c4) {
                                            default: {
                                                break block30;
                                            }
                                            case 'X': {
                                                if (c3 == '0' || c3 >= '3' && c3 <= '9') {
                                                    return "RU";
                                                }
                                                break block30;
                                            }
                                            case 'W': {
                                                return "DE";
                                            }
                                            case 'V': {
                                                if (c3 >= 'F' && c3 <= 'R') {
                                                    return "FR";
                                                }
                                                if (c3 >= 'S' && c3 <= 'W') {
                                                    return "ES";
                                                }
                                                break block30;
                                            }
                                        }
                                    }
                                    case 'M': {
                                        if (c3 >= 'A' && c3 <= 'E') {
                                            return "IN";
                                        }
                                        break block30;
                                    }
                                    case 'L': {
                                        return "CN";
                                    }
                                    case 'K': {
                                        if (c3 >= 'L' && c3 <= 'R') {
                                            return "KO";
                                        }
                                        break block30;
                                    }
                                    case 'J': {
                                        if (c3 >= 'A' && c3 <= 'T') {
                                            return "JP";
                                        }
                                        break block30;
                                    }
                                }
                            }
                            case '3': {
                                if (c3 >= 'A' && c3 <= 'W') {
                                    return "MX";
                                }
                                break block30;
                            }
                            case '2': {
                                return "CA";
                            }
                            case '1': 
                            case '4': 
                            case '5': {
                                return "US";
                            }
                        }
                    }
                    if (c3 >= 'A' && c3 <= 'R') {
                        return "IT";
                    }
                    break block30;
                }
                if (c3 >= 'A' && c3 <= 'M') {
                    return "UK";
                }
                if (c3 >= 'N' && c3 <= 'T') {
                    return "DE";
                }
                break block30;
            }
            if (c3 >= 'A' && c3 <= 'E' || c3 >= '3' && c3 <= '9') {
                return "BR";
            }
        }
        return null;
    }

    private static int modelYear(char c3) {
        if (c3 >= 'E' && c3 <= 'H') {
            return c3 - 69 + 1984;
        }
        if (c3 >= 'J' && c3 <= 'N') {
            return c3 - 74 + 1988;
        }
        if (c3 == 'P') {
            return 1993;
        }
        if (c3 >= 'R' && c3 <= 'T') {
            return c3 - 82 + 1994;
        }
        if (c3 >= 'V' && c3 <= 'Y') {
            return c3 - 86 + 1997;
        }
        if (c3 >= '1' && c3 <= '9') {
            return c3 - 49 + 2001;
        }
        if (c3 >= 'A' && c3 <= 'D') {
            return c3 - 65 + 2010;
        }
        throw new IllegalArgumentException();
    }

    private static int vinCharValue(char c3) {
        if (c3 >= 'A' && c3 <= 'I') {
            return c3 - 65 + 1;
        }
        if (c3 >= 'J' && c3 <= 'R') {
            return c3 - 74 + 1;
        }
        if (c3 >= 'S' && c3 <= 'Z') {
            return c3 - 83 + 2;
        }
        if (c3 >= '0' && c3 <= '9') {
            return c3 - 48;
        }
        throw new IllegalArgumentException();
    }

    private static int vinPositionWeight(int n2) {
        if (n2 >= 1 && n2 <= 7) {
            return 9 - n2;
        }
        if (n2 == 8) {
            return 10;
        }
        if (n2 == 9) {
            return 0;
        }
        if (n2 >= 10 && n2 <= 17) {
            return 19 - n2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public VINParsedResult parse(Result object) {
        block5: {
            if (((Result)object).getBarcodeFormat() != BarcodeFormat.CODE_39) {
                return null;
            }
            object = ((Result)object).getText();
            if (!AZ09.matcher((CharSequence)(object = IOQ.matcher((CharSequence)object).replaceAll("").trim())).matches()) {
                return null;
            }
            try {
                if (VINResultParser.checkChecksum((CharSequence)object)) break block5;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        String string2 = ((String)object).substring(0, 3);
        object = new VINParsedResult((String)object, string2, ((String)object).substring(3, 9), ((String)object).substring(9, 17), VINResultParser.countryCode(string2), ((String)object).substring(3, 8), VINResultParser.modelYear(((String)object).charAt(9)), ((String)object).charAt(10), ((String)object).substring(11));
        return object;
    }
}

