/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.client.result.AddressBookParsedResult;
import com.ailiwean.core.zxing.core.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern COMMA;
    private static final Pattern CR_LF_SPACE_TAB;
    private static final Pattern EQUALS;
    private static final Pattern NEWLINE_ESCAPE;
    private static final Pattern SEMICOLON;
    private static final Pattern SEMICOLON_OR_COMMA;
    private static final Pattern UNESCAPED_SEMICOLONS;
    private static final Pattern VCARD_ESCAPES;
    private static final Pattern VCARD_LIKE_DATE;

    static {
        VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
        CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
        NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
        VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
        EQUALS = Pattern.compile("=");
        SEMICOLON = Pattern.compile(";");
        UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
        COMMA = Pattern.compile(",");
        SEMICOLON_OR_COMMA = Pattern.compile("[;,]");
    }

    private static String decodeQuotedPrintable(CharSequence charSequence, String string2) {
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n3 < n2) {
            char c3 = charSequence.charAt(n3);
            int n4 = n3;
            if (c3 != '\n') {
                n4 = n3;
                if (c3 != '\r') {
                    if (c3 != '=') {
                        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuilder);
                        stringBuilder.append(c3);
                        n4 = n3;
                    } else {
                        n4 = n3;
                        if (n3 < n2 - 2) {
                            char c4 = charSequence.charAt(n3 + 1);
                            n4 = n3;
                            if (c4 != '\r') {
                                n4 = n3;
                                if (c4 != '\n') {
                                    c3 = charSequence.charAt(n3 += 2);
                                    int n5 = VCardResultParser.parseHexDigit(c4);
                                    int n6 = VCardResultParser.parseHexDigit(c3);
                                    n4 = n3;
                                    if (n5 >= 0) {
                                        n4 = n3;
                                        if (n6 >= 0) {
                                            byteArrayOutputStream.write((n5 << 4) + n6);
                                            n4 = n3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            n3 = n4 + 1;
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuilder);
        return stringBuilder.toString();
    }

    private static void formatNames(Iterable<List<String>> stringArray) {
        if (stringArray != null) {
            for (List list : stringArray) {
                int n2;
                CharSequence charSequence = (String)list.get(0);
                stringArray = new String[5];
                int n3 = 0;
                for (int i3 = 0; i3 < stringArray.length - 1 && (n2 = ((String)charSequence).indexOf(59, n3)) >= 0; ++i3) {
                    stringArray[i3] = ((String)charSequence).substring(n3, n2);
                    n3 = n2 + 1;
                }
                stringArray[i3] = ((String)charSequence).substring(n3);
                charSequence = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(stringArray, 3, (StringBuilder)charSequence);
                VCardResultParser.maybeAppendComponent(stringArray, 1, (StringBuilder)charSequence);
                VCardResultParser.maybeAppendComponent(stringArray, 2, (StringBuilder)charSequence);
                VCardResultParser.maybeAppendComponent(stringArray, 0, (StringBuilder)charSequence);
                VCardResultParser.maybeAppendComponent(stringArray, 4, (StringBuilder)charSequence);
                list.set(0, ((StringBuilder)charSequence).toString().trim());
            }
        }
    }

    private static boolean isLikeVCardDate(CharSequence charSequence) {
        boolean bl = charSequence == null || VCARD_LIKE_DATE.matcher(charSequence).matches();
        return bl;
    }

    static List<String> matchSingleVCardPrefixedField(CharSequence list, String string2, boolean bl, boolean bl2) {
        list = (list = VCardResultParser.matchVCardPrefixedField((CharSequence)((Object)list), string2, bl, bl2)) != null && !list.isEmpty() ? (List)list.get(0) : null;
        return list;
    }

    static List<List<String>> matchVCardPrefixedField(CharSequence charSequence, String string2, boolean bl, boolean bl2) {
        int n2 = string2.length();
        int n3 = 0;
        Object object = null;
        while (n3 < n2) {
            Object object2;
            Object object3;
            String[] stringArray;
            Object object4;
            int n4;
            Object object5 = new StringBuilder();
            ((StringBuilder)object5).append("(?:^|\n)");
            ((StringBuilder)object5).append((Object)charSequence);
            ((StringBuilder)object5).append("(?:;([^:]*))?:");
            object5 = Pattern.compile(((StringBuilder)object5).toString(), 2).matcher(string2);
            int n5 = n3;
            if (n3 > 0) {
                n5 = n3 - 1;
            }
            if (!((Matcher)object5).find(n5)) break;
            int n6 = ((Matcher)object5).end(0);
            if ((object5 = ((Matcher)object5).group(1)) != null) {
                String[] stringArray2 = SEMICOLON.split((CharSequence)object5);
                int n7 = stringArray2.length;
                n4 = 0;
                Object object6 = null;
                n3 = 0;
                object4 = null;
                object5 = null;
                while (true) {
                    stringArray = object6;
                    n5 = n3;
                    object3 = object4;
                    object2 = object5;
                    if (n4 < n7) {
                        object2 = stringArray2[n4];
                        stringArray = object6;
                        if (object6 == null) {
                            stringArray = new ArrayList(1);
                        }
                        stringArray.add(object2);
                        object6 = EQUALS.split((CharSequence)object2, 2);
                        n5 = n3;
                        object2 = object4;
                        object3 = object5;
                        if (((String[])object6).length > 1) {
                            String string3 = object6[0];
                            object6 = object6[1];
                            if ("ENCODING".equalsIgnoreCase(string3) && "QUOTED-PRINTABLE".equalsIgnoreCase((String)object6)) {
                                n5 = 1;
                                object2 = object4;
                                object3 = object5;
                            } else if ("CHARSET".equalsIgnoreCase(string3)) {
                                n5 = n3;
                                object2 = object6;
                                object3 = object5;
                            } else {
                                n5 = n3;
                                object2 = object4;
                                object3 = object5;
                                if ("VALUE".equalsIgnoreCase(string3)) {
                                    object3 = object6;
                                    object2 = object4;
                                    n5 = n3;
                                }
                            }
                        }
                        ++n4;
                        object6 = stringArray;
                        n3 = n5;
                        object4 = object2;
                        object5 = object3;
                        continue;
                    }
                    break;
                }
            } else {
                stringArray = null;
                n5 = 0;
                object3 = null;
                object2 = null;
            }
            n3 = n6;
            while ((n4 = string2.indexOf(10, n3)) >= 0) {
                if (n4 < string2.length() - 1 && (string2.charAt(n3 = n4 + 1) == ' ' || string2.charAt(n3) == '\t')) {
                    n3 = n4 + 2;
                    continue;
                }
                if (n5 == 0) break;
                if (n4 < 1 || string2.charAt(n4 - 1) != '=') {
                    if (n4 < 2 || string2.charAt(n4 - 2) != '=') break;
                }
                n3 = n4 + 1;
            }
            if (n4 < 0) {
                n3 = n2;
                continue;
            }
            n3 = n4;
            object5 = object;
            if (n4 > n6) {
                object5 = object;
                if (object == null) {
                    object5 = new ArrayList(1);
                }
                n3 = n4;
                if (n4 >= 1) {
                    n3 = n4;
                    if (string2.charAt(n4 - 1) == '\r') {
                        n3 = n4 - 1;
                    }
                }
                object = object4 = string2.substring(n6, n3);
                if (bl) {
                    object = ((String)object4).trim();
                }
                if (n5 != 0) {
                    object = object4 = VCardResultParser.decodeQuotedPrintable((CharSequence)object, (String)object3);
                    if (bl2) {
                        object = UNESCAPED_SEMICOLONS.matcher((CharSequence)object4).replaceAll("\n").trim();
                    }
                } else {
                    object4 = object;
                    if (bl2) {
                        object4 = UNESCAPED_SEMICOLONS.matcher((CharSequence)object).replaceAll("\n").trim();
                    }
                    object = CR_LF_SPACE_TAB.matcher((CharSequence)object4).replaceAll("");
                    object = NEWLINE_ESCAPE.matcher((CharSequence)object).replaceAll("\n");
                    object = VCARD_ESCAPES.matcher((CharSequence)object).replaceAll("$1");
                }
                object4 = object;
                if ("uri".equals(object2)) {
                    try {
                        object4 = URI.create((String)object).getSchemeSpecificPart();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        object4 = object;
                    }
                }
                if (stringArray == null) {
                    object = new ArrayList<Object>(1);
                    object.add(object4);
                    object5.add(object);
                } else {
                    stringArray.add(0, object4);
                    object5.add(stringArray);
                }
            }
            ++n3;
            object = object5;
        }
        return object;
    }

    private static void maybeAppendComponent(String[] stringArray, int n2, StringBuilder stringBuilder) {
        if (stringArray[n2] != null && !stringArray[n2].isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[n2]);
        }
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string2, StringBuilder stringBuilder) {
        if (byteArrayOutputStream.size() > 0) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string2 == null) {
                string2 = new String(byArray, StandardCharsets.UTF_8);
            } else {
                try {
                    String string3;
                    string2 = string3 = new String(byArray, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(byArray, StandardCharsets.UTF_8);
                }
            }
            byteArrayOutputStream.reset();
            stringBuilder.append(string2);
        }
    }

    private static String toPrimaryValue(List<String> object) {
        object = object != null && !object.isEmpty() ? object.get(0) : null;
        return object;
    }

    private static String[] toPrimaryValues(Collection<List<String>> object) {
        if (object != null && !object.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(object.size());
            Iterator<List<String>> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next().get(0);
                if (object == null || ((String)object).isEmpty()) continue;
                arrayList.add(object);
            }
            return arrayList.toArray(EMPTY_STR_ARRAY);
        }
        return null;
    }

    private static String[] toTypes(Collection<List<String>> object) {
        if (object != null && !object.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(object.size());
            Iterator<List<String>> iterator = object.iterator();
            while (iterator.hasNext()) {
                block4: {
                    List<String> list = iterator.next();
                    object = list.get(0);
                    if (object == null || ((String)object).isEmpty()) continue;
                    for (int i3 = 1; i3 < list.size(); ++i3) {
                        object = list.get(i3);
                        int n2 = ((String)object).indexOf(61);
                        if (n2 >= 0) {
                            if (!"TYPE".equalsIgnoreCase(((String)object).substring(0, n2))) continue;
                            object = ((String)object).substring(n2 + 1);
                        }
                        break block4;
                    }
                    object = null;
                }
                arrayList.add(object);
            }
            return arrayList.toArray(EMPTY_STR_ARRAY);
        }
        return null;
    }

    @Override
    public AddressBookParsedResult parse(Result list) {
        String string2 = VCardResultParser.getMassagedText((Result)((Object)list));
        if (((Matcher)((Object)(list = BEGIN_VCARD.matcher(string2)))).find() && ((Matcher)((Object)list)).start() == 0) {
            list = VCardResultParser.matchVCardPrefixedField("FN", string2, true, false);
            List<List<String>> list2 = list;
            if (list == null) {
                list2 = VCardResultParser.matchVCardPrefixedField("N", string2, true, false);
                VCardResultParser.formatNames(list2);
            }
            String[] stringArray = (list = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", string2, true, false)) == null ? null : COMMA.split((CharSequence)list.get(0));
            List<List<String>> list3 = VCardResultParser.matchVCardPrefixedField("TEL", string2, true, false);
            List<List<String>> list4 = VCardResultParser.matchVCardPrefixedField("EMAIL", string2, true, false);
            List<String> list5 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", string2, false, false);
            List<List<String>> list6 = VCardResultParser.matchVCardPrefixedField("ADR", string2, true, true);
            List<String> list7 = VCardResultParser.matchSingleVCardPrefixedField("ORG", string2, true, true);
            List<String> list8 = VCardResultParser.matchSingleVCardPrefixedField("BDAY", string2, true, false);
            if (list8 != null && !VCardResultParser.isLikeVCardDate(list8.get(0))) {
                list8 = null;
            }
            List<String> list9 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", string2, true, false);
            List<List<String>> list10 = VCardResultParser.matchVCardPrefixedField("URL", string2, true, false);
            List<String> list11 = VCardResultParser.matchSingleVCardPrefixedField("IMPP", string2, true, false);
            list = VCardResultParser.matchSingleVCardPrefixedField("GEO", string2, true, false);
            list = list == null ? null : SEMICOLON_OR_COMMA.split((CharSequence)list.get(0));
            if (list != null && ((List<Object>)list).length != 2) {
                list = null;
            }
            return new AddressBookParsedResult(VCardResultParser.toPrimaryValues(list2), stringArray, null, VCardResultParser.toPrimaryValues(list3), VCardResultParser.toTypes(list3), VCardResultParser.toPrimaryValues(list4), VCardResultParser.toTypes(list4), VCardResultParser.toPrimaryValue(list11), VCardResultParser.toPrimaryValue(list5), VCardResultParser.toPrimaryValues(list6), VCardResultParser.toTypes(list6), VCardResultParser.toPrimaryValue(list7), VCardResultParser.toPrimaryValue(list8), VCardResultParser.toPrimaryValue(list9), VCardResultParser.toPrimaryValues(list10), (String[])list);
        }
        return null;
    }
}

