/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.client.result.ResultParser;
import com.ailiwean.core.zxing.core.client.result.URIParsedResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URIResultParser
extends ResultParser {
    private static final Pattern ALLOWED_URI_CHARS_PATTERN = Pattern.compile("[-._~:/?#\\[\\]@!$&'()*+,;=%A-Za-z0-9]+");
    private static final Pattern URL_WITHOUT_PROTOCOL_PATTERN;
    private static final Pattern URL_WITH_PROTOCOL_PATTERN;
    private static final Pattern USER_IN_HOST;

    static {
        USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
        URL_WITH_PROTOCOL_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-.]+:");
        URL_WITHOUT_PROTOCOL_PATTERN = Pattern.compile("([a-zA-Z0-9\\-]+\\.){1,6}[a-zA-Z]{2,}(:\\d{1,5})?(/|\\?|$)");
    }

    static boolean isBasicallyValidURI(String object) {
        boolean bl = ((String)object).contains(" ");
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        Matcher matcher = URL_WITH_PROTOCOL_PATTERN.matcher((CharSequence)object);
        if (matcher.find() && matcher.start() == 0) {
            return true;
        }
        object = URL_WITHOUT_PROTOCOL_PATTERN.matcher((CharSequence)object);
        bl = bl2;
        if (((Matcher)object).find()) {
            bl = bl2;
            if (((Matcher)object).start() == 0) {
                bl = true;
            }
        }
        return bl;
    }

    static boolean isPossiblyMaliciousURI(String string2) {
        boolean bl = !ALLOWED_URI_CHARS_PATTERN.matcher(string2).matches() || USER_IN_HOST.matcher(string2).find();
        return bl;
    }

    @Override
    public URIParsedResult parse(Result object) {
        if (!((String)(object = URIResultParser.getMassagedText((Result)object))).startsWith("URL:") && !((String)object).startsWith("URI:")) {
            if (URIResultParser.isBasicallyValidURI((String)(object = ((String)object).trim())) && !URIResultParser.isPossiblyMaliciousURI((String)object)) {
                return new URIParsedResult((String)object, null);
            }
            return null;
        }
        return new URIParsedResult(((String)object).substring(4).trim(), null);
    }
}

