/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.client.result.AddressBookAUResultParser;
import com.ailiwean.core.zxing.core.client.result.AddressBookDoCoMoResultParser;
import com.ailiwean.core.zxing.core.client.result.BizcardResultParser;
import com.ailiwean.core.zxing.core.client.result.BookmarkDoCoMoResultParser;
import com.ailiwean.core.zxing.core.client.result.EmailAddressResultParser;
import com.ailiwean.core.zxing.core.client.result.EmailDoCoMoResultParser;
import com.ailiwean.core.zxing.core.client.result.ExpandedProductResultParser;
import com.ailiwean.core.zxing.core.client.result.GeoResultParser;
import com.ailiwean.core.zxing.core.client.result.ISBNResultParser;
import com.ailiwean.core.zxing.core.client.result.ParsedResult;
import com.ailiwean.core.zxing.core.client.result.ProductResultParser;
import com.ailiwean.core.zxing.core.client.result.SMSMMSResultParser;
import com.ailiwean.core.zxing.core.client.result.SMSTOMMSTOResultParser;
import com.ailiwean.core.zxing.core.client.result.SMTPResultParser;
import com.ailiwean.core.zxing.core.client.result.TelResultParser;
import com.ailiwean.core.zxing.core.client.result.TextParsedResult;
import com.ailiwean.core.zxing.core.client.result.URIResultParser;
import com.ailiwean.core.zxing.core.client.result.URLTOResultParser;
import com.ailiwean.core.zxing.core.client.result.VCardResultParser;
import com.ailiwean.core.zxing.core.client.result.VEventResultParser;
import com.ailiwean.core.zxing.core.client.result.VINResultParser;
import com.ailiwean.core.zxing.core.client.result.WifiResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ResultParser {
    private static final Pattern AMPERSAND;
    private static final String BYTE_ORDER_MARK = "\ufeff";
    private static final Pattern DIGITS;
    static final String[] EMPTY_STR_ARRAY;
    private static final Pattern EQUALS;
    private static final ResultParser[] PARSERS;

    static {
        PARSERS = new ResultParser[]{new BookmarkDoCoMoResultParser(), new AddressBookDoCoMoResultParser(), new EmailDoCoMoResultParser(), new AddressBookAUResultParser(), new VCardResultParser(), new BizcardResultParser(), new VEventResultParser(), new EmailAddressResultParser(), new SMTPResultParser(), new TelResultParser(), new SMSMMSResultParser(), new SMSTOMMSTOResultParser(), new GeoResultParser(), new WifiResultParser(), new URLTOResultParser(), new URIResultParser(), new ISBNResultParser(), new ProductResultParser(), new ExpandedProductResultParser(), new VINResultParser()};
        DIGITS = Pattern.compile("\\d+");
        AMPERSAND = Pattern.compile("&");
        EQUALS = Pattern.compile("=");
        EMPTY_STR_ARRAY = new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void appendKeyValue(CharSequence charSequence, Map<String, String> map) {
        String[] stringArray = EQUALS.split(charSequence, 2);
        if (stringArray.length != 2) return;
        charSequence = stringArray[0];
        String string2 = stringArray[1];
        try {
            map.put((String)charSequence, ResultParser.urlDecode(string2));
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private static int countPrecedingBackslashes(CharSequence charSequence, int n2) {
        --n2;
        int n3 = 0;
        while (n2 >= 0 && charSequence.charAt(n2) == '\\') {
            ++n3;
            --n2;
        }
        return n3;
    }

    protected static String getMassagedText(Result object) {
        String string2 = ((Result)object).getText();
        object = string2;
        if (string2.startsWith(BYTE_ORDER_MARK)) {
            object = string2.substring(1);
        }
        return object;
    }

    protected static boolean isStringOfDigits(CharSequence charSequence, int n2) {
        boolean bl = charSequence != null && n2 > 0 && n2 == charSequence.length() && DIGITS.matcher(charSequence).matches();
        return bl;
    }

    protected static boolean isSubstringOfDigits(CharSequence charSequence, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = false;
        if (charSequence != null) {
            if (n3 <= 0) {
                bl2 = bl;
            } else {
                bl2 = bl;
                if (charSequence.length() >= (n3 += n2)) {
                    bl2 = bl;
                    if (DIGITS.matcher(charSequence.subSequence(n2, n3)).matches()) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String[] matchPrefixedField(String string2, String string3, char c3, boolean bl) {
        int n2 = string3.length();
        Object object = null;
        int n3 = 0;
        block0: while (true) {
            if (n3 >= n2 || (n3 = string3.indexOf(string2, n3)) < 0) {
                if (object == null) return null;
                if (!object.isEmpty()) return object.toArray(EMPTY_STR_ARRAY);
                return null;
            }
            int n4 = n3 + string2.length();
            boolean bl2 = true;
            n3 = n4;
            while (true) {
                ArrayList<Object> arrayList;
                if (!bl2) continue block0;
                if ((n3 = string3.indexOf(c3, n3)) < 0) {
                    n3 = string3.length();
                    arrayList = object;
                } else {
                    if (ResultParser.countPrecedingBackslashes(string3, n3) % 2 != 0) {
                        ++n3;
                        continue;
                    }
                    arrayList = object;
                    if (object == null) {
                        arrayList = new ArrayList<Object>(3);
                    }
                    String string4 = ResultParser.unescapeBackslash(string3.substring(n4, n3));
                    object = string4;
                    if (bl) {
                        object = string4.trim();
                    }
                    if (!((String)object).isEmpty()) {
                        arrayList.add(object);
                    }
                    ++n3;
                }
                bl2 = false;
                object = arrayList;
            }
            break;
        }
    }

    static String matchSinglePrefixedField(String object, String string2, char c3, boolean bl) {
        object = (object = ResultParser.matchPrefixedField((String)object, string2, c3, bl)) == null ? null : object[0];
        return object;
    }

    protected static void maybeAppend(String string2, StringBuilder stringBuilder) {
        if (string2 != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string2);
        }
    }

    protected static void maybeAppend(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                stringBuilder.append('\n');
                stringBuilder.append(string2);
            }
        }
    }

    protected static String[] maybeWrap(String object) {
        object = object == null ? null : new String[]{object};
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int parseHexDigit(char c3) {
        if (c3 >= '0' && c3 <= '9') {
            return c3 - 48;
        }
        int n2 = 97;
        if (c3 >= 'a' && c3 <= 'f') {
            return c3 - n2 + 10;
        }
        n2 = 65;
        if (c3 < 'A') return -1;
        if (c3 > 'F') return -1;
        return c3 - n2 + 10;
    }

    static Map<String, String> parseNameValuePairs(String stringArray) {
        int n2 = stringArray.indexOf(63);
        if (n2 < 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        stringArray = AMPERSAND.split(stringArray.substring(n2 + 1));
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            ResultParser.appendKeyValue(stringArray[n2], hashMap);
        }
        return hashMap;
    }

    public static ParsedResult parseResult(Result result) {
        ResultParser[] resultParserArray = PARSERS;
        int n2 = resultParserArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            ParsedResult parsedResult = resultParserArray[i3].parse(result);
            if (parsedResult == null) continue;
            return parsedResult;
        }
        return new TextParsedResult(result.getText(), null);
    }

    protected static String unescapeBackslash(String string2) {
        int n2 = string2.indexOf(92);
        if (n2 < 0) {
            return string2;
        }
        int n3 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n3 - 1);
        stringBuilder.append(string2.toCharArray(), 0, n2);
        boolean bl = false;
        while (n2 < n3) {
            char c3 = string2.charAt(n2);
            if (!bl && c3 == '\\') {
                bl = true;
            } else {
                stringBuilder.append(c3);
                bl = false;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    static String urlDecode(String string2) {
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public abstract ParsedResult parse(Result var1);
}

