/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.client.result.ParsedResult;
import com.ailiwean.core.zxing.core.client.result.ParsedResultType;

public final class GeoParsedResult
extends ParsedResult {
    private final double altitude;
    private final double latitude;
    private final double longitude;
    private final String query;

    GeoParsedResult(double d3, double d4, double d5, String string2) {
        super(ParsedResultType.GEO);
        this.latitude = d3;
        this.longitude = d4;
        this.altitude = d5;
        this.query = string2;
    }

    public double getAltitude() {
        return this.altitude;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.latitude);
        stringBuilder.append(", ");
        stringBuilder.append(this.longitude);
        if (this.altitude > 0.0) {
            stringBuilder.append(", ");
            stringBuilder.append(this.altitude);
            stringBuilder.append('m');
        }
        if (this.query != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.query);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public String getGeoURI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("geo:");
        stringBuilder.append(this.latitude);
        stringBuilder.append(',');
        stringBuilder.append(this.longitude);
        if (this.altitude > 0.0) {
            stringBuilder.append(',');
            stringBuilder.append(this.altitude);
        }
        if (this.query != null) {
            stringBuilder.append('?');
            stringBuilder.append(this.query);
        }
        return stringBuilder.toString();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getQuery() {
        return this.query;
    }
}

