/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.client.result;

import com.ailiwean.core.zxing.core.client.result.ParsedResult;
import com.ailiwean.core.zxing.core.client.result.ParsedResultType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CalendarParsedResult
extends ParsedResult {
    private static final Pattern DATE_TIME;
    private static final Pattern RFC2445_DURATION;
    private static final long[] RFC2445_DURATION_FIELD_UNITS;
    private final String[] attendees;
    private final String description;
    private final long end;
    private final boolean endAllDay;
    private final double latitude;
    private final String location;
    private final double longitude;
    private final String organizer;
    private final long start;
    private final boolean startAllDay;
    private final String summary;

    static {
        RFC2445_DURATION = Pattern.compile("P(?:(\\d+)W)?(?:(\\d+)D)?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+)S)?)?");
        RFC2445_DURATION_FIELD_UNITS = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L};
        DATE_TIME = Pattern.compile("[0-9]{8}(T[0-9]{6}Z?)?");
    }

    public CalendarParsedResult(String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String string8, double d3, double d4) {
        block7: {
            block6: {
                super(ParsedResultType.CALENDAR);
                this.summary = string2;
                try {
                    this.start = CalendarParsedResult.parseDate(string3);
                    if (string4 != null) break block6;
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(parseException.toString());
                }
                long l3 = CalendarParsedResult.parseDurationMS(string5);
                l3 = l3 < 0L ? -1L : (l3 += this.start);
                this.end = l3;
                break block7;
            }
            try {
                this.end = CalendarParsedResult.parseDate(string4);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.toString());
            }
        }
        int n2 = string3.length();
        boolean bl = false;
        boolean bl2 = n2 == 8;
        this.startAllDay = bl2;
        bl2 = bl;
        if (string4 != null) {
            bl2 = bl;
            if (string4.length() == 8) {
                bl2 = true;
            }
        }
        this.endAllDay = bl2;
        this.location = string6;
        this.organizer = string7;
        this.attendees = stringArray;
        this.description = string8;
        this.latitude = d3;
        this.longitude = d4;
    }

    private static String format(boolean bl, long l3) {
        if (l3 < 0L) {
            return null;
        }
        DateFormat dateFormat = bl ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2);
        return dateFormat.format(l3);
    }

    private static long parseDate(String object) throws ParseException {
        if (DATE_TIME.matcher((CharSequence)object).matches()) {
            if (((String)object).length() == 8) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                return simpleDateFormat.parse((String)object).getTime();
            }
            if (((String)object).length() == 16 && ((String)object).charAt(15) == 'Z') {
                long l3 = CalendarParsedResult.parseDateTimeString(((String)object).substring(0, 15));
                object = new GregorianCalendar();
                ((Calendar)object).setTime(new Date(l3 += (long)((Calendar)object).get(15)));
                return l3 + (long)((Calendar)object).get(16);
            }
            return CalendarParsedResult.parseDateTimeString((String)object);
        }
        throw new ParseException((String)object, 0);
    }

    private static long parseDateTimeString(String string2) throws ParseException {
        return new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH).parse(string2).getTime();
    }

    private static long parseDurationMS(CharSequence charSequence) {
        if (charSequence == null) {
            return -1L;
        }
        Matcher matcher = RFC2445_DURATION.matcher(charSequence);
        if (!matcher.matches()) {
            return -1L;
        }
        long l3 = 0L;
        int n2 = 0;
        while (n2 < RFC2445_DURATION_FIELD_UNITS.length) {
            int n3 = n2 + 1;
            charSequence = matcher.group(n3);
            long l4 = l3;
            if (charSequence != null) {
                l4 = l3 + RFC2445_DURATION_FIELD_UNITS[n2] * (long)Integer.parseInt((String)charSequence);
            }
            n2 = n3;
            l3 = l4;
        }
        return l3;
    }

    public String[] getAttendees() {
        return this.attendees;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(100);
        CalendarParsedResult.maybeAppend(this.summary, stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.startAllDay, this.start), stringBuilder);
        CalendarParsedResult.maybeAppend(CalendarParsedResult.format(this.endAllDay, this.end), stringBuilder);
        CalendarParsedResult.maybeAppend(this.location, stringBuilder);
        CalendarParsedResult.maybeAppend(this.organizer, stringBuilder);
        CalendarParsedResult.maybeAppend(this.attendees, stringBuilder);
        CalendarParsedResult.maybeAppend(this.description, stringBuilder);
        return stringBuilder.toString();
    }

    @Deprecated
    public Date getEnd() {
        long l3 = this.end;
        Date date = l3 < 0L ? null : new Date(l3);
        return date;
    }

    public long getEndTimestamp() {
        return this.end;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getLocation() {
        return this.location;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    @Deprecated
    public Date getStart() {
        return new Date(this.start);
    }

    public long getStartTimestamp() {
        return this.start;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean isEndAllDay() {
        return this.endAllDay;
    }

    public boolean isStartAllDay() {
        return this.startAllDay;
    }
}

