/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec.encoder;

import com.ailiwean.core.zxing.core.aztec.encoder.HighLevelEncoder;
import com.ailiwean.core.zxing.core.aztec.encoder.Token;
import com.ailiwean.core.zxing.core.common.BitArray;
import java.util.LinkedList;

final class State {
    static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    private final int binaryShiftByteCount;
    private final int bitCount;
    private final int mode;
    private final Token token;

    private State(Token token, int n2, int n3, int n4) {
        this.token = token;
        this.mode = n2;
        this.binaryShiftByteCount = n3;
        this.bitCount = n4;
    }

    private static int calculateBinaryShiftCost(State state) {
        int n2 = state.binaryShiftByteCount;
        if (n2 > 62) {
            return 21;
        }
        if (n2 > 31) {
            return 20;
        }
        if (n2 > 0) {
            return 10;
        }
        return 0;
    }

    State addBinaryShiftChar(int n2) {
        int n3;
        int n4;
        Object object;
        int n5;
        Object object2;
        block5: {
            int n6;
            block4: {
                object2 = this.token;
                n6 = this.mode;
                n5 = this.bitCount;
                if (n6 == 4) break block4;
                object = object2;
                n4 = n6;
                n3 = n5;
                if (n6 != 2) break block5;
            }
            n4 = HighLevelEncoder.LATCH_TABLE[n6][0];
            n3 = n4 >> 16;
            object = ((Token)object2).add(0xFFFF & n4, n3);
            n3 = n5 + n3;
            n4 = 0;
        }
        n5 = (n5 = this.binaryShiftByteCount) != 0 && n5 != 31 ? (n5 == 62 ? 9 : 8) : 18;
        object = object2 = new State((Token)object, n4, this.binaryShiftByteCount + 1, n3 + n5);
        if (((State)object2).binaryShiftByteCount == 2078) {
            object = ((State)object2).endBinaryShift(n2 + 1);
        }
        return object;
    }

    State endBinaryShift(int n2) {
        int n3 = this.binaryShiftByteCount;
        if (n3 == 0) {
            return this;
        }
        return new State(this.token.addBinaryShift(n2 - n3, n3), this.mode, 0, this.bitCount);
    }

    int getBinaryShiftByteCount() {
        return this.binaryShiftByteCount;
    }

    int getBitCount() {
        return this.bitCount;
    }

    int getMode() {
        return this.mode;
    }

    Token getToken() {
        return this.token;
    }

    boolean isBetterThanOrEqualTo(State state) {
        int n2;
        int n3 = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][state.mode] >> 16);
        int n4 = this.binaryShiftByteCount;
        int n5 = state.binaryShiftByteCount;
        if (n4 < n5) {
            n2 = n3 + (State.calculateBinaryShiftCost(state) - State.calculateBinaryShiftCost(this));
        } else {
            n2 = n3;
            if (n4 > n5) {
                n2 = n3;
                if (n5 > 0) {
                    n2 = n3 + 10;
                }
            }
        }
        boolean bl = n2 <= state.bitCount;
        return bl;
    }

    State latchAndAppend(int n2, int n3) {
        int n4 = this.bitCount;
        Token token = this.token;
        int n5 = n4;
        Token token2 = token;
        if (n2 != this.mode) {
            int n6 = HighLevelEncoder.LATCH_TABLE[this.mode][n2];
            n5 = n6 >> 16;
            token2 = token.add(0xFFFF & n6, n5);
            n5 = n4 + n5;
        }
        n4 = n2 == 2 ? 4 : 5;
        return new State(token2.add(n3, n4), n2, 0, n5 + n4);
    }

    State shiftAndAppend(int n2, int n3) {
        Token token = this.token;
        int n4 = this.mode == 2 ? 4 : 5;
        return new State(token.add(HighLevelEncoder.SHIFT_TABLE[this.mode][n2], n4).add(n3, 5), this.mode, 0, this.bitCount + n4 + 5);
    }

    BitArray toBitArray(byte[] byArray) {
        Object object;
        Object object2 = new LinkedList<Token>();
        for (object = this.endBinaryShift((int)byArray.length).token; object != null; object = ((Token)object).getPrevious()) {
            object2.addFirst(object);
        }
        object = new BitArray();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            ((Token)object2.next()).appendTo((BitArray)object, byArray);
        }
        return object;
    }

    public String toString() {
        return String.format("%s bits=%d bytes=%d", HighLevelEncoder.MODE_NAMES[this.mode], this.bitCount, this.binaryShiftByteCount);
    }
}

