/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec.encoder;

import com.ailiwean.core.zxing.core.aztec.encoder.AztecCode;
import com.ailiwean.core.zxing.core.aztec.encoder.HighLevelEncoder;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    public static final int DEFAULT_EC_PERCENT = 33;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    private static int[] bitsToWords(BitArray bitArray, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = bitArray.getSize() / n2;
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = bitArray.get(n3 * n2 + i3) ? 1 << n2 - i3 - 1 : 0;
                n5 |= n6;
            }
            nArray[n3] = n5;
        }
        return nArray;
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = 0; n5 < n3; n5 += 2) {
            int n6;
            int n7;
            for (n4 = n6 = n2 - n5; n4 <= (n7 = n2 + n5); ++n4) {
                bitMatrix.set(n4, n6);
                bitMatrix.set(n4, n7);
                bitMatrix.set(n6, n4);
                bitMatrix.set(n7, n4);
            }
        }
        n5 = n2 - n3;
        bitMatrix.set(n5, n5);
        n4 = n5 + 1;
        bitMatrix.set(n4, n5);
        bitMatrix.set(n5, n4);
        bitMatrix.set(n2 += n3, n5);
        bitMatrix.set(n2, n4);
        bitMatrix.set(n2, n2 - 1);
    }

    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl, int n2, BitArray bitArray) {
        int n3 = n2 / 2;
        int n4 = 0;
        if (bl) {
            for (n2 = n4; n2 < 7; ++n2) {
                n4 = n3 - 3 + n2;
                if (bitArray.get(n2)) {
                    bitMatrix.set(n4, n3 - 5);
                }
                if (bitArray.get(n2 + 7)) {
                    bitMatrix.set(n3 + 5, n4);
                }
                if (bitArray.get(20 - n2)) {
                    bitMatrix.set(n4, n3 + 5);
                }
                if (!bitArray.get(27 - n2)) continue;
                bitMatrix.set(n3 - 5, n4);
            }
        } else {
            for (n2 = 0; n2 < 10; ++n2) {
                n4 = n3 - 5 + n2 + n2 / 5;
                if (bitArray.get(n2)) {
                    bitMatrix.set(n4, n3 - 7);
                }
                if (bitArray.get(n2 + 10)) {
                    bitMatrix.set(n3 + 7, n4);
                }
                if (bitArray.get(29 - n2)) {
                    bitMatrix.set(n4, n3 + 7);
                }
                if (!bitArray.get(39 - n2)) continue;
                bitMatrix.set(n3 - 7, n4);
            }
        }
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static AztecCode encode(byte[] var0, int var1_1, int var2_2) {
        block18: {
            block19: {
                block20: {
                    var3_3 = new HighLevelEncoder((byte[])var0).encode();
                    var4_4 = var3_3.getSize() * var1_1 / 100 + 11;
                    var5_5 = var3_3.getSize();
                    var1_1 = 32;
                    if (var2_2 == 0) break block18;
                    var6_6 = var2_2 < 0;
                    var7_7 = Math.abs(var2_2);
                    if (var6_6) {
                        var1_1 = 4;
                    }
                    if (var7_7 > var1_1) break block19;
                    var8_8 = Encoder.totalBitsInLayer(var7_7, var6_6);
                    var2_2 = Encoder.WORD_SIZE[var7_7];
                    var0 = Encoder.stuffBits((BitArray)var3_3, var2_2);
                    if (var0.getSize() + var4_4 > var8_8 - var8_8 % var2_2) break block20;
                    if (var6_6 && var0.getSize() > var2_2 * 64) {
                        throw new IllegalArgumentException("Data to large for user specified layer");
                    }
                    var1_1 = var7_7;
                    var7_7 = var8_8;
                    ** GOTO lbl38
                }
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            throw new IllegalArgumentException(String.format("Illegal value %s for layers", new Object[]{var2_2}));
        }
        var0 = null;
        var1_1 = 0;
        for (var2_2 = 0; var2_2 <= 32; ++var2_2) {
            var6_6 = var2_2 <= 3;
            var8_8 = var6_6 != false ? var2_2 + 1 : var2_2;
            var7_7 = Encoder.totalBitsInLayer(var8_8, var6_6);
            if (var5_5 + var4_4 > var7_7) continue;
            if (var0 == null || var1_1 != Encoder.WORD_SIZE[var8_8]) {
                var1_1 = Encoder.WORD_SIZE[var8_8];
                var0 = Encoder.stuffBits((BitArray)var3_3, var1_1);
            }
            if (var6_6 && var0.getSize() > var1_1 * 64 || var0.getSize() + var4_4 > var7_7 - var7_7 % var1_1) continue;
            var2_2 = var1_1;
            var1_1 = var8_8;
lbl38:
            // 2 sources

            var3_3 = Encoder.generateCheckWords((BitArray)var0, var7_7, var2_2);
            var9_9 = var0.getSize() / var2_2;
            var10_10 = Encoder.generateModeMessage(var6_6, var1_1, var9_9);
            var2_2 = var6_6 != false ? 11 : 14;
            var11_11 = var2_2 + var1_1 * 4;
            var12_12 = new int[var11_11];
            if (var6_6) {
                for (var2_2 = 0; var2_2 < var12_12.length; ++var2_2) {
                    var12_12[var2_2] = var2_2;
                }
                var2_2 = var11_11;
            } else {
                var4_4 = var11_11 / 2;
                var7_7 = var11_11 + 1 + (var4_4 - 1) / 15 * 2;
                var5_5 = var7_7 / 2;
                var8_8 = 0;
                while (true) {
                    var2_2 = var7_7;
                    if (var8_8 >= var4_4) break;
                    var2_2 = var8_8 / 15 + var8_8;
                    var12_12[var4_4 - var8_8 - 1] = var5_5 - var2_2 - 1;
                    var12_12[var4_4 + var8_8] = var2_2 + var5_5 + 1;
                    ++var8_8;
                }
            }
            var0 = new BitMatrix(var2_2);
            var7_7 = 0;
            for (var8_8 = 0; var8_8 < var1_1; ++var8_8) {
                var4_4 = var6_6 != false ? 9 : 12;
                var13_13 = (var1_1 - var8_8) * 4 + var4_4;
                var4_4 = 0;
                while (true) {
                    if (var4_4 >= var13_13) break;
                    var14_14 = var4_4 * 2;
                    for (var5_5 = 0; var5_5 < 2; ++var5_5) {
                        if (var3_3.get(var7_7 + var14_14 + var5_5)) {
                            var15_15 = var8_8 * 2;
                            var0.set(var12_12[var15_15 + var5_5], var12_12[var15_15 + var4_4]);
                        }
                        if (var3_3.get(var13_13 * 2 + var7_7 + var14_14 + var5_5)) {
                            var15_15 = var8_8 * 2;
                            var0.set(var12_12[var15_15 + var4_4], var12_12[var11_11 - 1 - var15_15 - var5_5]);
                        }
                        if (var3_3.get(var13_13 * 4 + var7_7 + var14_14 + var5_5)) {
                            var15_15 = var11_11 - 1 - var8_8 * 2;
                            var0.set(var12_12[var15_15 - var5_5], var12_12[var15_15 - var4_4]);
                        }
                        if (!var3_3.get(var13_13 * 6 + var7_7 + var14_14 + var5_5)) continue;
                        var15_15 = var8_8 * 2;
                        var0.set(var12_12[var11_11 - 1 - var15_15 - var4_4], var12_12[var15_15 + var5_5]);
                    }
                    ++var4_4;
                }
                var7_7 += var13_13 * 8;
            }
            Encoder.drawModeMessage((BitMatrix)var0, var6_6, var2_2, var10_10);
            if (var6_6) {
                Encoder.drawBullsEye((BitMatrix)var0, var2_2 / 2, 5);
            } else {
                var5_5 = var2_2 / 2;
                Encoder.drawBullsEye((BitMatrix)var0, var5_5, 7);
                var7_7 = 0;
                var8_8 = 0;
                while (var7_7 < var11_11 / 2 - 1) {
                    for (var4_4 = var5_5 & 1; var4_4 < var2_2; var4_4 += 2) {
                        var13_13 = var5_5 - var8_8;
                        var0.set(var13_13, var4_4);
                        var14_14 = var5_5 + var8_8;
                        var0.set(var14_14, var4_4);
                        var0.set(var4_4, var13_13);
                        var0.set(var4_4, var14_14);
                    }
                    var7_7 += 15;
                    var8_8 += 16;
                }
            }
            var3_3 = new AztecCode();
            var3_3.setCompact(var6_6);
            var3_3.setSize(var2_2);
            var3_3.setLayers(var1_1);
            var3_3.setCodeWords(var9_9);
            var3_3.setMatrix((BitMatrix)var0);
            return var3_3;
        }
        throw new IllegalArgumentException("Data too large for an Aztec code");
    }

    private static BitArray generateCheckWords(BitArray object, int n2, int n3) {
        int n4 = ((BitArray)object).getSize() / n3;
        Object object2 = new ReedSolomonEncoder(Encoder.getGF(n3));
        int n5 = n2 / n3;
        object = Encoder.bitsToWords((BitArray)object, n3, n5);
        ((ReedSolomonEncoder)object2).encode((int[])object, n5 - n4);
        object2 = new BitArray();
        n4 = 0;
        ((BitArray)object2).appendBits(0, n2 % n3);
        n5 = ((Object)object).length;
        for (n2 = n4; n2 < n5; ++n2) {
            ((BitArray)object2).appendBits((int)object[n2], n3);
        }
        return object2;
    }

    static BitArray generateModeMessage(boolean bl, int n2, int n3) {
        BitArray bitArray = new BitArray();
        if (bl) {
            bitArray.appendBits(n2 - 1, 2);
            bitArray.appendBits(n3 - 1, 6);
            bitArray = Encoder.generateCheckWords(bitArray, 28, 4);
        } else {
            bitArray.appendBits(n2 - 1, 5);
            bitArray.appendBits(n3 - 1, 11);
            bitArray = Encoder.generateCheckWords(bitArray, 40, 4);
        }
        return bitArray;
    }

    private static GenericGF getGF(int n2) {
        if (n2 != 4) {
            if (n2 != 6) {
                if (n2 != 8) {
                    if (n2 != 10) {
                        if (n2 == 12) {
                            return GenericGF.AZTEC_DATA_12;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unsupported word size ");
                        stringBuilder.append(n2);
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    return GenericGF.AZTEC_DATA_10;
                }
                return GenericGF.AZTEC_DATA_8;
            }
            return GenericGF.AZTEC_DATA_6;
        }
        return GenericGF.AZTEC_PARAM;
    }

    /*
     * Unable to fully structure code
     */
    static BitArray stuffBits(BitArray var0, int var1_1) {
        var2_2 = new BitArray();
        var3_3 = var0.getSize();
        var4_4 = (1 << var1_1) - 2;
        block0: for (var5_5 = 0; var5_5 < var3_3; var5_5 += var1_1) {
            var7_7 = 0;
            for (var6_6 = 0; var6_6 < var1_1; ++var6_6) {
                block9: {
                    block8: {
                        var8_8 = var5_5 + var6_6;
                        if (var8_8 >= var3_3) break block8;
                        var9_9 = var7_7;
                        if (!var0.get(var8_8)) break block9;
                    }
                    var9_9 = var7_7 | 1 << var1_1 - 1 - var6_6;
                }
                var7_7 = var9_9;
            }
            var9_9 = var7_7 & var4_4;
            if (var9_9 == var4_4) {
                var2_2.appendBits(var9_9, var1_1);
lbl19:
                // 2 sources

                while (true) {
                    --var5_5;
                    continue block0;
                    break;
                }
            }
            if (var9_9 == 0) {
                var2_2.appendBits(var7_7 | 1, var1_1);
                ** continue;
            }
            var2_2.appendBits(var7_7, var1_1);
        }
        return var2_2;
    }

    private static int totalBitsInLayer(int n2, boolean bl) {
        int n3 = bl ? 88 : 112;
        return (n3 + n2 * 16) * n2;
    }
}

