/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec.encoder;

import com.ailiwean.core.zxing.core.aztec.encoder.Token;
import com.ailiwean.core.zxing.core.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short binaryShiftByteCount;
    private final short binaryShiftStart;

    BinaryShiftToken(Token token, int n2, int n3) {
        super(token);
        this.binaryShiftStart = (short)n2;
        this.binaryShiftByteCount = (short)n3;
    }

    @Override
    public void appendTo(BitArray bitArray, byte[] byArray) {
        int n2;
        for (int i3 = 0; i3 < (n2 = this.binaryShiftByteCount); ++i3) {
            if (i3 == 0 || i3 == 31 && n2 <= 62) {
                bitArray.appendBits(31, 5);
                n2 = this.binaryShiftByteCount;
                if (n2 > 62) {
                    bitArray.appendBits(n2 - 31, 16);
                } else if (i3 == 0) {
                    bitArray.appendBits(Math.min(n2, 31), 5);
                } else {
                    bitArray.appendBits(n2 - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.binaryShiftStart + i3], 8);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.binaryShiftStart);
        stringBuilder.append("::");
        stringBuilder.append(this.binaryShiftStart + this.binaryShiftByteCount - 1);
        stringBuilder.append('>');
        return stringBuilder.toString();
    }
}

