/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec.detector;

import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.aztec.AztecDetectorResult;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.GridSampler;
import com.ailiwean.core.zxing.core.common.detector.MathUtils;
import com.ailiwean.core.zxing.core.common.detector.WhiteRectangleDetector;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonDecoder;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};
    private boolean compact;
    private final BitMatrix image;
    private int nbCenterLayers;
    private int nbDataBlocks;
    private int nbLayers;
    private int shift;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.distance(resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private static float distance(Point point, Point point2) {
        return MathUtils.distance(point.getX(), point.getY(), point2.getX(), point2.getY());
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, int n2, int n3) {
        float f3 = (float)n3 / ((float)n2 * 2.0f);
        float f4 = resultPointArray[0].getX();
        float f5 = resultPointArray[2].getX();
        float f6 = resultPointArray[0].getY();
        float f7 = resultPointArray[2].getY();
        float f8 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f9 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        f4 = (f4 - f5) * f3;
        f6 = (f6 - f7) * f3;
        ResultPoint resultPoint = new ResultPoint(f8 + f4, f9 + f6);
        ResultPoint resultPoint2 = new ResultPoint(f8 - f4, f9 - f6);
        f4 = resultPointArray[1].getX();
        f5 = resultPointArray[3].getX();
        f6 = resultPointArray[1].getY();
        f7 = resultPointArray[3].getY();
        f9 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        f8 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        f4 = (f4 - f5) * f3;
        return new ResultPoint[]{resultPoint, new ResultPoint(f9 + f4, f8 + (f3 *= f6 - f7)), resultPoint2, new ResultPoint(f9 - f4, f8 - f3)};
    }

    private void extractParameters(ResultPoint[] resultPointArray) throws NotFoundException {
        if (this.isValid(resultPointArray[0]) && this.isValid(resultPointArray[1]) && this.isValid(resultPointArray[2]) && this.isValid(resultPointArray[3])) {
            int n2;
            int n3 = this.nbCenterLayers * 2;
            int[] nArray = new int[]{this.sampleLine(resultPointArray[0], resultPointArray[1], n3), this.sampleLine(resultPointArray[1], resultPointArray[2], n3), this.sampleLine(resultPointArray[2], resultPointArray[3], n3), this.sampleLine(resultPointArray[3], resultPointArray[0], n3)};
            this.shift = Detector.getRotation(nArray, n3);
            long l3 = 0L;
            for (n2 = 0; n2 < 4; ++n2) {
                long l4;
                n3 = nArray[(this.shift + n2) % 4];
                if (this.compact) {
                    l4 = l3 << 7;
                    l3 = n3 >> 1 & 0x7F;
                } else {
                    l4 = l3 << 10;
                    l3 = (n3 >> 2 & 0x3E0) + (n3 >> 1 & 0x1F);
                }
                l3 = l4 + l3;
            }
            n2 = Detector.getCorrectedParameterData(l3, this.compact);
            if (this.compact) {
                this.nbLayers = (n2 >> 6) + 1;
                this.nbDataBlocks = (n2 & 0x3F) + 1;
            } else {
                this.nbLayers = (n2 >> 11) + 1;
                this.nbDataBlocks = (n2 & 0x7FF) + 1;
            }
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint[] getBullsEyeCorners(Point object) throws NotFoundException {
        int n2;
        Object object2;
        Object object3;
        this.nbCenterLayers = 1;
        Object object4 = object3 = (object2 = object);
        boolean bl = true;
        while (this.nbCenterLayers < 9) {
            double d3;
            Point point = this.getFirstDifferent((Point)object, bl, 1, -1);
            Point point2 = this.getFirstDifferent((Point)object2, bl, 1, 1);
            Point point3 = this.getFirstDifferent((Point)object3, bl, -1, 1);
            Point point4 = this.getFirstDifferent((Point)object4, bl, -1, -1);
            if (this.nbCenterLayers > 2 && ((d3 = (double)(Detector.distance(point4, point) * (float)this.nbCenterLayers / (Detector.distance((Point)object4, (Point)object) * (float)(this.nbCenterLayers + 2)))) < 0.75 || d3 > 1.25 || !this.isWhiteOrBlackRectangle(point, point2, point3, point4))) break;
            bl ^= true;
            ++this.nbCenterLayers;
            object4 = point4;
            object = point;
            object2 = point2;
            object3 = point3;
        }
        if ((n2 = this.nbCenterLayers) != 5 && n2 != 7) {
            throw NotFoundException.getNotFoundInstance();
        }
        bl = this.nbCenterLayers == 5;
        this.compact = bl;
        object = new ResultPoint((float)((Point)object).getX() + 0.5f, (float)((Point)object).getY() - 0.5f);
        object2 = new ResultPoint((float)((Point)object2).getX() + 0.5f, (float)((Point)object2).getY() + 0.5f);
        object3 = new ResultPoint((float)((Point)object3).getX() - 0.5f, (float)((Point)object3).getY() + 0.5f);
        object4 = new ResultPoint((float)((Point)object4).getX() - 0.5f, (float)((Point)object4).getY() - 0.5f);
        n2 = this.nbCenterLayers;
        return Detector.expandSquare(new ResultPoint[]{object, object2, object3, object4}, n2 * 2 - 3, n2 * 2);
    }

    private int getColor(Point point, Point point2) {
        float f3 = Detector.distance(point, point2);
        float f4 = (float)(point2.getX() - point.getX()) / f3;
        float f5 = (float)(point2.getY() - point.getY()) / f3;
        float f6 = point.getX();
        float f7 = point.getY();
        boolean bl = this.image.get(point.getX(), point.getY());
        int n2 = (int)Math.ceil(f3);
        boolean bl2 = false;
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n4 = n3;
            if (this.image.get(MathUtils.round(f6 += f4), MathUtils.round(f7 += f5)) != bl) {
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        f7 = (float)n3 / f3;
        if (f7 > 0.1f && f7 < 0.9f) {
            return 0;
        }
        n3 = 1;
        if (f7 <= 0.1f) {
            bl2 = true;
        }
        if (bl2 != bl) {
            n3 = -1;
        }
        return n3;
    }

    private static int getCorrectedParameterData(long l3, boolean bl) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        if (bl) {
            n4 = 7;
            n3 = 2;
        } else {
            n4 = 10;
            n3 = 4;
        }
        int[] nArray = new int[n4];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            nArray[n2] = (int)l3 & 0xF;
            l3 >>= 4;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, n4 - n3);
            n2 = 0;
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (n4 = 0; n4 < n3; ++n4) {
            n2 = (n2 << 4) + nArray[n4];
        }
        return n2;
    }

    private int getDimension() {
        if (this.compact) {
            return this.nbLayers * 4 + 11;
        }
        int n2 = this.nbLayers;
        if (n2 <= 4) {
            return n2 * 4 + 15;
        }
        return n2 * 4 + ((n2 - 4) / 8 + 1) * 2 + 15;
    }

    private Point getFirstDifferent(Point point, boolean bl, int n2, int n3) {
        int n4 = point.getX() + n2;
        int n5 = point.getY();
        while (this.isValid(n4, n5 += n3) && this.image.get(n4, n5) == bl) {
            n4 += n2;
        }
        n4 -= n2;
        n5 -= n3;
        while (this.isValid(n4, n5) && this.image.get(n4, n5) == bl) {
            n4 += n2;
        }
        n4 -= n2;
        n2 = n5;
        while (this.isValid(n4, n2) && this.image.get(n4, n2) == bl) {
            n2 += n3;
        }
        return new Point(n4, n2 - n3);
    }

    private Point getMatrixCenter() {
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object3;
        Object object4;
        try {
            object4 = new WhiteRectangleDetector(this.image);
            object3 = ((WhiteRectangleDetector)object4).detect();
        }
        catch (NotFoundException notFoundException) {
            n5 = this.image.getWidth() / 2;
            n4 = this.image.getHeight() / 2;
            n3 = n5 + 7;
            n2 = n4 - 7;
            object4 = this.getFirstDifferent(new Point(n3, n2), false, 1, -1).toResultPoint();
            object2 = this.getFirstDifferent(new Point(n3, n4 += 7), false, 1, 1).toResultPoint();
            n3 = n5 - 7;
            object = this.getFirstDifferent(new Point(n3, n4), false, -1, 1).toResultPoint();
            object3 = this.getFirstDifferent(new Point(n3, n2), false, -1, -1).toResultPoint();
        }
        object4 = object3[0];
        object2 = object3[1];
        object = object3[2];
        object3 = object3[3];
        n4 = MathUtils.round((((ResultPoint)object4).getX() + ((ResultPoint)object3).getX() + ((ResultPoint)object2).getX() + ((ResultPoint)object).getX()) / 4.0f);
        n3 = MathUtils.round((((ResultPoint)object4).getY() + ((ResultPoint)object3).getY() + ((ResultPoint)object2).getY() + ((ResultPoint)object).getY()) / 4.0f);
        try {
            object4 = new WhiteRectangleDetector(this.image, 15, n4, n3);
            object3 = ((WhiteRectangleDetector)object4).detect();
        }
        catch (NotFoundException notFoundException) {
            n5 = n4 + 7;
            n2 = n3 - 7;
            object2 = this.getFirstDifferent(new Point(n5, n2), false, 1, -1).toResultPoint();
            object = this.getFirstDifferent(new Point(n5, n3 += 7), false, 1, 1).toResultPoint();
            object4 = this.getFirstDifferent(new Point(n4 -= 7, n3), false, -1, 1).toResultPoint();
            object3 = this.getFirstDifferent(new Point(n4, n2), false, -1, -1).toResultPoint();
        }
        object2 = object3[0];
        object = object3[1];
        object4 = object3[2];
        object3 = object3[3];
        return new Point(MathUtils.round((((ResultPoint)object2).getX() + ((ResultPoint)object3).getX() + ((ResultPoint)object).getX() + ((ResultPoint)object4).getX()) / 4.0f), MathUtils.round((((ResultPoint)object2).getY() + ((ResultPoint)object3).getY() + ((ResultPoint)object).getY() + ((ResultPoint)object4).getY()) / 4.0f));
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, this.nbCenterLayers * 2, this.getDimension());
    }

    private static int getRotation(int[] nArray, int n2) throws NotFoundException {
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = nArray[i3];
            n5 = (n5 << 3) + ((n6 >> n2 - 2 << 1) + (n6 & 1));
        }
        for (n2 = n4; n2 < 4; ++n2) {
            if (Integer.bitCount(EXPECTED_CORNER_BITS[n2] ^ ((n5 & 1) << 11) + (n5 >> 1)) > 2) continue;
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private boolean isValid(int n2, int n3) {
        boolean bl = n2 >= 0 && n2 < this.image.getWidth() && n3 > 0 && n3 < this.image.getHeight();
        return bl;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return this.isValid(MathUtils.round(resultPoint.getX()), MathUtils.round(resultPoint.getY()));
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        point = new Point(point.getX() - 3, point.getY() + 3);
        point2 = new Point(point2.getX() - 3, point2.getY() - 3);
        point3 = new Point(point3.getX() + 3, point3.getY() - 3);
        point4 = new Point(point4.getX() + 3, point4.getY() + 3);
        int n2 = this.getColor(point4, point);
        boolean bl = false;
        if (n2 == 0) {
            return false;
        }
        if (this.getColor(point, point2) != n2) {
            return false;
        }
        if (this.getColor(point2, point3) != n2) {
            return false;
        }
        if (this.getColor(point3, point4) == n2) {
            bl = true;
        }
        return bl;
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        int n2 = this.getDimension();
        float f3 = (float)n2 / 2.0f;
        int n3 = this.nbCenterLayers;
        float f4 = f3 - (float)n3;
        return gridSampler.sampleGrid(bitMatrix, n2, n2, f4, f4, f3 += (float)n3, f4, f3, f3, f4, f3, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint4.getX(), resultPoint4.getY());
    }

    private int sampleLine(ResultPoint object, ResultPoint resultPoint, int n2) {
        float f3 = Detector.distance((ResultPoint)object, resultPoint);
        float f4 = f3 / (float)n2;
        float f5 = ((ResultPoint)object).getX();
        float f6 = ((ResultPoint)object).getY();
        float f7 = (resultPoint.getX() - ((ResultPoint)object).getX()) * f4 / f3;
        f3 = f4 * (resultPoint.getY() - ((ResultPoint)object).getY()) / f3;
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            object = this.image;
            f4 = i3;
            int n4 = n3;
            if (((BitMatrix)object).get(MathUtils.round(f4 * f7 + f5), MathUtils.round(f4 * f3 + f6))) {
                n4 = n3 | 1 << n2 - i3 - 1;
            }
            n3 = n4;
        }
        return n3;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl) throws NotFoundException {
        Object object;
        ResultPoint[] resultPointArray = this.getBullsEyeCorners(this.getMatrixCenter());
        if (bl) {
            object = resultPointArray[0];
            resultPointArray[0] = resultPointArray[2];
            resultPointArray[2] = object;
        }
        this.extractParameters(resultPointArray);
        object = this.image;
        int n2 = this.shift;
        return new AztecDetectorResult(this.sampleGrid((BitMatrix)object, resultPointArray[n2 % 4], resultPointArray[(n2 + 1) % 4], resultPointArray[(n2 + 2) % 4], resultPointArray[(n2 + 3) % 4]), this.getMatrixCornerPoints(resultPointArray), this.compact, this.nbDataBlocks, this.nbLayers);
    }

    static final class Point {
        private final int x;
        private final int y;

        Point(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        ResultPoint toResultPoint() {
            return new ResultPoint(this.x, this.y);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<");
            stringBuilder.append(this.x);
            stringBuilder.append(' ');
            stringBuilder.append(this.y);
            stringBuilder.append('>');
            return stringBuilder.toString();
        }
    }
}

